/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.labels;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.mojang.datafixers.util.Unit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import net.minecraft.class_9695;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.vegandelightfabric.labels.VeganDataComponents;
import net.player005.vegandelightfabric.labels.VeganTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class VeganLabels {
    private static final Map<class_1792, VeganStatus> veganFromRecipes = new HashMap<class_1792, VeganStatus>();
    private static boolean debugMode = false;

    @ApiStatus.Internal
    public static void initialize() {
        RecipeModification.registerGlobalResultModifier((recipe, result, recipeInput) -> {
            if (recipeInput != null) {
                VeganLabels.modifyRecipeResult(recipeInput, result);
            }
            return result;
        });
        Stopwatch timer = Stopwatch.createStarted();
        ArrayList<class_1792> traversedList = new ArrayList<class_1792>(class_7923.field_41178.method_10204());
        for (class_1792 item : class_7923.field_41178) {
            if (traversedList.contains(item)) continue;
            VeganLabels.scanRecipesRecursively(item, traversedList);
        }
        LoggerFactory.getLogger(VeganLabels.class).info("Scanned {} items for vegan recipes in {}", (Object)class_7923.field_41178.method_10204(), (Object)timer);
    }

    public static VeganStatus isVegan(class_1799 itemStack) {
        Boolean fromComponent = (Boolean)itemStack.method_57824((class_9331)VeganDataComponents.is_vegan.comp_349());
        if (fromComponent != null) {
            return VeganStatus.fromBoolean(fromComponent);
        }
        if (itemStack.method_31573(VeganTags.VEGAN)) {
            return VeganStatus.VEGAN;
        }
        if (itemStack.method_31573(VeganTags.NOT_VEGAN)) {
            return VeganStatus.NOT_VEGAN;
        }
        return veganFromRecipes.getOrDefault(itemStack.method_7909(), VeganStatus.UNKNOWN);
    }

    public static void setIsVegan(class_1799 stack, boolean isVegan) {
        boolean isFood;
        boolean bl = isFood = stack.method_31573(VeganTags.SHOULD_HAVE_DATA_COMPONENTS_ADDED) || stack.method_7976() == class_1839.field_8950 || stack.method_7976() == class_1839.field_8946;
        if (!isFood && !stack.method_57826((class_9331)VeganDataComponents.contains_substitutes.comp_349())) {
            return;
        }
        VeganStatus currentStatus = VeganLabels.isVegan(stack);
        if (stack.method_57826((class_9331)VeganDataComponents.is_vegan.comp_349())) {
            return;
        }
        if (isVegan && (currentStatus == VeganStatus.VEGAN || currentStatus == VeganStatus.UNKNOWN)) {
            return;
        }
        if (!isVegan && currentStatus == VeganStatus.NOT_VEGAN) {
            return;
        }
        stack.method_57379((class_9331)VeganDataComponents.is_vegan.comp_349(), (Object)isVegan);
    }

    private static void scanRecipesRecursively(class_1792 item, List<class_1792> alreadyTraversed) {
        alreadyTraversed.add(item);
        ImmutableCollection recipes = RecipeModification.getRecipesByResult((class_1792)item);
        int veganRecipes = 0;
        int nonVeganRecipes = 0;
        for (class_8786 recipeHolder : recipes) {
            if (VeganLabels.recipeNotVegan(alreadyTraversed, recipeHolder.comp_1933())) {
                ++nonVeganRecipes;
                continue;
            }
            ++veganRecipes;
        }
        VeganStatus result = VeganStatus.UNKNOWN;
        if (veganRecipes > nonVeganRecipes) {
            result = VeganStatus.VEGAN;
        }
        if (veganRecipes < nonVeganRecipes) {
            result = VeganStatus.NOT_VEGAN;
        }
        int differencePercentage = (int)(100.0f * (float)Math.abs(veganRecipes - nonVeganRecipes) / (float)recipes.size());
        if (recipes.size() > 1 && differencePercentage < 20) {
            result = VeganStatus.UNKNOWN;
        }
        veganFromRecipes.put(item, result);
    }

    private static boolean recipeNotVegan(List<class_1792> alreadyTraversed, class_1860<?> recipe) {
        for (class_1856 ingredient : recipe.method_8117()) {
            int nonVeganItems = 0;
            int total = 0;
            for (class_1799 itemStack : ingredient.method_8105()) {
                if (itemStack.method_31573(VeganTags.VEGAN_ALTERNATIVE)) continue;
                VeganStatus vegan = VeganLabels.isVegan(itemStack);
                if (vegan == VeganStatus.UNKNOWN) {
                    class_1792 unknownItem = itemStack.method_7909();
                    if (!alreadyTraversed.contains(unknownItem)) {
                        VeganLabels.scanRecipesRecursively(unknownItem, alreadyTraversed);
                    }
                    vegan = veganFromRecipes.getOrDefault(unknownItem, VeganStatus.UNKNOWN);
                }
                if (vegan == VeganStatus.NOT_VEGAN) {
                    ++nonVeganItems;
                }
                ++total;
            }
            if (!((float)nonVeganItems / (float)total >= 0.5f)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldRenderTooltip(class_1799 itemStack) {
        return !Boolean.FALSE.equals(itemStack.method_57824((class_9331)VeganDataComponents.is_vegan.comp_349())) && !itemStack.method_31573(VeganTags.VEGAN_ALTERNATIVE) && itemStack.method_57353().method_57832((class_9331)VeganDataComponents.contains_substitutes.comp_349());
    }

    public static void addTooltipLines(class_1799 stack, List<class_2561> tooltip) {
        if (Boolean.FALSE.equals(stack.method_57824((class_9331)VeganDataComponents.is_vegan.comp_349()))) {
            tooltip.add(1, (class_2561)class_2561.method_43470((String)"Not vegan").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))));
        }
        if (debugMode) {
            tooltip.add(1, (class_2561)class_2561.method_43470((String)("Result: " + VeganLabels.isVegan(stack).name())));
            tooltip.add(1, (class_2561)class_2561.method_43470((String)("Default from recipes: " + String.valueOf((Object)veganFromRecipes.get(stack.method_7909())))));
            tooltip.add(1, (class_2561)class_2561.method_43470((String)("Component: " + String.valueOf(stack.method_57824((class_9331)VeganDataComponents.is_vegan.comp_349())))));
        }
        if (!VeganLabels.shouldRenderTooltip(stack)) {
            return;
        }
        tooltip.add(1, (class_2561)class_2561.method_43470((String)"Vegan").method_10862(class_2583.field_24360.method_36139(35908).method_10978(Boolean.valueOf(true)).method_10982(Boolean.valueOf(true))));
    }

    private static void modifyRecipeResult(class_9695 recipeInput, class_1799 result) {
        boolean vegan = true;
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1799 item = recipeInput.method_59984(i);
            if (VeganLabels.isVegan(item) == VeganStatus.NOT_VEGAN) {
                vegan = false;
            }
            if (!item.method_31573(VeganTags.VEGAN_ALTERNATIVE) && !item.method_57826((class_9331)VeganDataComponents.contains_substitutes.comp_349())) continue;
            result.method_57379((class_9331)VeganDataComponents.contains_substitutes.comp_349(), (Object)Unit.INSTANCE);
        }
        VeganLabels.setIsVegan(result, vegan);
    }

    public static enum VeganStatus {
        VEGAN,
        NOT_VEGAN,
        UNKNOWN;


        static VeganStatus fromBoolean(@Nullable Boolean b) {
            if (b == null) {
                return UNKNOWN;
            }
            return b != false ? VEGAN : NOT_VEGAN;
        }
    }
}

