/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.inventory.power;

import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class FabricPolyEnergyWrapper
implements IPolyEnergyStorage {
    private final EnergyStorage storage;

    public FabricPolyEnergyWrapper(EnergyStorage storage) {
        this.storage = storage;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = this.storage.insert(maxReceive, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long extracted = this.storage.extract(maxExtract, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = extracted;
            return l;
        }
    }

    @Override
    public long getEnergyStored() {
        return this.storage.getAmount();
    }

    @Override
    public long getMaxEnergyStored() {
        return this.storage.getCapacity();
    }

    @Override
    public boolean canExtract() {
        return this.storage.supportsExtraction();
    }

    @Override
    public boolean canReceive() {
        return this.storage.supportsInsertion();
    }

    @Override
    public long modifyEnergyStored(long amount) {
        if ((amount = Math.min(Math.max(amount, Integer.MIN_VALUE), Integer.MAX_VALUE)) > 0L) {
            return this.receiveEnergy((int)amount, false);
        }
        return this.extractEnergy((int)(-amount), false);
    }
}

