/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.render;

import java.util.Arrays;
import net.creeperhost.polylib.client.model.Model3D;
import net.creeperhost.polylib.client.render.RenderUtils;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class RenderResizableCuboid {
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;
    protected class_898 manager = class_310.method_1551().method_1561();

    private static Vector3f withValue(Vector3f vector, class_2350.class_2351 axis, float value) {
        if (axis == class_2350.class_2351.field_11048) {
            return new Vector3f(value, vector.y(), vector.z());
        }
        if (axis == class_2350.class_2351.field_11052) {
            return new Vector3f(vector.x(), value, vector.z());
        }
        if (axis == class_2350.class_2351.field_11051) {
            return new Vector3f(vector.x(), vector.y(), value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + String.valueOf(vector) + ")");
    }

    public static double getValue(Vector3d vector, class_2350.class_2351 axis) {
        if (axis == class_2350.class_2351.field_11048) {
            return vector.x;
        }
        if (axis == class_2350.class_2351.field_11052) {
            return vector.y;
        }
        if (axis == class_2350.class_2351.field_11051) {
            return vector.z;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + String.valueOf(vector) + ")");
    }

    public void renderCube(Model3D cube, class_4587 matrix, class_4588 buffer, int argb, int light) {
        float red = RenderUtils.getRed(argb);
        float green = RenderUtils.getGreen(argb);
        float blue = RenderUtils.getBlue(argb);
        float alpha = RenderUtils.getAlpha(argb);
        Vector3d size = new Vector3d(cube.sizeX(), cube.sizeY(), cube.sizeZ());
        matrix.method_22903();
        matrix.method_22904(cube.minX, cube.minY, cube.minZ);
        Matrix4f matrix4f = matrix.method_23760().method_23761();
        for (class_2350 face : class_2350.values()) {
            int ordinal;
            class_1058 sprite;
            if (!cube.shouldSideRender(face) || (sprite = cube.textures[ordinal = face.ordinal()]) == null) continue;
            class_2350.class_2351 u = face.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
            class_2350.class_2351 v = face.method_10166() == class_2350.class_2351.field_11052 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11052;
            float other = face.method_10171() == class_2350.class_2352.field_11056 ? (float)RenderResizableCuboid.getValue(size, face.method_10166()) : 0.0f;
            face = face.method_10171() == class_2350.class_2352.field_11060 ? face : face.method_10153();
            class_2350 opposite = face.method_10153();
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4575();
            float maxV = sprite.method_4593();
            double sizeU = RenderResizableCuboid.getValue(size, u);
            double sizeV = RenderResizableCuboid.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    addU = sizeU - (double)uIndex;
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        addV = sizeV - (double)vIndex;
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.method_22909();
    }

    private void renderPoint(Matrix4f matrix4f, class_4588 buffer, class_2350 face, class_2350.class_2351 u, class_2350.class_2351 v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light) {
        int uFinal = minU ? 0 : 1;
        int vFinal = minV ? 2 : 3;
        Vector3f vertex = RenderResizableCuboid.withValue(VEC_ZERO, u, xyz[uFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, v, xyz[vFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, face.method_10166(), other);
        buffer.method_22918(matrix4f, vertex.x(), vertex.y(), vertex.z()).method_22915(red, green, blue, alpha).method_22913(uv[uFinal], uv[vFinal]).method_60803(light);
    }
}

