/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import java.util.function.Consumer;
import java.util.function.Supplier;

public interface TextState {
    public String getText();

    public void setText(String var1);

    public static TextState simpleState(final String defaultValue) {
        return new TextState(){
            private String value;
            {
                this.value = defaultValue;
            }

            @Override
            public String getText() {
                return this.value;
            }

            @Override
            public void setText(String text) {
                this.value = text;
            }
        };
    }

    public static TextState simpleState(final String defaultValue, final Consumer<String> changeListener) {
        return new TextState(){
            private String value;
            {
                this.value = defaultValue;
            }

            @Override
            public String getText() {
                return this.value;
            }

            @Override
            public void setText(String text) {
                this.value = text;
                changeListener.accept(this.value);
            }
        };
    }

    public static TextState create(final Supplier<String> getValue, final Consumer<String> setValue) {
        return new TextState(){

            @Override
            public String getText() {
                return (String)getValue.get();
            }

            @Override
            public void setText(String text) {
                setValue.accept(text);
            }
        };
    }
}

