/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorHelper {
    public static final class_2960 DRAG = class_2960.method_60655((String)"polylib", (String)"textures/gui/cursors/drag.png");
    public static final class_2960 RESIZE_H = class_2960.method_60655((String)"polylib", (String)"textures/gui/cursors/resize_h.png");
    public static final class_2960 RESIZE_V = class_2960.method_60655((String)"polylib", (String)"textures/gui/cursors/resize_v.png");
    public static final class_2960 RESIZE_TRBL = class_2960.method_60655((String)"polylib", (String)"textures/gui/cursors/resize_diag_trbl.png");
    public static final class_2960 RESIZE_TLBR = class_2960.method_60655((String)"polylib", (String)"textures/gui/cursors/resize_diag_tlbr.png");
    private static Map<class_2960, Long> cursors = new HashMap<class_2960, Long>();
    private static class_2960 active = null;

    public static void init() {
        ClientGuiEvent.SET_SCREEN.register(screen -> {
            CursorHelper.resetCursor();
            return CompoundEventResult.pass();
        });
    }

    private static long createCursor(class_2960 resource) {
        try {
            BufferedImage bufferedimage = ImageIO.read(((class_3298)class_310.method_1551().method_1478().method_14486(resource).get()).method_14482());
            GLFWImage glfwImage = CursorHelper.imageToGLFWImage(bufferedimage);
            return GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)16, (int)16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static GLFWImage imageToGLFWImage(BufferedImage image) {
        if (image.getType() != 3) {
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
            Graphics2D graphics = convertedImage.createGraphics();
            int targetWidth = image.getWidth();
            int targetHeight = image.getHeight();
            graphics.drawImage(image, 0, 0, targetWidth, targetHeight, null);
            graphics.dispose();
            image = convertedImage;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer.put((byte)(colorSpace << 8 >> 24));
                buffer.put((byte)(colorSpace << 16 >> 24));
                buffer.put((byte)(colorSpace << 24 >> 24));
                buffer.put((byte)(colorSpace >> 24));
            }
        }
        buffer.flip();
        GLFWImage result = GLFWImage.create();
        result.set(image.getWidth(), image.getHeight(), buffer);
        return result;
    }

    public static void setCursor(@Nullable class_2960 cursor) {
        if (cursor != active) {
            active = cursor;
            long window = class_310.method_1551().method_22683().method_4490();
            long newCursor = active == null ? 0L : cursors.computeIfAbsent(cursor, CursorHelper::createCursor);
            try {
                GLFW.glfwSetCursor((long)window, (long)newCursor);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetCursor() {
        if (active != null) {
            CursorHelper.setCursor(null);
        }
    }
}

