/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ColourState {
    public int get();

    public void set(int var1);

    default public void set(int a, int r, int g, int b) {
        this.set(a << 24 | r << 16 | g << 8 | b);
    }

    default public void set(int r, int g, int b) {
        this.set(r << 16 | g << 8 | b);
    }

    default public void set(float a, float r, float g, float b) {
        this.set((int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    default public void set(float r, float g, float b) {
        this.set((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    default public void setAlpha(int a) {
        this.set(this.get() & 0xFFFFFF | a << 24);
    }

    default public void setRed(int r) {
        this.set(this.get() & 0xFF00FFFF | r << 16);
    }

    default public void setGreen(int g) {
        this.set(this.get() & 0xFFFF00FF | g << 8);
    }

    default public void setBlue(int b) {
        this.set(this.get() & 0xFFFFFF00 | b);
    }

    default public void setAlpha(float a) {
        this.setAlpha((int)(a * 255.0f));
    }

    default public void setRed(float r) {
        this.setRed((int)(r * 255.0f));
    }

    default public void setGreen(float g) {
        this.setGreen((int)(g * 255.0f));
    }

    default public void setBlue(float b) {
        this.setBlue((int)(b * 255.0f));
    }

    default public int alphaI() {
        return this.get() >> 24 & 0xFF;
    }

    default public int redI() {
        return this.get() >> 16 & 0xFF;
    }

    default public int greenI() {
        return this.get() >> 8 & 0xFF;
    }

    default public int blueI() {
        return this.get() & 0xFF;
    }

    default public float alpha() {
        return (float)this.alphaI() / 255.0f;
    }

    default public float red() {
        return (float)this.redI() / 255.0f;
    }

    default public float green() {
        return (float)this.greenI() / 255.0f;
    }

    default public float blue() {
        return (float)this.blueI() / 255.0f;
    }

    default public String getHexColour() {
        return Integer.toHexString(this.get()).toUpperCase(Locale.ROOT);
    }

    default public void setHexColour(String hexColour) {
        try {
            this.set(Integer.parseUnsignedInt(hexColour, 16));
        }
        catch (Throwable e) {
            this.set(0);
        }
    }

    public static ColourState create() {
        return ColourState.create(null);
    }

    public static ColourState create(final Consumer<Integer> listener) {
        return new ColourState(){
            int colour = 0;

            @Override
            public int get() {
                return this.colour;
            }

            @Override
            public void set(int colour) {
                this.colour = colour;
                if (listener != null) {
                    listener.accept(colour);
                }
            }
        };
    }

    public static ColourState create(final Supplier<Integer> getter, final Consumer<Integer> setter) {
        return new ColourState(){

            @Override
            public int get() {
                return (Integer)getter.get();
            }

            @Override
            public void set(int colour) {
                setter.accept(colour);
            }
        };
    }
}

