/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.screen;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.item.ModItems;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ModScreenHandlers;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.screenNetworking.ShopScreenPayload;
import net.spudacious5705.shops.screenNetworking.TabSyncPayload;
import net.spudacious5705.shops.screenNetworking.ToggleSyncPayload;
import org.jetbrains.annotations.Nullable;

public class ShopScreenHandlerOwner
extends class_1703 {
    private final AbstractShopEntity.settings_Delegate SETTINGS_DELEGATE;
    private SettingsUpdater SETTINGS_UPDATER = null;
    private WarningActivator warningActivator;
    final AbstractShopEntity.InventoryDelegate shopInventory;
    private final AbstractShopEntity.player_ID_Records_Delegate ID_RECORDS_DELEGATE;
    final class_1661 playerInventory;
    final PermissionLevel perms;
    final ScreenSettingsGroup SCREEN_SETTINGS;
    private final List<TogglableSlot> playerInvSlots = new ArrayList<TogglableSlot>();
    private final List<TogglableSlot> tabSellerSlots = new ArrayList<TogglableSlot>();
    final List<TogglableSlot> tabSettingsSlots = new ArrayList<TogglableSlot>();
    private final List<TogglableSlot> tabCustomerSlots = new ArrayList<TogglableSlot>();
    private widgetCollection widgets;
    private static final int profit_itemStacks_start = 54;
    static final int SELLER_TAB = 1;
    static final int SETTINGS_TAB = 2;
    static final int CUSTOMER_TAB = 3;
    static final int WARNING_TAB = 4;
    private int activeTab = 1;

    void initiateWarn(WarningActivator function) {
        this.warningActivator = function;
    }

    public void selfDemotePlayer(class_3222 player) {
        if (this.activeTab == 4) {
            this.ID_RECORDS_DELEGATE.selfDemote(player);
        }
    }

    public int getActiveTab() {
        return this.activeTab;
    }

    public boolean isPlayerCreative() {
        return this.SETTINGS_DELEGATE.isPlayerCreative();
    }

    void setWidgetFunction(widgetCollection c) {
        this.widgets = c;
    }

    public ShopScreenHandlerOwner(int syncId, class_1661 playerInventory, ShopScreenPayload payload) {
        super(ModScreenHandlers.SHOP_SCREEN_HANDLER_OWNER, syncId);
        class_2338 pos = payload.pos();
        boolean openTop = payload.openTop();
        class_1657 player = playerInventory.field_7546;
        this.playerInventory = playerInventory;
        playerInventory.method_5435(player);
        class_2586 class_25862 = player.method_37908().method_8321(pos);
        if (class_25862 instanceof AbstractShopEntity) {
            AbstractShopEntity shop = (AbstractShopEntity)class_25862;
            AbstractShopEntity.InventoryDelegate inventoryDelegate = null;
            if (openTop) {
                inventoryDelegate = shop.getOtherInventoryDelegate(player);
            }
            if (inventoryDelegate == null) {
                inventoryDelegate = shop.getInventoryDelegate(player);
            }
            ShopScreenHandlerOwner.method_17359((class_1263)inventoryDelegate, (int)78);
            this.shopInventory = inventoryDelegate;
            this.perms = this.shopInventory.checkPermissions();
            this.SCREEN_SETTINGS = shop.getScreenSettings();
            this.ID_RECORDS_DELEGATE = shop.getRecordsDelegate(player);
            this.SETTINGS_DELEGATE = shop.getSettingsDelegate(player);
            this.finishSetup();
        } else {
            class_310.method_1551().method_1507(null);
            this.shopInventory = null;
            this.SCREEN_SETTINGS = null;
            this.perms = PermissionLevel.CUSTOMER;
            this.ID_RECORDS_DELEGATE = null;
            this.SETTINGS_DELEGATE = null;
        }
    }

    public ShopScreenHandlerOwner(int syncId, class_1661 playerInventory, AbstractShopEntity.InventoryDelegate inventory, @Nullable AbstractShopEntity.player_ID_Records_Delegate idRecordsDelegate, AbstractShopEntity.settings_Delegate settingsDelegate, ScreenSettingsGroup screen_settings) {
        super(ModScreenHandlers.SHOP_SCREEN_HANDLER_OWNER, syncId);
        ShopScreenHandlerOwner.method_17359((class_1263)inventory, (int)78);
        this.shopInventory = inventory;
        this.perms = this.shopInventory.checkPermissions();
        this.SCREEN_SETTINGS = screen_settings;
        this.playerInventory = playerInventory;
        this.ID_RECORDS_DELEGATE = idRecordsDelegate;
        this.SETTINGS_DELEGATE = settingsDelegate;
        playerInventory.method_5435(playerInventory.field_7546);
        this.finishSetup();
    }

    private void finishSetup() {
        this.addPlayerInventory(this.playerInventory);
        this.addShopInventory();
        this.addShopTrades();
        this.addContractSlots();
        this.activeTab = 1;
        this.addSettingButtons();
    }

    private void addContractSlots() {
        int offsetx = 81;
        int offsety = 69;
        for (int y = 0; y < 4; ++y) {
            for (int i = 0; i < 6; ++i) {
                new contract_slot(this.ID_RECORDS_DELEGATE, y * 6 + i, offsetx + i * 23, offsety + y * 23);
            }
        }
    }

    private void addShopTrades() {
        int x = 25;
        int y = 31;
        new shop_trade_slot(this.shopInventory, 76, x, y);
        new shop_trade_slot(this.shopInventory, 77, x, y + 47);
        new shop_payment_slot(this.shopInventory, 76, 71, 126);
        new shop_vendor_slot(this.shopInventory, 77, 140, 126, this);
    }

    @Environment(value=EnvType.CLIENT)
    public void updateTabSelectionClientside(int tab) {
        this.activeTab = tab;
        ClientPlayNetworking.send((class_8710)new TabSyncPayload(this.activeTab));
        this.updateTabSelection();
    }

    public void updateTabSelectionServerside(int tab) {
        this.activeTab = tab;
    }

    public boolean toggleButtonServersideUpdate(ToggleSyncPayload.ToggleButtonID button, boolean state) {
        this.SETTINGS_DELEGATE.attemptSetState(button, state);
        return this.SETTINGS_DELEGATE.getState(button);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean updateTabSelectionResponse(int tab) {
        if (this.activeTab != tab) {
            this.activeTab = tab;
            this.updateTabSelection();
            return true;
        }
        return false;
    }

    public void updateTabSelection() {
        switch (this.activeTab) {
            case 2: {
                this.tabSettingsSlots.forEach(TogglableSlot::enable);
                this.widgets.setToVal(true);
                this.playerInvSlots.forEach(TogglableSlot::enable);
                this.tabSellerSlots.forEach(TogglableSlot::disable);
                this.tabCustomerSlots.forEach(TogglableSlot::disable);
                break;
            }
            case 3: {
                this.playerInvSlots.forEach(TogglableSlot::enable);
                this.tabCustomerSlots.forEach(TogglableSlot::enable);
                this.tabSettingsSlots.forEach(TogglableSlot::disable);
                this.widgets.setToVal(false);
                this.tabSellerSlots.forEach(TogglableSlot::disable);
                break;
            }
            case 4: {
                this.tabSettingsSlots.forEach(TogglableSlot::disable);
                this.widgets.setToVal(false);
                this.tabSellerSlots.forEach(TogglableSlot::disable);
                this.playerInvSlots.forEach(TogglableSlot::disable);
                this.tabCustomerSlots.forEach(TogglableSlot::disable);
                break;
            }
            default: {
                this.tabSellerSlots.forEach(TogglableSlot::enable);
                this.playerInvSlots.forEach(TogglableSlot::enable);
                this.tabSettingsSlots.forEach(TogglableSlot::disable);
                this.widgets.setToVal(false);
                this.tabCustomerSlots.forEach(TogglableSlot::disable);
            }
        }
    }

    void settingsUpdater(SettingsUpdater function) {
        this.SETTINGS_UPDATER = function;
    }

    @Environment(value=EnvType.CLIENT)
    public void updateToggleButtonFromPacket(ToggleSyncPayload.ToggleButtonID button, boolean state) {
        this.SETTINGS_UPDATER.updateSettings(button, state);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean handleToggleButtonInput(ToggleSyncPayload.ToggleButtonID button, boolean state) {
        if (this.SETTINGS_DELEGATE.attemptSetState(button, state)) {
            ClientPlayNetworking.send((class_8710)new ToggleSyncPayload(button.getSerialised(), state));
            return state;
        }
        return !state;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean getStateOfSetting(ToggleSyncPayload.ToggleButtonID button) {
        return this.SETTINGS_DELEGATE.getState(button);
    }

    private void addSettingButtons() {
    }

    private void addShopInventory() {
        int i;
        int offsetx = 59;
        int offsety = 15;
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.createShopInvSlot(j + i * 9, offsetx + j * 18, offsety + i * 18);
            }
        }
        offsetx -= 44;
        offsety += 110;
        for (i = 0; i < 11; ++i) {
            this.createShopInvSlot(54 + i, offsetx + i * 18, offsety);
        }
        offsety += 18;
        for (i = 0; i < 11; ++i) {
            this.createShopInvSlot(65 + i, offsetx + i * 18, offsety);
        }
    }

    private void createShopInvSlot(int index, int x, int y) {
        TogglableSlot slot = new TogglableSlot(this.shopInventory, index, x, y);
        this.tabSellerSlots.add(slot);
        this.method_7621(slot);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        int i;
        int offsetx = 33;
        int offsety = 174;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                new player_slot((class_1263)playerInventory, l + i * 9 + 9, offsetx + l * 18, offsety + i * 18);
            }
        }
        offsety += 58;
        for (i = 0; i < 9; ++i) {
            new player_slot((class_1263)playerInventory, i, offsetx + i * 18, offsety);
        }
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        if (this.activeTab == 3) {
            int tradeCount = 0;
            while (tradeCount < 64 & this.shopInventory.canTrade(player)) {
                this.shopInventory.trade(this.playerInventory);
                ++tradeCount;
            }
            return class_1799.field_8037;
        }
        if (this.activeTab != 1) {
            return class_1799.field_8037;
        }
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (!slot.method_7681()) {
            return newStack;
        }
        class_1799 originalStack = slot.method_7677();
        newStack = originalStack.method_7972();
        if (this.field_7761.get(invSlot) instanceof shop_trade_slot) {
            return class_1799.field_8037;
        }
        if (this.field_7761.get(invSlot) instanceof contract_slot) {
            return class_1799.field_8037;
        }
        if (this.field_7761.get(invSlot) instanceof player_slot ? !this.method_7616(originalStack, 36, 90, false) : !this.method_7616(originalStack, 0, 35, false)) {
            return class_1799.field_8037;
        }
        if (originalStack.method_7960()) {
            slot.method_53512(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        return newStack;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        return super.method_7616(stack, startIndex, endIndex, fromLast);
    }

    public boolean method_7597(class_1657 player) {
        return this.shopInventory.method_5443(player);
    }

    public ScreenSettingsGroup getSettings() {
        return this.SCREEN_SETTINGS;
    }

    private void trade() {
        this.shopInventory.trade(this.playerInventory);
    }

    public static boolean canMerge(class_1799 stack, class_1799 otherStack) {
        return class_1799.method_31577((class_1799)stack, (class_1799)otherStack);
    }

    static interface WarningActivator {
        public void openWarnScreen();
    }

    static interface widgetCollection {
        public void setToVal(boolean var1);
    }

    static interface SettingsUpdater {
        public void updateSettings(ToggleSyncPayload.ToggleButtonID var1, boolean var2);
    }

    class contract_slot
    extends TogglableSlot {
        private final ContractVerifier contractVerifier;

        public contract_slot(AbstractShopEntity.player_ID_Records_Delegate inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            ShopScreenHandlerOwner.this.tabSettingsSlots.add(this);
            this.contractVerifier = inventory::checkContract;
            ShopScreenHandlerOwner.this.method_7621(this);
            this.disable();
        }

        public int method_7675() {
            return 1;
        }

        public boolean method_7680(class_1799 stack) {
            if (AbstractShopEntity.player_ID_Records_Delegate.checkAction(stack, this.method_34266())) {
                return this.method_7677().method_7960();
            }
            return false;
        }

        public class_1799 method_32756(class_1799 stack) {
            return this.method_32755(stack, 0);
        }

        public class_1799 method_32755(class_1799 stack, int count) {
            if (!stack.method_7960() && stack.method_7909() == ModItems.CONTRACT_SCROLL) {
                return ((AbstractShopEntity.player_ID_Records_Delegate)this.field_7871).insertContract(stack, this.method_34266());
            }
            return stack;
        }

        public class_1799 method_7671(int amount) {
            if (this.contractVerifier.belongsToInteractor(this.method_7677())) {
                if (ShopScreenHandlerOwner.this.warningActivator != null) {
                    ShopScreenHandlerOwner.this.warningActivator.openWarnScreen();
                }
                return class_1799.field_8037;
            }
            return this.field_7871.method_5441(this.method_34266());
        }

        public boolean method_7674(class_1657 player) {
            if (this.contractVerifier.belongsToInteractor(this.method_7677())) {
                return true;
            }
            return this.field_7871.method_5443(player);
        }

        public int method_7676(class_1799 stack) {
            return 1;
        }

        public boolean method_32754(class_1657 player) {
            return false;
        }

        private static interface ContractVerifier {
            public boolean belongsToInteractor(class_1799 var1);
        }
    }

    class shop_trade_slot
    extends TogglableSlot {
        public shop_trade_slot(AbstractShopEntity.InventoryDelegate inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            ShopScreenHandlerOwner.this.tabSellerSlots.add(this);
            ShopScreenHandlerOwner.this.method_7621(this);
        }

        public class_1799 method_7671(int amount) {
            this.field_7871.method_5434(this.method_34266(), amount);
            return class_1799.field_8037;
        }

        public boolean method_7680(class_1799 stack) {
            if (ShopScreenHandlerOwner.canMerge(stack, this.method_7677())) {
                return true;
            }
            this.method_53512(class_1799.field_8037);
            return false;
        }

        public class_1799 method_32755(class_1799 stack, int count) {
            class_1799 oldStack = this.method_7677();
            if (stack.method_7909() == oldStack.method_7909()) {
                if ((count += oldStack.method_7947()) > 64) {
                    count = 64;
                }
                this.field_7871.method_5447(this.method_34266(), stack.method_46651(count));
            } else {
                this.field_7871.method_5447(this.method_34266(), stack.method_46651(count));
            }
            return stack;
        }

        public boolean method_32754(class_1657 player) {
            return true;
        }

        public class_1799 method_32756(class_1799 stack) {
            this.method_32755(stack, stack.method_7947());
            return stack;
        }
    }

    class shop_payment_slot
    extends TogglableSlot {
        public shop_payment_slot(AbstractShopEntity.InventoryDelegate inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            ShopScreenHandlerOwner.this.tabCustomerSlots.add(this);
            ShopScreenHandlerOwner.this.method_7621(this);
            this.disable();
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_32754(class_1657 player) {
            return false;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }

        public class_1799 method_32755(class_1799 stack, int count) {
            return stack;
        }

        public class_1799 method_32756(class_1799 stack) {
            return stack;
        }

        public void method_53512(class_1799 stack) {
        }

        public class_1799 method_7677() {
            return super.method_7677();
        }
    }

    class shop_vendor_slot
    extends TogglableSlot {
        private final ShopScreenHandlerOwner handler;

        public shop_vendor_slot(AbstractShopEntity.InventoryDelegate inventory, int index, int x, int y, ShopScreenHandlerOwner handler) {
            super(inventory, index, x, y);
            this.handler = handler;
            ShopScreenHandlerOwner.this.tabCustomerSlots.add(this);
            ShopScreenHandlerOwner.this.method_7621(this);
            this.disable();
        }

        public class_1799 method_7671(int amount) {
            this.handler.trade();
            return class_1799.field_8037;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return ShopScreenHandlerOwner.this.shopInventory.canTrade(playerEntity);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_32754(class_1657 player) {
            return false;
        }

        public class_1799 method_32755(class_1799 stack, int amount) {
            return stack;
        }

        public void method_53512(class_1799 stack) {
        }
    }

    static class TogglableSlot
    extends class_1735 {
        private boolean toggled = true;

        public TogglableSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7682() {
            return this.toggled;
        }

        public void enable() {
            this.toggled = true;
        }

        public void disable() {
            this.toggled = false;
        }
    }

    class player_slot
    extends TogglableSlot {
        public player_slot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            ShopScreenHandlerOwner.this.playerInvSlots.add(this);
            ShopScreenHandlerOwner.this.method_7621(this);
        }

        public boolean isPlayerSlot() {
            return true;
        }
    }
}

