/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.AngledShopEntity;
import net.spudacious5705.shops.item.custom.ShopItem;
import net.spudacious5705.shops.properties.Colour;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.util.CushionResources;
import org.jetbrains.annotations.Nullable;

public class AngledShopBlock
extends AbstractShopBlock
implements BlockPickInteractionAware {
    public static final class_265 CULLING_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)17.5);
    public static final class_265 BASE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final class_265 BASE_NORTH = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)12.0, (double)16.0), (class_265)BASE);
    public static final class_265 BASE_EAST = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0), (class_265)BASE);
    public static final class_265 BASE_SOUTH = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0), (class_265)BASE);
    public static final class_265 BASE_WEST = class_259.method_1084((class_265)class_2248.method_9541((double)2.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (class_265)BASE);
    public static final class_265 NORTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)1.0, (double)12.0, (double)3.0, (double)15.0, (double)15.0, (double)12.0), (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)15.0, (double)8.0, (double)15.0, (double)17.5, (double)15.0), BASE_NORTH});
    public static final class_265 EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)4.0, (double)12.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0), (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)15.0, (double)1.0, (double)8.0, (double)17.5, (double)15.0), BASE_EAST});
    public static final class_265 SOUTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)1.0, (double)12.0, (double)4.0, (double)15.0, (double)15.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)17.5, (double)8.0), BASE_SOUTH});
    public static final class_265 WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)3.0, (double)12.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0), (class_265[])new class_265[]{class_2248.method_9541((double)8.0, (double)15.0, (double)1.0, (double)15.0, (double)17.5, (double)15.0), BASE_WEST});
    public final class_1792 WOOD_TYPE;
    public final VariantResources.wood_variant VARIANT;
    private final Map<Colour, ShopItem> dropMap = new HashMap<Colour, ShopItem>();

    public AngledShopBlock(class_4970.class_2251 settings, class_1792 woodType, VariantResources.wood_variant variant) {
        super(settings, (class_2689.class_2691<class_2248, class_2680>)((class_2689.class_2691)AngledShopBlockState::new));
        VariantResources.ANGLED.put(woodType, this);
        this.WOOD_TYPE = woodType;
        this.VARIANT = variant;
    }

    public String getWoodName() {
        return this.VARIANT.name;
    }

    @Override
    public ScreenSettingsGroup getScreenSettings() {
        return ScreenSettingsGroup.createBasicWood(this.VARIANT);
    }

    public class_1792 method_8389() {
        return this.getDefaultColouredShopItem();
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (placer != null && placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof AngledShopEntity) {
                AngledShopEntity shopEntity = (AngledShopEntity)blockEntity;
                shopEntity.userSignIn(player);
                class_1792 class_17922 = itemStack.method_7909();
                if (class_17922 instanceof ShopItem) {
                    ShopItem item = (ShopItem)class_17922;
                    shopEntity.setCushionColour(item.colour);
                }
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AngledShopEntity(pos, state);
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 view, class_2338 pos, class_1657 player, class_239 result) {
        Colour colour = Colour.RED;
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof AngledShopEntity) {
            AngledShopEntity shopEntity = (AngledShopEntity)class_25862;
            colour = shopEntity.getCushionColour();
        }
        return this.getColouredShopItem(colour).method_7854();
    }

    @Override
    protected boolean onUseWithItem(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!stack.method_7960()) {
            class_1792 item = stack.method_7909();
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof AngledShopEntity) {
                AngledShopEntity shopEntity = (AngledShopEntity)class_25862;
                if (CushionResources.DYE_MAP.containsKey(item)) {
                    group = CushionResources.DYE_MAP.get(item);
                    if (shopEntity.getCushionColour() != group.colour()) {
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                        }
                        shopEntity.setCushionColour(group.colour());
                        world.method_45447(player, pos, class_3417.field_28391, class_3419.field_15245);
                        world.method_8413(pos, state, state, 2);
                        return true;
                    }
                } else if (CushionResources.WOOL_MAP.containsKey(item)) {
                    group = CushionResources.WOOL_MAP.get(item);
                    Colour originalColour = shopEntity.getCushionColour();
                    if (originalColour != group.colour()) {
                        shopEntity.setCushionColour(group.colour());
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                            group = CushionResources.COLOUR_MAP.get((Object)originalColour);
                            class_1799 releaseStack = new class_1799((class_1935)group.wool(), 1);
                            world.method_8649((class_1297)new class_1542(world, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.6f), (double)((float)pos.method_10260() + 0.5f), releaseStack, 0.0, (double)0.1f, 0.0));
                        }
                        world.method_45447(player, pos, class_3417.field_14975, class_3419.field_15245);
                        world.method_8413(pos, state, state, 2);
                        return true;
                    }
                } else if (VariantResources.ANGLED.containsKey(item)) {
                    class_2680 releaseStack;
                    AngledShopBlock block = VariantResources.ANGLED.get(item);
                    if (this.WOOD_TYPE != item && (releaseStack = block.method_9564()) instanceof AngledShopBlockState) {
                        AngledShopBlockState defaultShopState = (AngledShopBlockState)releaseStack;
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                            world.method_8649((class_1297)new class_1542(world, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), this.WOOD_TYPE.method_7854(), 0.0, (double)0.1f, 0.0));
                        }
                        class_2680 newBlockState = AngledShopBlock.importProperties(defaultShopState, state);
                        world.method_8501(pos, newBlockState);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.method_8608() ? (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof AngledShopEntity) {
                AngledShopEntity be = (AngledShopEntity)blockEntity;
                be.renderTick();
            }
        } : (world1, pos, shopState, blockEntity) -> {
            if (blockEntity instanceof AngledShopEntity) {
                AngledShopEntity be = (AngledShopEntity)blockEntity;
                be.serverTick((class_3218)world1, pos, (AngledShopBlockState)shopState);
            }
        };
    }

    private static class_2680 importProperties(class_2680 defaultState, class_2680 originalState) {
        return (class_2680)((class_2680)defaultState.method_11657((class_2769)FACING, (Comparable)((class_2350)originalState.method_11654((class_2769)FACING)))).method_11657((class_2769)BREAKABLE, (Comparable)((Boolean)originalState.method_11654((class_2769)BREAKABLE)));
    }

    public void addDropItem(ShopItem shopItem, Colour colour) {
        this.dropMap.put(colour, shopItem);
    }

    public ShopItem getColouredShopItem(@Nullable Colour colour) {
        return this.dropMap.getOrDefault((Object)colour, this.getDefaultColouredShopItem());
    }

    public ShopItem getDefaultColouredShopItem() {
        return this.dropMap.get((Object)Colour.RED);
    }

    public static class AngledShopBlockState
    extends AbstractShopBlock.AbstractShopBlockState {
        public AngledShopBlockState(class_2248 block, Reference2ObjectArrayMap<class_2769<?>, Comparable<?>> reference2ObjectArrayMap, MapCodec<class_2680> mapCodec) {
            super(block, reference2ObjectArrayMap, mapCodec);
        }

        @Override
        public class_265 method_26201(class_1922 world, class_2338 pos) {
            return CULLING_SHAPE;
        }

        @Override
        public class_265 method_26172(class_1922 world, class_2338 pos, class_3726 context) {
            return switch ((class_2350)this.method_11654((class_2769)AbstractShopBlock.FACING)) {
                case class_2350.field_11043 -> NORTH_SHAPE;
                case class_2350.field_11035 -> SOUTH_SHAPE;
                case class_2350.field_11034 -> EAST_SHAPE;
                case class_2350.field_11039 -> WEST_SHAPE;
                default -> CULLING_SHAPE;
            };
        }

        @Override
        protected boolean isStateReplacedValid(class_2680 newShopState) {
            return newShopState instanceof AngledShopBlockState;
        }

        @Override
        public class_265 method_26220(class_1922 world, class_2338 pos) {
            return switch ((class_2350)this.method_11654((class_2769)AbstractShopBlock.FACING)) {
                case class_2350.field_11043 -> BASE_NORTH;
                case class_2350.field_11035 -> BASE_SOUTH;
                case class_2350.field_11034 -> BASE_EAST;
                case class_2350.field_11039 -> BASE_WEST;
                default -> CULLING_SHAPE;
            };
        }
    }
}

