/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.function.Function;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.properties.ModProperties;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.screenNetworking.ShopScreenPayload;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShopBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 BREAKABLE = ModProperties.BREAKABLE;
    protected final class_2689<class_2248, class_2680> shopStateManager;

    public AbstractShopBlock(class_4970.class_2251 settings, class_2689.class_2691<class_2248, class_2680> shopBlockStateFactory) {
        super(settings);
        class_2689.class_2690 builder = new class_2689.class_2690((Object)this);
        builder.method_11667(new class_2769[]{BREAKABLE});
        this.method_9515((class_2689.class_2690<class_2248, class_2680>)builder);
        this.shopStateManager = builder.method_11668(class_2248::method_9564, shopBlockStateFactory);
        this.method_9590(this.defaultStateProperties((AbstractShopBlockState)((Object)((class_2680)this.shopStateManager.method_11664()).method_11657((class_2769)BREAKABLE, (Comparable)Boolean.valueOf(false)))));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    protected AbstractShopBlockState defaultStateProperties(AbstractShopBlockState state) {
        return (AbstractShopBlockState)((Object)state.method_11657((class_2769)FACING, (Comparable)class_2350.field_11035));
    }

    public final class_2689<class_2248, class_2680> method_9595() {
        return this.shopStateManager;
    }

    protected final ImmutableMap<class_2680, class_265> method_33615(Function<class_2680, class_265> stateToShape) {
        return (ImmutableMap)this.shopStateManager.method_11662().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), stateToShape));
    }

    public final class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (placer != null && placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof AbstractShopEntity) {
                AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
                shopEntity.userSignIn(player);
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.getPlacementState(ctx, (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)BREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    protected class_2680 getPlacementState(class_1750 ctx, class_2680 state) {
        return state;
    }

    @Nullable
    public abstract class_2586 method_10123(class_2338 var1, class_2680 var2);

    protected static PermissionLevel userSignIn(class_1937 world, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof AbstractShopEntity) {
            AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
            return shopEntity.userSignIn(player);
        }
        return PermissionLevel.CUSTOMER;
    }

    public class_6862<class_2248> getPreferredTool() {
        return class_3481.field_33713;
    }

    protected abstract boolean onUseWithItem(class_1799 var1, class_2680 var2, class_1937 var3, class_2338 var4, class_1657 var5);

    public abstract <T extends class_2586> class_5558<T> method_31645(class_1937 var1, class_2680 var2, class_2591<T> var3);

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        AbstractShopEntity shop;
        class_2586 be = world.method_8321(pos);
        if (be instanceof AbstractShopEntity && (shop = (AbstractShopEntity)be).isUnbreakable(player)) {
            if (world.method_8608()) {
                player.method_7353(shop.cantBreakMessage(), true);
            }
            return state;
        }
        if (player.method_7337()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)BREAKABLE, (Comparable)Boolean.valueOf(true)));
        }
        this.method_33614(world, player, pos, state);
        world.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
        return state;
    }

    public ScreenSettingsGroup getScreenSettings() {
        return ScreenSettingsGroup.createBasicWood(VariantResources.wood_variant.OAK);
    }

    public static abstract class AbstractShopBlockState
    extends class_2680 {
        public AbstractShopBlockState(class_2248 block, Reference2ObjectArrayMap<class_2769<?>, Comparable<?>> reference2ObjectArrayMap, MapCodec<class_2680> mapCodec) {
            super(block, reference2ObjectArrayMap, mapCodec);
        }

        public void method_26179(class_1937 world, class_2338 pos, class_1657 player) {
            if (this.method_26204() instanceof AbstractShopBlock) {
                AbstractShopEntity shop = (AbstractShopEntity)world.method_8321(pos);
                if (shop != null && shop.isUnbreakable(player)) {
                    world.method_8501(pos, (class_2680)this.method_47968((class_2769)BREAKABLE, Boolean.valueOf(false)));
                    if (world.method_8608()) {
                        player.method_7353(shop.cantBreakMessage(), true);
                    }
                    return;
                }
                world.method_8501(pos, (class_2680)this.method_47968((class_2769)BREAKABLE, Boolean.valueOf(true)));
                world.method_39280(pos, (class_2248)this.field_24739, 140, class_1953.field_9315);
            }
        }

        public final float method_26214(class_1922 world, class_2338 pos) {
            if (((Boolean)this.method_11654((class_2769)BREAKABLE)).booleanValue()) {
                return 2.0f;
            }
            return -1.0f;
        }

        public final void method_26192(class_3218 world, class_2338 pos, class_5819 random) {
            world.method_8501(pos, (class_2680)this.method_47968((class_2769)BREAKABLE, Boolean.valueOf(false)));
        }

        public class_1269 method_55781(class_1937 world, class_1657 player, class_3965 hit) {
            AbstractShopEntity shop;
            ExtendedScreenHandlerFactory<ShopScreenPayload> screenHandlerFactory;
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            class_2338 pos = hit.method_17777();
            class_1799 stack = player.method_5998(class_1268.field_5808);
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof AbstractShopEntity)) {
                return class_1269.field_5814;
            }
            PermissionLevel perm = AbstractShopBlock.userSignIn(world, pos, player);
            if (!stack.method_7960() && perm.canEditTrades() && ((AbstractShopBlock)this.method_26204()).onUseWithItem(stack, this.method_26233(), world, pos, player)) {
                return class_1269.field_5812;
            }
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof AbstractShopEntity && (screenHandlerFactory = (shop = (AbstractShopEntity)class_25862).createScreenHandlerFactory(false)) != null) {
                player.method_17355(screenHandlerFactory);
            }
            return class_1269.field_5812;
        }

        public abstract class_265 method_26201(class_1922 var1, class_2338 var2);

        public abstract class_265 method_26172(class_1922 var1, class_2338 var2, class_3726 var3);

        public abstract class_265 method_26220(class_1922 var1, class_2338 var2);

        public class_2680 method_26186(class_2470 rotation) {
            return (class_2680)this.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)this.method_11654((class_2769)FACING)));
        }

        public class_2680 method_26185(class_2415 mirror) {
            return this.method_26186(mirror.method_10345((class_2350)this.method_11654((class_2769)FACING)));
        }

        public void method_26182(class_1937 world, class_2338 pos, class_2680 state, boolean notify) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null && blockEntity instanceof AbstractShopEntity) {
                AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
                shopEntity.method_5431();
            }
            super.method_26182(world, pos, state, notify);
        }

        public final void method_26197(class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
            if (this.isStateReplacedValid(newState)) {
                return;
            }
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null && blockEntity instanceof AbstractShopEntity) {
                AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
                if (this.unbreakable()) {
                    world.method_8501(pos, (class_2680)this);
                    return;
                }
                shopEntity.itemScatter(world, pos);
                world.method_8455(pos, this.method_26204());
            }
            world.method_8544(pos);
        }

        protected abstract boolean isStateReplacedValid(class_2680 var1);

        public final boolean unbreakable() {
            return (Boolean)this.method_11654((class_2769)BREAKABLE) == false;
        }

        public final void makeBreakable(class_3218 world, class_2338 pos) {
            world.method_8501(pos, (class_2680)this.method_47968((class_2769)BREAKABLE, Boolean.valueOf(true)));
        }

        public final void makeUnbreakable(class_3218 world, class_2338 pos) {
            world.method_8501(pos, (class_2680)this.method_47968((class_2769)BREAKABLE, Boolean.valueOf(false)));
        }
    }
}

