/*
 * Decompiled with CFR 0.152.
 */
package artifacts.equipment.client;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.equipment.client.EquipmentRenderingHandler;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class EquipmentRenderingManager {
    private static final Set<EquipmentRenderingHandler> RENDERING_HANDLERS = new LinkedHashSet<EquipmentRenderingHandler>();

    public static void register(EquipmentRenderingHandler integration) {
        RENDERING_HANDLERS.add(integration);
    }

    public static void registerArtifactRenderer(class_1792 item, Supplier<ArtifactRenderer> rendererFactory) {
        for (EquipmentRenderingHandler handler : RENDERING_HANDLERS) {
            handler.registerArtifactRenderer(item, rendererFactory);
        }
    }

    @Nullable
    public static ArtifactRenderer getArtifactRenderer(class_1792 item) {
        for (EquipmentRenderingHandler handler : RENDERING_HANDLERS) {
            ArtifactRenderer renderer = handler.getArtifactRenderer(item);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    public static void renderArm(class_4587 matrixStack, class_4597 buffer, int light, class_742 player, class_1306 side) {
        for (EquipmentRenderingHandler handler : RENDERING_HANDLERS) {
            handler.renderArm(matrixStack, buffer, light, player, side);
        }
    }
}

