/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.retaliation;

import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.retaliation.RetaliationEffect;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_9139;

public class FireEffect
extends RetaliationEffect {
    public static final Codec<FireEffect> CODEC = RecordCodecBuilder.create(instance -> FireEffect.codecStart(instance).and((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(FireEffect::fireDuration)).and((App)ValueTypes.BOOLEAN.codec().optionalFieldOf("grant_fire_resistance", Value.of(true)).forGetter(FireEffect::grantsFireResistance)).apply((Applicative)instance, FireEffect::new));
    public static final class_9139<ByteBuf, FireEffect> STREAM_CODEC = class_9139.method_56905(ValueTypes.FRACTION.streamCodec(), RetaliationEffect::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationEffect::cooldown, ValueTypes.DURATION.streamCodec(), FireEffect::fireDuration, ValueTypes.BOOLEAN.streamCodec(), FireEffect::grantsFireResistance, FireEffect::new);
    private final Value<Integer> fireDuration;
    private final Value<Boolean> grantsFireResistance;

    public FireEffect(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> fireDuration, Value<Boolean> grantsFireResistance) {
        super("fire", strikeChance, cooldown);
        this.fireDuration = fireDuration;
        this.grantsFireResistance = grantsFireResistance;
    }

    public Value<Integer> fireDuration() {
        return this.fireDuration;
    }

    public Value<Boolean> grantsFireResistance() {
        return this.grantsFireResistance;
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.fireDuration().get() > 0;
    }

    @Override
    protected void applyEffect(class_1309 target, class_1309 attacker) {
        if (!attacker.method_5753() && attacker.method_6102() && (Integer)this.fireDuration().get() > 0) {
            if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
                target.method_6092(new class_1293(class_1294.field_5918, (Integer)this.fireDuration().get() * 20, 0, false, false, true));
            }
            attacker.method_5639((float)((Integer)this.fireDuration().get()).intValue());
        }
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        super.addToTooltip(writer);
        if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
            writer.add("fire.fire_resistance", new Object[0]);
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FireEffect)) {
            return false;
        }
        FireEffect that = (FireEffect)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.fireDuration.equals(that.fireDuration) && this.grantsFireResistance.equals(that.grantsFireResistance);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fireDuration.hashCode();
        result = 31 * result + this.grantsFireResistance.hashCode();
        return result;
    }
}

