/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.TickingAbility;
import artifacts.component.ability.TickingCompositeAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAttributes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AttributeModifiers(List<Entry> entries) implements TickingCompositeAbility<Entry>
{
    private static final Set<class_6880<class_1320>> POSITIVE_ATTRIBUTES_WITH_TOOLTIP;
    private static final Set<class_6880<class_1320>> NEGATIVE_ATTRIBUTES_WITH_TOOLTIP;
    public static final Codec<AttributeModifiers> CODEC;
    public static final class_9139<class_9129, AttributeModifiers> STREAM_CODEC;

    static {
        NEGATIVE_ATTRIBUTES_WITH_TOOLTIP = Set.of(class_5134.field_47760, class_5134.field_49077);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP = new HashSet<class_6880<class_1320>>();
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.addAll(ModAttributes.PLAYER_ATTRIBUTES);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.addAll(ModAttributes.GENERIC_ATTRIBUTES);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.add(ModAttributes.SWIM_SPEED);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.addAll(List.of(class_5134.field_23721, class_5134.field_23722, class_5134.field_23723, class_5134.field_49076, class_5134.field_23728, class_5134.field_23718, class_5134.field_23716, class_5134.field_49079, class_5134.field_51583));
        CODEC = CompositeAbility.codec(Entry.CODEC, AttributeModifiers::new, AttributeModifiers::entries);
        STREAM_CODEC = CompositeAbility.streamCodec(Entry.STREAM_CODEC, AttributeModifiers::new, AttributeModifiers::entries);
    }

    public record Entry(class_6880<class_1320> attribute, Value<Double> amount, class_1322.class_1323 operation, class_2960 id, boolean ignoreCooldown) implements TickingAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41190.method_40294().fieldOf("attribute").forGetter(Entry::attribute), (App)ValueTypes.ATTRIBUTE_MODIFIER_AMOUNT.codec().fieldOf("amount").forGetter(Entry::amount), (App)class_1322.class_1323.field_45742.fieldOf("operation").forGetter(Entry::operation), (App)class_2960.field_25139.fieldOf("id").forGetter(Entry::id), (App)Codec.BOOL.optionalFieldOf("ignore_cooldown", (Object)true).forGetter(Entry::ignoreCooldown)).apply((Applicative)instance, Entry::new));
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.method_56383((class_5321)class_7924.field_41251), Entry::attribute, ValueTypes.ATTRIBUTE_MODIFIER_AMOUNT.streamCodec(), Entry::amount, (class_9139)class_1322.class_1323.field_48326, Entry::operation, (class_9139)class_2960.field_48267, Entry::id, (class_9139)class_9135.field_48547, Entry::ignoreCooldown, Entry::new);

        public class_1322 createModifier() {
            return new class_1322(this.id(), ((Double)this.amount().get()).doubleValue(), this.operation());
        }

        private void onAttributeUpdated(class_1309 entity) {
            if (this.attribute() == class_5134.field_23716 && entity.method_6032() > entity.method_6063()) {
                entity.method_6033(entity.method_6063());
            }
        }

        @Override
        public void onUnequip(class_1309 entity) {
            class_1324 attributeInstance = entity.method_5996(this.attribute());
            if (attributeInstance != null && attributeInstance.method_6196(this.id())) {
                attributeInstance.method_6200(this.id());
                this.onAttributeUpdated(entity);
            }
        }

        @Override
        public void wornTick(class_1309 entity, boolean isOnCooldown, boolean isDisabled) {
            class_1324 attributeInstance = entity.method_5996(this.attribute());
            if (attributeInstance == null) {
                return;
            }
            class_1322 existingModifier = attributeInstance.method_6199(this.id());
            if (!this.ignoreCooldown() && isOnCooldown) {
                if (!isDisabled && this.isNonCosmetic()) {
                    this.onUnequip(entity);
                }
            } else if (!(isDisabled || existingModifier != null && class_3532.method_20390((double)((Double)this.amount().get()), (double)existingModifier.comp_2449()))) {
                attributeInstance.method_6200(this.id());
                attributeInstance.method_26837(this.createModifier());
                this.onAttributeUpdated(entity);
            }
        }

        @Override
        public boolean isNonCosmetic() {
            return !class_3532.method_20390((double)((Double)this.amount().get()), (double)0.0);
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            String attributeName = ((class_5321)this.attribute().method_40230().orElseThrow()).method_29177().method_12832();
            if (attributeName.equals("swim_speed")) {
                attributeName = "generic.swim_speed";
            }
            if ((Double)this.amount().get() > 0.0) {
                for (class_6880<class_1320> attribute : POSITIVE_ATTRIBUTES_WITH_TOOLTIP) {
                    if (!attribute.method_40227() || attribute.comp_349() != this.attribute().comp_349()) continue;
                    writer.add(attributeName, new Object[0]);
                }
            } else {
                for (class_6880<class_1320> attribute : NEGATIVE_ATTRIBUTES_WITH_TOOLTIP) {
                    if (!attribute.method_40227() || attribute.comp_349() != this.attribute().comp_349()) continue;
                    writer.add(attributeName, new Object[0]);
                }
            }
        }
    }
}

