/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DataView;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_4844;

public class DataTypeUtils {
    @Nullable
    public static UUID readUuidFromLongs(DataView tag) {
        return DataTypeUtils.readUuidFromLongs(tag, "UUIDM", "UUIDL");
    }

    @Nullable
    public static UUID readUuidFromLongs(DataView tag, String keyM, String keyL) {
        if (tag.contains(keyM, 4) && tag.contains(keyL, 4)) {
            return new UUID(tag.getLong(keyM), tag.getLong(keyL));
        }
        return null;
    }

    public static void writeUuidToLongs(CompoundData tag, UUID uuid) {
        DataTypeUtils.writeUuidToLongs(tag, uuid, "UUIDM", "UUIDL");
    }

    public static void writeUuidToLongs(CompoundData tag, UUID uuid, String keyM, String keyL) {
        tag.putLong(keyM, uuid.getMostSignificantBits());
        tag.putLong(keyL, uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull CompoundData data) {
        return DataTypeUtils.getUUIDCodec(data, "UUID");
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull CompoundData data, String key) {
        if (data.contains(key, 11)) {
            return data.getCodec(key, class_4844.field_25122).orElse(null);
        }
        return null;
    }

    public static CompoundData putUUIDCodec(@Nonnull CompoundData dataIn, @Nonnull UUID uuid, String key) {
        return dataIn.putCodec(key, class_4844.field_25122, uuid);
    }

    public static CompoundData getOrCreateCompound(CompoundData tagIn, String tagName) {
        CompoundData tag;
        if (tagIn.contains(tagName, 10)) {
            tag = tagIn.getCompound(tagName);
        } else {
            tag = new CompoundData();
            tagIn.put(tagName, tag);
        }
        return tag;
    }

    public static <T> ListData asListTag(Collection<T> values, Function<T, BaseData> tagFactory) {
        ListData list = null;
        for (T val : values) {
            BaseData entry = tagFactory.apply(val);
            if (list == null) {
                list = new ListData();
            }
            list.add(entry);
        }
        return list;
    }

    @Nonnull
    public static CompoundData createBlockPos(@Nonnull class_2338 pos) {
        return DataTypeUtils.writeBlockPos(pos, new CompoundData());
    }

    @Nonnull
    public static CompoundData createBlockPosTag(@Nonnull class_2382 pos) {
        return DataTypeUtils.putVec3i(new CompoundData(), pos);
    }

    public static CompoundData createVec3iTag(class_2382 pos) {
        return DataTypeUtils.putVec3i(new CompoundData(), pos);
    }

    @Nonnull
    public static CompoundData createVec3iToArrayTag(@Nonnull class_2382 pos, String tagName) {
        return DataTypeUtils.writeVec3iToArrayTag(new CompoundData(), tagName, pos);
    }

    @Nonnull
    public static CompoundData createEntityPosition(@Nonnull class_243 pos) {
        return DataTypeUtils.createEntityPositionToTag(pos);
    }

    @Nonnull
    public static CompoundData createEntityPositionToTag(@Nonnull class_243 pos) {
        return DataTypeUtils.writeVec3dToListTag(new CompoundData(), "Pos", pos);
    }

    public static CompoundData putVec3i(CompoundData tag, class_2382 pos) {
        tag.putInt("x", pos.method_10263());
        tag.putInt("y", pos.method_10264());
        tag.putInt("z", pos.method_10260());
        return tag;
    }

    @Nonnull
    public static CompoundData putVec3iCodec(@Nonnull CompoundData tag, @Nonnull class_2382 pos, String key) {
        tag.putCodec(key, class_2382.field_25123, pos);
        return tag;
    }

    @Nonnull
    public static CompoundData putVec3dCodec(@Nonnull CompoundData tag, @Nonnull class_243 pos, String key) {
        tag.putCodec(key, class_243.field_38277, pos);
        return tag;
    }

    @Nonnull
    public static CompoundData putPosCodec(@Nonnull CompoundData tag, @Nonnull class_2338 pos, String key) {
        tag.putCodec(key, class_2338.field_25064, pos);
        return tag;
    }

    public static class_2382 getVec3iCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, class_2382.field_25123).orElse(class_2382.field_11176);
    }

    public static class_243 getVec3dCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, class_243.field_38277).orElse(class_243.field_1353);
    }

    public static class_2338 getPosCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, class_2338.field_25064).orElse(class_2338.field_10980);
    }

    @Nonnull
    public static CompoundData writeBlockPosToTag(@Nonnull class_2338 pos, @Nonnull CompoundData tag) {
        return DataTypeUtils.writeBlockPos(pos, tag);
    }

    @Nonnull
    public static CompoundData writeBlockPos(@Nonnull class_2338 pos, @Nonnull CompoundData tag) {
        tag.putInt("x", pos.method_10263());
        tag.putInt("y", pos.method_10264());
        tag.putInt("z", pos.method_10260());
        return tag;
    }

    public static CompoundData writeVec3iToListTag(CompoundData tag, String tagName, class_2382 vec) {
        ListData list = new ListData();
        list.add(new IntData(vec.method_10263()));
        list.add(new IntData(vec.method_10264()));
        list.add(new IntData(vec.method_10260()));
        tag.put(tagName, list);
        return tag;
    }

    public static CompoundData writeVec3iToArrayTag(CompoundData tag, String tagName, class_2382 vec) {
        int[] arr = new int[]{vec.method_10263(), vec.method_10264(), vec.method_10260()};
        tag.putIntArray(tagName, arr);
        return tag;
    }

    public static class_2382 readVec3iOrDefault(DataView tag, String vecTagName, class_2382 defaultValue) {
        if (!tag.contains(vecTagName, 10)) {
            return defaultValue;
        }
        CompoundData vecTag = tag.getCompound(vecTagName);
        if (vecTag.contains("x", 3) && vecTag.contains("y", 3) && vecTag.contains("z", 3)) {
            return new class_2382(vecTag.getInt("x"), vecTag.getInt("y"), vecTag.getInt("z"));
        }
        return defaultValue;
    }

    @Nullable
    public static class_2338 readBlockPos(DataView tag) {
        if (tag.contains("x", 3) && tag.contains("y", 3) && tag.contains("z", 3)) {
            return new class_2338(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromListTag(DataView tag, String tagName) {
        ListData list;
        if (tag.containsList(tagName, 3) && (list = tag.getList(tagName)).size() == 3) {
            return new class_2338(list.getIntAt(0), list.getIntAt(1), list.getIntAt(2));
        }
        return null;
    }

    public static class_2338 readBlockPosFromListTagOrDefault(DataView tag, String tagName, class_2338 defaultValue) {
        class_2338 pos = DataTypeUtils.readBlockPosFromListTag(tag, tagName);
        return pos != null ? pos : defaultValue;
    }

    @Nullable
    public static class_2338 readBlockPosFromArrayTag(DataView tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName, 11) && (pos = tag.getIntArray(tagName)).length == 3) {
            return new class_2338(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3iFromIntArray(@Nonnull DataView nbt, String key) {
        return DataTypeUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static class_2382 readVec3iFromIntArrayTag(@Nonnull DataView tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName, 11) && (pos = tag.getIntArray(tagName)).length == 3) {
            return new class_2382(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public static class_2338 readBlockPosFromArrayTagOrDefault(DataView tag, String tagName, class_2338 defaultValue) {
        class_2338 pos = DataTypeUtils.readBlockPosFromArrayTag(tag, tagName);
        return pos != null ? pos : defaultValue;
    }

    public static CompoundData removeBlockPosFromTag(CompoundData tag) {
        tag.remove("x");
        tag.remove("y");
        tag.remove("z");
        return tag;
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, class_243 pos) {
        return DataTypeUtils.writeVec3dToListTag(tag, "Pos", pos);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, String tagName, class_243 pos) {
        return DataTypeUtils.writeVec3dToListTag(tag, tagName, pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, double x, double y, double z) {
        return DataTypeUtils.writeVec3dToListTag(tag, "Pos", x, y, z);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, String tagName, double x, double y, double z) {
        ListData list = new ListData();
        list.add(new DoubleData(x));
        list.add(new DoubleData(y));
        list.add(new DoubleData(z));
        tag.put(tagName, list);
        return tag;
    }

    @Nullable
    public static class_243 readVec3d(DataView data) {
        if (data.contains("dx", 6) && data.contains("dy", 6) && data.contains("dz", 6)) {
            return new class_243(data.getDouble("dx"), data.getDouble("dy"), data.getDouble("dz"));
        }
        return null;
    }

    @Nullable
    public static class_243 readVec3dFromListTag(DataView data) {
        return DataTypeUtils.readVec3dFromListTag(data, "Pos");
    }

    @Nullable
    public static class_243 readVec3dFromListTag(DataView data, String tagName) {
        ListData list;
        if (data.containsList(tagName, 6) && (list = data.getList(tagName)).size() == 3) {
            return new class_243(list.getDoubleAt(0), list.getDoubleAt(1), list.getDoubleAt(2));
        }
        return null;
    }

    @Nullable
    public static class_2338 readAttachedPosFromTag(@Nonnull DataView tag) {
        return DataTypeUtils.readPrefixedPosFromTag(tag, "Tile");
    }

    @Nonnull
    public static CompoundData writeAttachedPosToTag(@Nonnull class_2338 pos, @Nonnull CompoundData tag) {
        return DataTypeUtils.writePrefixedPosToTag(pos, tag, "Tile");
    }

    @Nullable
    public static class_2338 readPrefixedPosFromTag(@Nonnull DataView tag, String pre) {
        if (tag.contains(pre + "X", 3) && tag.contains(pre + "Y", 3) && tag.contains(pre + "Z", 3)) {
            return new class_2338(tag.getInt(pre + "X"), tag.getInt(pre + "Y"), tag.getInt(pre + "Z"));
        }
        return null;
    }

    @Nonnull
    public static CompoundData writePrefixedPosToTag(@Nonnull class_2338 pos, @Nonnull CompoundData tag, String pre) {
        tag.putInt(pre + "X", pos.method_10263());
        tag.putInt(pre + "Y", pos.method_10264());
        tag.putInt(pre + "Z", pos.method_10260());
        return tag;
    }

    public static class_2350 readDirectionFromTag(@Nonnull CompoundData tag, String key) {
        if (tag.contains(key, 3)) {
            return class_2350.method_10143((int)tag.getInt(key));
        }
        if (tag.contains(key, 8)) {
            return tag.getCodec(key, class_2350.field_29502).orElse(class_2350.field_11035);
        }
        return class_2350.field_11035;
    }

    public static CompoundData writeDirectionToTagAsInt(@Nonnull CompoundData tagIn, String key, class_2350 direction) {
        return tagIn.putInt(key, direction.method_10146());
    }

    public static CompoundData writeDirectionToTagAsString(@Nonnull CompoundData tagIn, String key, class_2350 direction) {
        return tagIn.putCodec(key, class_2350.field_29502, direction);
    }

    public static <T> Optional<T> readFlatMap(@Nonnull CompoundData data, MapCodec<T> mapCodec) {
        class_2509 ops = class_2509.field_11560;
        class_2487 nbt = DataConverterNbt.toVanillaCompound(data);
        DataResult dataResult = ops.getMap((Object)nbt).flatMap(arg_0 -> DataTypeUtils.lambda$readFlatMap$0(mapCodec, (DynamicOps)ops, arg_0));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            case 0 -> {
                DataResult.Success result = (DataResult.Success)dataResult2;
                yield Optional.of(result.value());
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                yield error.partialValue();
            }
            default -> Optional.empty();
        };
    }

    public static <T> CompoundData writeFlatMap(MapCodec<T> mapCodec, T value) {
        class_2509 ops = class_2509.field_11560;
        class_2487 nbt = new class_2487();
        DataResult dataResult = mapCodec.encoder().encodeStart((DynamicOps)ops, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success result = (DataResult.Success)dataResult2;
                nbt.method_10543((class_2487)result.value());
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                error.partialValue().ifPresent(partial -> nbt.method_10543((class_2487)partial));
            }
        }
        return DataConverterNbt.fromVanillaCompound(nbt);
    }

    private static /* synthetic */ DataResult lambda$readFlatMap$0(MapCodec mapCodec, DynamicOps ops, MapLike map) {
        return mapCodec.decode(ops, map);
    }
}

