/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.DataOps;
import fi.dy.masa.malilib.util.data.tag.util.DataTypeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1440;
import net.minecraft.class_1453;
import net.minecraft.class_1463;
import net.minecraft.class_1474;
import net.minecraft.class_1501;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1702;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3850;
import net.minecraft.class_4019;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5135;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5762;
import net.minecraft.class_6880;
import net.minecraft.class_7106;
import net.minecraft.class_7225;
import net.minecraft.class_7375;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9346;
import net.minecraft.class_9347;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DataEntityUtils {
    @Nullable
    public static class_1299<?> getEntityType(@Nonnull CompoundData data) {
        if (data.contains("id", 8)) {
            return (class_1299)class_7923.field_41177.method_10223(class_2960.method_12829((String)data.getString("id")));
        }
        return null;
    }

    public CompoundData setEntityType(class_1299<?> type, @Nullable CompoundData dataIn) {
        CompoundData data = new CompoundData();
        class_2960 id = class_1299.method_5890(type);
        if (id != null) {
            if (dataIn != null) {
                dataIn.putString("id", id.toString());
                return dataIn;
            }
            data.putString("id", id.toString());
        }
        return data;
    }

    public static class_6880.class_6883<class_1299<?>> getEntityTypeEntry(class_2960 id, @Nonnull class_5455 registry) {
        try {
            return (class_6880.class_6883)registry.method_30530(class_7923.field_41177.method_30517()).method_55841(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static class_5131 getAttributes(@Nonnull CompoundData data) {
        class_1299<?> type = DataEntityUtils.getEntityType(data);
        if (type != null && data.contains("attributes", 9)) {
            class_5131 container = new class_5131(class_5135.method_26873(type));
            container.method_26850(DataConverterNbt.toVanillaList(data.getList("attributes")));
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValue(@Nonnull CompoundData data, class_6880<class_1320> attribute) {
        class_5131 attributes = DataEntityUtils.getAttributes(data);
        if (attributes != null) {
            return attributes.method_26856(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValue(@Nonnull CompoundData data, class_6880<class_1320> attribute) {
        class_5131 attributes = DataEntityUtils.getAttributes(data);
        if (attributes != null) {
            return attributes.method_26852(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealth(@Nonnull CompoundData data) {
        double maxHealth;
        double health = 0.0;
        if (data.contains("Health", 5)) {
            health = data.getFloat("Health");
        }
        if ((maxHealth = DataEntityUtils.getAttributeValue(data, (class_6880<class_1320>)class_5134.field_23716)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrength(@Nonnull CompoundData data) {
        class_5131 container = DataEntityUtils.getAttributes(data);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.method_26852(class_5134.field_23719);
            jumpStrength = container.method_26852(class_5134.field_23728);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static UUID getUUIDFromNbt(@Nonnull CompoundData data) {
        class_2487 nbt = DataConverterNbt.toVanillaCompound(data);
        if (nbt.method_25928("UUID")) {
            return nbt.method_25926("UUID");
        }
        return null;
    }

    @Nullable
    public static class_2561 getCustomName(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("CustomName", 8)) {
            String string = data.getString("CustomName");
            try {
                return class_2561.class_2562.method_10877((String)string, (class_7225.class_7874)registry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CompoundData setCustomNameToDataTag(@Nonnull class_2561 name, @Nonnull class_5455 registry, @Nullable CompoundData dataIn, String key) {
        CompoundData data = dataIn != null ? dataIn.copy() : new CompoundData();
        try {
            if (dataIn != null) {
                dataIn.putString("CustomName", class_2561.class_2562.method_10867((class_2561)name, (class_7225.class_7874)registry));
                return dataIn;
            }
            data.putString("CustomName", class_2561.class_2562.method_10867((class_2561)name, (class_7225.class_7874)registry));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static Map<class_6880<class_1291>, class_1293> getActiveStatusEffects(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        HashMap statusEffects = Maps.newHashMap();
        if (data.contains("active_effects", 9)) {
            ListData list = data.getList("active_effects");
            for (int i = 0; i < list.size(); ++i) {
                class_1293 instance = class_1293.method_5583((class_2487)DataConverterNbt.toVanillaCompound(list.getCompoundAt(i)));
                if (instance == null) continue;
                statusEffects.put(instance.method_5579(), instance);
            }
        }
        return statusEffects;
    }

    public static class_2371<class_1799> getHandItemsFromNbt(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        if (data.contains("HandItems", 9)) {
            ListData nbtList = data.getList("HandItems");
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)class_1799.method_57359((class_7225.class_7874)registry, (class_2487)DataConverterNbt.toVanillaCompound(nbtList.getCompoundAt(i))));
            }
        }
        return list;
    }

    public static class_2371<class_1799> getArmorItemsFromNbt(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_2371 list = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        if (data.contains("ArmorItems", 9)) {
            ListData nbtList = data.getList("ArmorItems");
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)class_1799.method_57359((class_7225.class_7874)registry, (class_2487)DataConverterNbt.toVanillaCompound(nbtList.getCompoundAt(i))));
            }
        }
        return list;
    }

    public static class_1799 getBodyArmorFromNbt(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("body_armor_item", 10)) {
            return class_1799.method_57359((class_7225.class_7874)registry, (class_2487)DataConverterNbt.toVanillaCompound(data.getCompound("body_armor_item")));
        }
        return class_1799.field_8037;
    }

    public static Pair<UUID, class_1799> getOwnerAndSaddle(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        UUID owner = class_156.field_25140;
        class_1799 saddle = class_1799.field_8037;
        class_2487 nbt = DataConverterNbt.toVanillaCompound(data);
        if (nbt.method_25928("Owner")) {
            owner = nbt.method_25926("Owner");
        }
        if (data.contains("SaddleItem", 10)) {
            saddle = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("SaddleItem"));
        }
        return Pair.of((Object)owner, (Object)saddle);
    }

    public static Pair<Integer, Integer> getAge(@Nonnull CompoundData data) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (data.contains("Age", 3)) {
            breedingAge = data.getInt("Age");
        }
        if (data.contains("ForcedAge", 3)) {
            forcedAge = data.getInt("ForcedAge");
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static class_1916 getTradeOffers(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("Offers", 9)) {
            return data.getCodec("Offers", class_1916.field_48850, (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_3850 getVillagerData(@Nonnull CompoundData data) {
        if (data.contains("VillagerData", 10)) {
            return data.getCodec("VillagerData", class_3850.field_24669).orElse(null);
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimer(@Nonnull CompoundData data) {
        int timer = -1;
        UUID player = class_156.field_25140;
        if (data.contains("ConversionTime", 3)) {
            timer = data.getInt("ConversionTime");
        }
        if (data.contains("ConversionPlayer", 11)) {
            player = DataTypeUtils.getUUIDCodec(data, "ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimer(@Nonnull CompoundData data) {
        int drowning = -1;
        int inWater = -1;
        if (data.contains("DrownedConversionTime", 3)) {
            drowning = data.getInt("DrownedConversionTime");
        }
        if (data.contains("InWaterTime", 3)) {
            inWater = data.getInt("InWaterTime");
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTime(@Nonnull CompoundData data) {
        if (data.contains("StrayConversionTime", 3)) {
            return data.getInt("StrayConversionTime");
        }
        return -1;
    }

    @Nullable
    public static EntityUtils.FakeLeashData getLeashData(@Nonnull CompoundData data) {
        Either either;
        EntityUtils.FakeLeashData leashData = null;
        if (data.contains("leash", 10)) {
            leashData = new EntityUtils.FakeLeashData(-1, null, (Either<UUID, class_2338>)Either.left((Object)DataConverterNbt.toVanillaCompound(data.getCompound("leash")).method_25926("UUID")));
        } else if (data.contains("leash", 11) && (either = (Either)class_2512.method_10691((class_2487)DataConverterNbt.toVanillaCompound(data), (String)"leash").map(Either::right).orElse(null)) != null) {
            return new EntityUtils.FakeLeashData(-1, null, (Either<UUID, class_2338>)either);
        }
        return leashData;
    }

    public static Pair<class_1440.class_1443, class_1440.class_1443> getPandaGenes(@Nonnull CompoundData data) {
        class_1440.class_1443 mainGene = null;
        class_1440.class_1443 hiddenGene = null;
        if (data.contains("MainGene", 8)) {
            mainGene = data.getCodec("MainGene", class_1440.class_1443.field_41673).orElse(class_1440.class_1443.field_6788);
        }
        if (data.contains("HiddenGene", 8)) {
            hiddenGene = data.getCodec("HiddenGene", class_1440.class_1443.field_41673).orElse(class_1440.class_1443.field_6788);
        }
        return Pair.of((Object)mainGene, hiddenGene);
    }

    public static Pair<class_2350, class_2350> getItemFrameDirections(@Nonnull CompoundData data) {
        class_2350 facing = DataTypeUtils.readDirectionFromTag(data, "Facing");
        class_2350 rotation = null;
        if (data.contains("ItemRotation", 1)) {
            rotation = class_2350.method_10143((int)data.getByte("ItemRotation"));
        }
        return Pair.of((Object)facing, rotation);
    }

    public static Pair<class_2350, class_1535> getPaintingData(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_2350 facing = DataTypeUtils.readDirectionFromTag(data, "facing");
        class_6880 variant = null;
        if (data.contains("variant", 10)) {
            variant = class_1534.field_49239.parse((DynamicOps)registry.method_57093((DynamicOps)DataOps.INSTANCE), (Object)data).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (class_1535)variant.comp_349() : null);
    }

    @Nullable
    public static class_5762.class_5767 getAxolotlVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return class_5762.class_5767.method_47928((int)data.getInt("Variant"));
        }
        return null;
    }

    public static Pair<class_5321<class_7375>, class_1767> getCatVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_5321 variantKey = null;
        class_1767 collar = null;
        if (data.contains("variant", 8) && (variantKey = class_5321.method_29179((class_5321)class_7924.field_41259, (class_2960)class_2960.method_12829((String)data.getString("variant")))) == null) {
            variantKey = class_7375.field_38719;
        }
        if (data.contains("CollarColor", 99)) {
            collar = class_1767.method_7791((int)data.getInt("CollarColor"));
        }
        return Pair.of((Object)variantKey, collar);
    }

    @Nullable
    public static class_5321<class_7106> getFrogVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("variant", 8)) {
            class_5321 variantKey = class_5321.method_29179((class_5321)class_7924.field_41272, (class_2960)class_2960.method_12829((String)data.getString("variant")));
            if (variantKey == null) {
                variantKey = class_7106.field_37462;
            }
            return variantKey;
        }
        return null;
    }

    public static Pair<class_5149, class_5148> getHorseVariant(@Nonnull CompoundData data) {
        class_5149 color = null;
        class_5148 marking = null;
        if (data.contains("Variant", 3)) {
            int variant = data.getInt("Variant");
            color = class_5149.method_27083((int)(variant & 0xFF));
            marking = class_5148.method_27080((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static class_1453.class_7989 getParrotVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return class_1453.class_7989.method_47850((int)data.getInt("Variant"));
        }
        return null;
    }

    @Nullable
    public static class_1474.class_1475 getFishVariantFromNbt(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return class_1474.class_1475.method_47868((int)(data.getInt("Variant") & 0xFFFF));
        }
        if (data.contains("BucketVariantTag", 3)) {
            return class_1474.class_1475.method_47868((int)(data.getInt("BucketVariantTag") & 0xFFFF));
        }
        return null;
    }

    public static Pair<class_5321<class_9346>, class_1767> getWolfVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_5321 variantKey = null;
        class_1767 collar = null;
        if (data.contains("variant", 8)) {
            variantKey = class_5321.method_29179((class_5321)class_7924.field_49772, (class_2960)class_2960.method_12829((String)data.getString("variant")));
        }
        if (data.contains("CollarColor", 99)) {
            collar = class_1767.method_7791((int)data.getInt("CollarColor"));
        }
        if (variantKey == null) {
            variantKey = class_9347.field_51588;
        }
        if (collar == null) {
            collar = class_1767.field_7964;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    @Nullable
    public static class_1767 getSheepColor(@Nonnull CompoundData data) {
        if (data.contains("Color", 1)) {
            return class_1767.method_7791((int)data.getByte("Color"));
        }
        return null;
    }

    @Nullable
    public static class_1463.class_7990 getRabbitType(@Nonnull CompoundData data) {
        if (data.contains("RabbitType", 3)) {
            return class_1463.class_7990.method_47857((int)data.getInt("RabbitType"));
        }
        return null;
    }

    public static Pair<class_1501.class_7993, Integer> getLlamaType(@Nonnull CompoundData data) {
        class_1501.class_7993 variant = null;
        int strength = -1;
        if (data.contains("Variant", 3)) {
            variant = class_1501.class_7993.method_47876((int)data.getInt("Variant"));
        }
        if (data.contains("Strength", 3)) {
            strength = data.getInt("Strength");
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    @Nullable
    public static class_4019.class_4039 getFoxVariant(@Nonnull CompoundData data) {
        if (data.contains("Type", 8)) {
            return class_4019.class_4039.method_18314((String)data.getString("Type"));
        }
        return null;
    }

    public static Triple<class_2338, Integer, Boolean> getDolphinDataFromNbt(@Nonnull CompoundData data) {
        class_2338 treasure = class_2338.field_10980;
        int moist = -1;
        boolean hasFish = false;
        if (data.contains("TreasurePosX", 3) && data.contains("TreasurePosY", 3) && data.contains("TreasurePosZ", 3)) {
            treasure = new class_2338(data.getInt("TreasurePosX"), data.getInt("TreasurePosY"), data.getInt("TreasurePosZ"));
        }
        if (data.contains("Moistness", 3)) {
            moist = data.getInt("Moistness");
        }
        if (data.contains("GotFish", 1)) {
            hasFish = data.getBoolean("GotFish");
        }
        return Triple.of((Object)treasure, (Object)moist, (Object)hasFish);
    }

    public static Triple<Integer, Integer, Float> getPlayerExp(@Nonnull CompoundData data) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (data.contains("XpLevel", 3)) {
            level = data.getInt("XpLevel");
        }
        if (data.contains("XpTotal", 3)) {
            total = data.getInt("XpTotal");
        }
        if (data.contains("XpP", 5)) {
            progress = data.getFloat("XpP");
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static class_1702 getPlayerHunger(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_1702 hunger = null;
        if (data.containsLenient("foodLevel")) {
            hunger = new class_1702();
            hunger.method_7584(DataConverterNbt.toVanillaCompound(data));
        }
        return hunger;
    }
}

