/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class GuiUtils {
    public static int getScaledWindowWidth() {
        return class_310.method_1551().method_22683().method_4486();
    }

    public static int getScaledWindowHeight() {
        return class_310.method_1551().method_22683().method_4502();
    }

    public static int getDisplayWidth() {
        return class_310.method_1551().method_22683().method_4480();
    }

    public static int getDisplayHeight() {
        return class_310.method_1551().method_22683().method_4507();
    }

    @Nullable
    public static class_437 getCurrentScreen() {
        return class_310.method_1551().field_1755;
    }

    public static int getCurrentScreenHeight() {
        if (GuiUtils.getCurrentScreen() != null) {
            return GuiUtils.getCurrentScreen().field_22790;
        }
        return GuiUtils.getScaledWindowHeight();
    }

    public static int getCurrentScreenWidth() {
        if (GuiUtils.getCurrentScreen() != null) {
            return GuiUtils.getCurrentScreen().field_22789;
        }
        return GuiUtils.getScaledWindowWidth();
    }

    public static void createBlockPosInputsVertical(int x, int y, int textFieldWidth, class_2338 pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        GuiUtils.createBlockPosInput(x, y, textFieldWidth, PositionUtils.CoordinateType.X, pos, modifier, addButton, gui);
        GuiUtils.createBlockPosInput(x, y + 17, textFieldWidth, PositionUtils.CoordinateType.Y, pos, modifier, addButton, gui);
        GuiUtils.createBlockPosInput(x, y + 34, textFieldWidth, PositionUtils.CoordinateType.Z, pos, modifier, addButton, gui);
    }

    public static void createVec3dInputsVertical(int x, int y, int textFieldWidth, class_243 pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        GuiUtils.createVec3dInput(x, y, textFieldWidth, PositionUtils.CoordinateType.X, pos, modifier, addButton, gui);
        GuiUtils.createVec3dInput(x, y + 17, textFieldWidth, PositionUtils.CoordinateType.Y, pos, modifier, addButton, gui);
        GuiUtils.createVec3dInput(x, y + 34, textFieldWidth, PositionUtils.CoordinateType.Z, pos, modifier, addButton, gui);
    }

    public static void createBlockPosInput(int x, int y, int textFieldWidth, PositionUtils.CoordinateType type, class_2338 pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        x = GuiUtils.addLabel(x, y, type, gui);
        GuiTextFieldInteger textField = new GuiTextFieldInteger(x, y + 1, textFieldWidth, 14, class_310.method_1551().field_1772);
        textField.method_1852(GuiUtils.getCoordinateValueString(type, pos));
        GuiUtils.addTextFieldAndButton(x + textFieldWidth + 4, y, type, modifier, textField, addButton, gui);
    }

    public static void createVec3dInput(int x, int y, int textFieldWidth, PositionUtils.CoordinateType type, class_243 pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        x = GuiUtils.addLabel(x, y, type, gui);
        GuiTextFieldDouble textField = new GuiTextFieldDouble(x, y + 1, textFieldWidth, 14, class_310.method_1551().field_1772);
        textField.method_1852(GuiUtils.getCoordinateValueString(type, pos));
        GuiUtils.addTextFieldAndButton(x + textFieldWidth + 4, y, type, modifier, textField, addButton, gui);
    }

    protected static void addTextFieldAndButton(int x, int y, PositionUtils.CoordinateType type, ICoordinateValueModifier modifier, GuiTextFieldGeneric textField, boolean addButton, GuiBase gui) {
        gui.addTextField(textField, new TextFieldListenerCoordinateInput(type, modifier));
        if (addButton) {
            String hover = StringUtils.translate("malilib.gui.button.hover.plus_minus_tip", new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x, y, MaLiLibIcons.BTN_PLUSMINUS_16, hover);
            gui.addButton(button, new ButtonListenerCoordinateInput(type, modifier));
        }
    }

    public static String getCoordinateValueString(PositionUtils.CoordinateType type, class_2338 pos) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PositionUtils.CoordinateType.X -> String.valueOf(pos.method_10263());
            case PositionUtils.CoordinateType.Y -> String.valueOf(pos.method_10264());
            case PositionUtils.CoordinateType.Z -> String.valueOf(pos.method_10260());
        };
    }

    public static String getCoordinateValueString(PositionUtils.CoordinateType type, class_243 pos) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PositionUtils.CoordinateType.X -> String.format("%.2f", pos.field_1352);
            case PositionUtils.CoordinateType.Y -> String.format("%.2f", pos.field_1351);
            case PositionUtils.CoordinateType.Z -> String.format("%.2f", pos.field_1350);
        };
    }

    protected static int addLabel(int x, int y, PositionUtils.CoordinateType type, GuiBase gui) {
        String label = type.name() + ":";
        int labelWidth = 0;
        for (PositionUtils.CoordinateType t : PositionUtils.CoordinateType.values()) {
            labelWidth = Math.max(labelWidth, StringUtils.getStringWidth(t.name() + ":") + 4);
        }
        gui.addLabel(x, y, labelWidth, 20, -1, label);
        return x += labelWidth;
    }

    public static class TextFieldListenerCoordinateInput
    implements ITextFieldListener<GuiTextFieldGeneric> {
        protected final ICoordinateValueModifier modifier;
        protected final PositionUtils.CoordinateType type;

        public TextFieldListenerCoordinateInput(PositionUtils.CoordinateType type, ICoordinateValueModifier modifier) {
            this.modifier = modifier;
            this.type = type;
        }

        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.modifier.setValueFromString(this.type, textField.method_1882());
            return false;
        }
    }

    public static class ButtonListenerCoordinateInput
    implements IButtonActionListener {
        protected final ICoordinateValueModifier modifier;
        protected final PositionUtils.CoordinateType type;

        public ButtonListenerCoordinateInput(PositionUtils.CoordinateType type, ICoordinateValueModifier modifier) {
            this.modifier = modifier;
            this.type = type;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= 8;
            }
            if (GuiBase.isAltDown()) {
                amount *= 4;
            }
            this.modifier.modifyValue(this.type, amount);
        }

        public static enum Type {
            NUDGE_COORD_X,
            NUDGE_COORD_Y,
            NUDGE_COORD_Z;

        }
    }
}

