/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IConfirmationListener;
import fi.dy.masa.malilib.util.InfoUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;

public record FileDeleter(Path file, @Nullable IDirectoryNavigator navigator, boolean feedback) implements IConfirmationListener
{
    @Override
    public boolean onActionConfirmed() {
        if (this.file() == null) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.invalid_file_or_directory", new Object[0]);
            MaLiLib.debugLog("FileDeleter: Failed to delete file; File is invalid/empty.", new Object[0]);
            return false;
        }
        if (!Files.exists(this.file(), new LinkOption[0])) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_does_not_exist", this.file().toAbsolutePath());
            MaLiLib.debugLog("FileDeleter: Failed to delete file '{}'; File does not exist", this.file().toAbsolutePath());
            return false;
        }
        if (this.navigator() != null && this.navigator().getCurrentDirectory().equals(this.file)) {
            this.navigator().switchToParentDirectory();
        }
        try {
            Files.deleteIfExists(this.file);
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_delete_file", this.file().toAbsolutePath());
            MaLiLib.debugLog("FileDeleter: Failed to delete file '{}'; {}", this.file().toAbsolutePath(), err.getLocalizedMessage());
            return false;
        }
        if (this.feedback()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.file_or_directory_deleted", this.file().getFileName());
        }
        MaLiLib.debugLog("FileDeleter: File '{}' deleted", this.file().toAbsolutePath());
        return true;
    }

    @Override
    public boolean onActionCancelled() {
        return false;
    }
}

