/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.InfoUtils;
import java.io.File;
import javax.annotation.Nullable;

public record DirectoryCreator(File dir, @Nullable IDirectoryNavigator navigator) implements IStringConsumerFeedback
{
    @Override
    public boolean setString(String string) {
        if (string.isEmpty()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_create_directory", string);
            MaLiLib.LOGGER.warn("DirectoryCreator: Failed to create directory; Directory is invalid/empty.");
            return false;
        }
        File newDir = new File(this.dir, string);
        if (newDir.exists()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_already_exists", newDir.getAbsolutePath());
            MaLiLib.LOGGER.warn("DirectoryCreator: Failed to create directory '{}'; Destination already exists.", (Object)this.dir().getAbsolutePath());
            return false;
        }
        try {
            if (!newDir.mkdirs()) {
                InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.failed_to_create_directory", newDir.getAbsolutePath());
                MaLiLib.LOGGER.error("DirectoryCreator: Error creating directory '{}'", (Object)this.dir().getAbsolutePath());
                return false;
            }
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_create_directory", newDir.getAbsolutePath());
            MaLiLib.LOGGER.error("DirectoryCreator: Exception creating directory '{}'; {}", (Object)this.dir().getAbsolutePath(), (Object)err.getLocalizedMessage());
        }
        if (this.navigator != null) {
            this.navigator.switchToDirectory(newDir);
        }
        InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.directory_created", string);
        MaLiLib.debugLog("DirectoryCreator: Created directory '{}'", newDir.getAbsolutePath());
        return true;
    }
}

