/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.TestUtils;
import fi.dy.masa.malilib.util.Color4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@ApiStatus.Experimental
public class TestWalls
implements AutoCloseable {
    public static final TestWalls INSTANCE = new TestWalls();
    protected final class_289 TESSELLATOR_1 = new class_289(0x200000);
    protected final class_289 TESSELLATOR_2 = new class_289(0x200000);
    protected class_287 BUFFER_1;
    protected class_287 BUFFER_2;
    protected class_291 VERTEX_1;
    protected class_291 VERTEX_2;
    protected boolean renderThrough = false;
    protected boolean useCulling = false;
    protected float glLineWidth = 3.0f;
    private List<class_238> boxes;
    private class_2338 center = null;
    protected class_2338 lastUpdatePos = null;
    private class_243 updateCameraPos = class_243.field_1353;
    private boolean hasData = false;
    private final boolean needsUpdate;
    private final int updateDistance = 48;

    public TestWalls() {
        this.needsUpdate = true;
        this.boxes = new ArrayList<class_238>();
    }

    public class_243 getUpdatePosition() {
        return this.updateCameraPos;
    }

    public void setUpdatePosition(class_243 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    public boolean needsUpdate(class_1297 cameraEntity, class_310 mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)this.updateDistance;
    }

    public void update(class_4184 camera, class_1297 entity, class_310 mc) {
        Color4f color = MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        int radius = MaLiLibConfigs.Test.TEST_CONFIG_INTEGER.getIntegerValue();
        class_243 vec = camera.method_19326();
        class_2338 pos = camera.method_19328();
        class_2338 testPos = pos.method_10069(2, 0, 2);
        Pair<class_2338, class_2338> corners = TestUtils.getSpawnChunkCorners(testPos, radius, (class_1937)mc.field_1687);
        this.boxes = TestUtils.calculateBoxes((class_2338)corners.getLeft(), (class_2338)corners.getRight());
        if (!this.boxes.isEmpty()) {
            this.center = testPos;
            this.hasData = true;
        } else {
            this.center = null;
            this.hasData = false;
        }
        this.setUpdatePosition(vec);
    }

    public void render(class_4184 camera, Matrix4f matrix4f, Matrix4f projMatrix, class_310 mc, class_3695 profiler) {
        profiler.method_15396("render_test_walls");
        if (this.hasData && !this.boxes.isEmpty() && this.center != null) {
            this.renderQuads(camera, mc, profiler);
            this.renderOutlines(camera, mc, profiler);
            this.draw(camera.method_19326(), matrix4f, projMatrix, mc, profiler);
            this.boxes.clear();
            this.center = null;
            this.hasData = false;
        }
        profiler.method_15407();
    }

    private void renderQuads(class_4184 camera, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !this.hasData || this.boxes.isEmpty()) {
            return;
        }
        if (this.VERTEX_1 == null || this.VERTEX_1.method_43444()) {
            this.VERTEX_1 = new class_291(class_291.class_8555.field_44793);
        }
        profiler.method_15396("quads");
        Color4f quadsColor = MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor();
        class_243 cameraPos = camera.method_19326();
        this.BUFFER_1 = this.TESSELLATOR_1.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtils.drawBlockBoundingBoxSidesBatchedQuads(this.center, cameraPos, quadsColor, 0.001, this.BUFFER_1);
        for (class_238 entry : this.boxes) {
            TestUtils.renderWallQuads(entry, cameraPos, quadsColor, this.BUFFER_1);
        }
        this.uploadData(this.BUFFER_1, this.VERTEX_1);
        profiler.method_15407();
    }

    private void renderOutlines(class_4184 camera, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !this.hasData || this.boxes.isEmpty()) {
            return;
        }
        if (this.VERTEX_2 == null || this.VERTEX_2.method_43444()) {
            this.VERTEX_2 = new class_291(class_291.class_8555.field_44793);
        }
        profiler.method_15396("outlines");
        Color4f linesColor = Color4f.WHITE;
        class_243 cameraPos = camera.method_19326();
        this.BUFFER_2 = this.TESSELLATOR_2.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(this.center, cameraPos, linesColor, 0.001, this.BUFFER_2);
        for (class_238 entry : this.boxes) {
            TestUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, linesColor, this.BUFFER_2);
        }
        this.uploadData(this.BUFFER_2, this.VERTEX_2);
        profiler.method_15407();
    }

    private void uploadData(class_287 bufferBuilder, class_291 vertexBuffer) {
        if (vertexBuffer.method_43444()) {
            return;
        }
        try {
            class_9801 builtBuffer = bufferBuilder.method_60794();
            if (builtBuffer != null) {
                this.hasData = true;
                vertexBuffer.method_1353();
                vertexBuffer.method_1352(builtBuffer);
                class_291.method_1354();
                builtBuffer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void preRender() {
        if (this.renderThrough) {
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
        }
        if (this.useCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.lineWidth((float)this.glLineWidth);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderUtils.setupBlend();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void postRender() {
        if (this.renderThrough) {
            RenderSystem.enableDepthTest();
        }
        if (!this.useCulling) {
            RenderSystem.enableCull();
        }
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    public void draw(class_243 cameraPos, Matrix4f matrix4f, Matrix4f projMatrix, class_310 mc, class_3695 profiler) {
        profiler.method_15400(() -> "TestWalls#draw()");
        this.preRender();
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        class_243 updatePos = this.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.field_1352 - cameraPos.field_1352), (float)(updatePos.field_1351 - cameraPos.field_1351), (float)(updatePos.field_1350 - cameraPos.field_1350));
        this.drawData(matrix4f, projMatrix);
        matrix4fstack.popMatrix();
        this.postRender();
        profiler.method_15407();
    }

    private void drawData(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (this.hasData) {
            this.preRender();
            this.drawInternal(matrix4f, projMatrix, this.VERTEX_1, class_757::method_34540);
            this.drawInternal(matrix4f, projMatrix, this.VERTEX_2, class_757::method_34540);
            this.postRender();
        }
    }

    private void drawInternal(Matrix4f matrix4f, Matrix4f projMatrix, class_291 vertexBuffer, Supplier<class_5944> shader) {
        if (this.hasData) {
            RenderSystem.setShader(shader);
            vertexBuffer.method_1353();
            vertexBuffer.method_34427(matrix4f, projMatrix, shader.get());
            class_291.method_1354();
        }
    }

    public void clear() {
        this.lastUpdatePos = class_2338.field_10980;
        this.hasData = false;
        this.boxes.clear();
        this.VERTEX_1.close();
        this.VERTEX_2.close();
        this.TESSELLATOR_1.method_60828();
        this.TESSELLATOR_2.method_60828();
    }

    @Override
    public void close() {
        this.clear();
    }
}

