/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.entity.IMixinMerchantEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3988;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8887;

public class InventoryOverlayScreen
extends class_437
implements class_4068 {
    String modId;
    private InventoryOverlay.Context previewData;
    private final boolean shulkerBGColors;
    private final boolean villagerBGColors;
    private int ticks;

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData) {
        this(modId, previewData, true, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData, boolean shulkerBGColors) {
        this(modId, previewData, shulkerBGColors, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData, boolean shulkerBGColors, boolean villagerBGColors) {
        super(StringUtils.translateAsText("malilib.gui.title.inventory_overlay", modId));
        this.modId = modId;
        this.previewData = previewData;
        this.shulkerBGColors = shulkerBGColors;
        this.villagerBGColors = villagerBGColors;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        ++this.ticks;
        class_310 mc = class_310.method_1551();
        class_1937 world = WorldUtils.getBestWorld(mc);
        if (this.previewData != null && world != null) {
            class_2586 class_25862;
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            int x = xCenter - 26;
            int y = yCenter - 92;
            int startSlot = 0;
            int totalSlots = this.previewData.inv() == null ? 0 : this.previewData.inv().method_5439();
            ArrayList<class_1799> armourItems = new ArrayList<class_1799>();
            if (this.previewData.entity() instanceof class_1496) {
                if (this.previewData.inv() == null) {
                    MaLiLib.LOGGER.warn("InventoryOverlayScreen(): Horse inv() = null");
                    return;
                }
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
                armourItems.add(this.previewData.inv().method_5438(0));
                startSlot = 1;
                totalSlots = this.previewData.inv().method_5439() - 1;
            } else if (this.previewData.entity() instanceof class_1493) {
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
            }
            InventoryOverlay.InventoryRenderType type = this.previewData.entity() instanceof class_1646 ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType(this.previewData.inv(), this.previewData.nbt() != null ? this.previewData.nbt() : new class_2487(), this.previewData);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (this.previewData.entity() != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if ((class_25862 = this.previewData.be()) instanceof class_8887) {
                class_8887 cbe = (class_8887)class_25862;
                lockedSlots = BlockUtils.getDisabledSlots(cbe);
            } else if (this.previewData.nbt() != null && this.previewData.nbt().method_10545("disabled_slots")) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(this.previewData.nbt());
            }
            if (!armourItems.isEmpty()) {
                class_1277 horseInv = new class_1277(armourItems.toArray(new class_1799[0]));
                InventoryOverlay.renderInventoryBackground(type, xInv, yInv, 1, horseInv.method_5439(), mc);
                InventoryOverlay.renderInventoryBackgroundSlots(type, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, drawContext);
                InventoryOverlay.renderInventoryStacks(type, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, horseInv.method_5439(), mc, drawContext, mouseX, mouseY);
                xInv += 36;
            }
            if (this.previewData.be() != null && (class_25862 = this.previewData.be().method_11010().method_26204()) instanceof class_2480) {
                class_2480 sbb = (class_2480)class_25862;
                RenderUtils.setShulkerboxBackgroundTintColor(sbb, this.shulkerBGColors);
            }
            if (totalSlots > 0 && this.previewData.inv() != null) {
                InventoryOverlay.renderInventoryBackground(type, xInv, yInv, props.slotsPerRow, totalSlots, mc);
                InventoryOverlay.renderInventoryStacks(type, this.previewData.inv(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, startSlot, totalSlots, lockedSlots, mc, drawContext, mouseX, mouseY);
            }
            if (this.previewData.type() == InventoryOverlay.InventoryRenderType.PLAYER && this.previewData.nbt() != null && this.previewData.nbt().method_10545("EnderItems")) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromNbt(this.previewData.nbt(), (class_7225.class_7874)world.method_30349());
                if (enderItems == null) {
                    enderItems = new class_1730();
                }
                yInv = yCenter + 6;
                InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInv, yInv, 9, 27, mc);
                InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, (class_1263)enderItems, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, drawContext, mouseX, mouseY);
            } else {
                enderItems = this.previewData.entity();
                if (enderItems instanceof class_1657) {
                    class_1657 player = (class_1657)enderItems;
                    yInv = yCenter + 6;
                    InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInv, yInv, 9, 27, mc);
                    InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, (class_1263)player.method_7274(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, drawContext, mouseX, mouseY);
                }
            }
            if (type == InventoryOverlay.InventoryRenderType.VILLAGER && this.previewData.nbt() != null && this.previewData.nbt().method_10545("Offers")) {
                offers = InventoryUtils.getSellingItemsFromNbt(this.previewData.nbt(), world.method_30349());
                class_1263 tradeOffers = InventoryUtils.getAsInventory(offers);
                if (tradeOffers != null && !tradeOffers.method_5442()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    RenderUtils.setVillagerBackgroundTintColor(NbtEntityUtils.getVillagerDataFromNbt(this.previewData.nbt()), this.villagerBGColors);
                    InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, mc);
                    InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, drawContext, mouseX, mouseY);
                }
            } else {
                class_3988 merchant;
                class_1916 trades;
                class_2371<class_1799> offers;
                class_1263 tradeOffers;
                offers = this.previewData.entity();
                if (offers instanceof class_3988 && (tradeOffers = InventoryUtils.getAsInventory(offers = (trades = ((IMixinMerchantEntity)(merchant = (class_3988)offers)).malilib_offers()) != null ? InventoryUtils.getSellingItems(trades) : class_2371.method_10211())) != null && !tradeOffers.method_5442()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    if (merchant instanceof class_1646) {
                        class_1646 villager = (class_1646)merchant;
                        RenderUtils.setVillagerBackgroundTintColor(villager.method_7231(), this.villagerBGColors);
                    }
                    InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, mc);
                    InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, drawContext, mouseX, mouseY);
                }
            }
            if (this.previewData.entity() != null) {
                InventoryOverlay.renderEquipmentOverlayBackground(x, y, this.previewData.entity(), drawContext);
                InventoryOverlay.renderEquipmentStacks(this.previewData.entity(), x, y, mc, drawContext, mouseX, mouseY);
            }
            if (this.ticks % 4 == 0) {
                this.previewData = this.previewData.handler().onContextRefresh(this.previewData, world);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    private void dumpOffers(class_2371<class_1799> offers, @Nonnull class_5455 registry) {
        System.out.print("dumpOffers(): DUMP OFFERS -->\n");
        if (offers == null || offers.isEmpty()) {
            System.out.print("EMPTY!\n");
            return;
        }
        int i = 0;
        for (class_1799 entry : offers) {
            if (entry.method_7960()) {
                System.out.printf("[%d]: EMPTY!\n", i);
            } else {
                System.out.printf("[%d] Item Nbt: [%s]\n", i, entry.method_57358((class_7225.class_7874)registry));
            }
            ++i;
        }
        System.out.print("END!\n");
    }
}

