/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.config.IConfigTable;
import fi.dy.masa.malilib.config.options.table.ConfigTable;
import fi.dy.masa.malilib.config.options.table.Label;
import fi.dy.masa.malilib.config.options.table.TableRow;
import fi.dy.masa.malilib.config.options.table.type.BooleanEntry;
import fi.dy.masa.malilib.config.options.table.type.DoubleEntry;
import fi.dy.masa.malilib.config.options.table.type.Entry;
import fi.dy.masa.malilib.config.options.table.type.EntryTypes;
import fi.dy.masa.malilib.config.options.table.type.IntegerEntry;
import fi.dy.masa.malilib.config.options.table.type.LabelEntry;
import fi.dy.masa.malilib.config.options.table.type.StringEntry;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonBoolean;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetKeybindSettings;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.widgets.WidgetListTableEdit;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class WidgetTableEditEntry
extends WidgetConfigOptionBase<TableRow> {
    protected final WidgetListTableEdit parent;
    protected final TableRow defaultValue;
    protected final int listIndex;
    protected final boolean isOdd;
    private final List<EntryTypes> types;
    private final List<Entry> entries;
    private ButtonGeneric buttonReset;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
    private final List<class_3545<ConfigButtonKeybind, WidgetKeybindSettings>> keybindWidgets = new ArrayList<class_3545<ConfigButtonKeybind, WidgetKeybindSettings>>();
    private final List<ConfigButtonBoolean> booleanWidgets = new ArrayList<ConfigButtonBoolean>();
    private final Map<WidgetLabel, Label> labels = new HashMap<WidgetLabel, Label>();
    protected TableRow initialValue;
    private final List<String> lastAppliedValues = new ArrayList<String>();

    public WidgetTableEditEntry(int x, int y, int width, int height, int listIndex, boolean isOdd, TableRow initialValue, TableRow defaultValue, WidgetListTableEdit parent, List<EntryTypes> types) {
        super(x, y, width, height, parent, initialValue, listIndex);
        this.listIndex = listIndex;
        this.isOdd = isOdd;
        this.defaultValue = defaultValue;
        this.initialValue = initialValue;
        this.entries = initialValue.list();
        this.parent = parent;
        this.types = types;
        int textFieldX = x + 5;
        int by = y + 4;
        int bOff = 18;
        if (!this.isDummy()) {
            int offset = 0;
            int bx = x + width - 30;
            if (this.parent.config.showEntryNumbers()) {
                this.addLabel(x + 2, y + 6, 20, 12, -1061109568, String.format("%3d:", listIndex + 1));
                textFieldX += 15;
            }
            if (this.parent.getConfig().allowNewEntry()) {
                this.addListActionButton(bx - offset, by, ButtonType.ADD);
                this.addListActionButton(bx - (offset += bOff), by, ButtonType.REMOVE);
                offset += bOff;
            }
            if (this.canBeMoved(true)) {
                this.addListActionButton(bx - offset, by, ButtonType.MOVE_DOWN);
            }
            offset += bOff;
            if (this.canBeMoved(false)) {
                this.addListActionButton(bx - offset, by, ButtonType.MOVE_UP);
            }
            int totalTextFieldWidth = bx - (offset += bOff) + 9 - textFieldX;
            bx = this.addWidgets(textFieldX, y + 2, bx - offset + 10, totalTextFieldWidth, 22, initialValue, types);
        } else {
            this.addListActionButton(textFieldX, by, ButtonType.ADD);
        }
    }

    protected boolean isDummy() {
        return this.listIndex < 0;
    }

    protected void addListActionButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, type.getIcon(), type.getDisplayName());
        ListenerListActions listener = new ListenerListActions(type, this);
        this.addButton(button, listener);
    }

    protected int addWidgets(int x, int y, int resetX, int configWidth, int configHeight, TableRow initialValue, List<EntryTypes> types) {
        this.buttonReset = this.createResetButton(resetX, y);
        boolean resetEnabled = false;
        configWidth -= this.buttonReset.getWidth();
        for (int i = 0; i < types.size(); ++i) {
            EntryTypes type = types.get(i);
            Entry value = initialValue.list().get(i);
            if (type == EntryTypes.STRING || type == EntryTypes.INTEGER || type == EntryTypes.DOUBLE) {
                GuiTextFieldGeneric guiTextFieldGeneric;
                Objects.requireNonNull(value);
                int n = 0;
                block6: while (true) {
                    Entry entry;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringEntry.class, IntegerEntry.class, DoubleEntry.class}, (Object)entry, n)) {
                        case 0: {
                            StringEntry ignored = (StringEntry)entry;
                            if (type != EntryTypes.STRING) {
                                n = 1;
                                continue block6;
                            }
                            guiTextFieldGeneric = new GuiTextFieldGeneric(x + i * (configWidth / types.size()) + 2, y, configWidth / types.size() - 4, configHeight - 3, this.textRenderer);
                            break block6;
                        }
                        case 1: {
                            IntegerEntry ignored = (IntegerEntry)entry;
                            if (type != EntryTypes.INTEGER) {
                                n = 2;
                                continue block6;
                            }
                            guiTextFieldGeneric = new GuiTextFieldInteger(x + i * (configWidth / types.size()) + 2, y, configWidth / types.size() - 4, configHeight - 3, this.textRenderer);
                            break block6;
                        }
                        case 2: {
                            DoubleEntry ignored = (DoubleEntry)entry;
                            if (type != EntryTypes.DOUBLE) {
                                n = 3;
                                continue block6;
                            }
                            guiTextFieldGeneric = new GuiTextFieldDouble(x + i * (configWidth / types.size()) + 2, y, configWidth / types.size() - 4, configHeight - 3, this.textRenderer);
                            break block6;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported type: " + type.name() + " with value: " + value.getType().name());
                        }
                    }
                    break;
                }
                GuiTextFieldGeneric tf = guiTextFieldGeneric;
                tf.method_1880(this.maxTextfieldTextLength);
                tf.method_1852(Entry.getString(value));
                TextFieldWrapper<GuiTextFieldGeneric> wrapper = new TextFieldWrapper<GuiTextFieldGeneric>(tf, textField -> {
                    this.checkResetButtonState();
                    return false;
                });
                this.parent.addTextField(wrapper);
                this.textFields.add(wrapper);
                this.keybindWidgets.add(null);
                this.booleanWidgets.add(null);
            } else if (type == EntryTypes.BOOLEAN) {
                ConfigButtonBoolean booleanButton = new ConfigButtonBoolean(x + i * (configWidth / types.size()) + 2, y, configWidth / types.size() - 4, configHeight - 3, ((BooleanEntry)value).getBooleanValue());
                booleanButton.setActionListener((button, mouseButton) -> this.checkResetButtonState());
                this.subWidgets.add(booleanButton);
                this.booleanWidgets.add(booleanButton);
                this.textFields.add(null);
                this.keybindWidgets.add(null);
            } else if (type == EntryTypes.LABEL) {
                WidgetLabel widgetLabel = new WidgetLabel(x + i * (configWidth / types.size()) + 2, y, configWidth / types.size() - 4, configHeight - 3, -1, ((LabelEntry)value).getValue().label());
                this.subWidgets.add(widgetLabel);
                this.labels.put(widgetLabel, ((LabelEntry)value).getValue());
                this.booleanWidgets.add(null);
                this.textFields.add(null);
                this.keybindWidgets.add(null);
            } else {
                throw new IllegalStateException("Unsupported type: " + type.name());
            }
            resetEnabled |= value.wasConfigModified(this.defaultValue.get(i));
        }
        this.addButton(this.buttonReset, (button, mouseButton) -> this.reset());
        this.buttonReset.setEnabled(resetEnabled);
        return this.buttonReset.getX() + this.buttonReset.getWidth() + 4;
    }

    protected ButtonGeneric createResetButton(int x, int y) {
        String labelReset = StringUtils.translate("malilib.gui.button.reset.caps", new Object[0]);
        ButtonGeneric resetButton = new ButtonGeneric(x, y, -1, 20, labelReset, new String[0]);
        resetButton.setX(x - resetButton.getWidth());
        return resetButton;
    }

    @Override
    public boolean wasConfigModified() {
        if (this.isDummy()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.wasConfigModified(this.initialValue.list().get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyNewValueToConfig() {
        IConfigTable config;
        List<TableRow> list;
        if (!this.isDummy() && (list = (config = this.parent.getConfig()).getTable()).size() > this.listIndex) {
            TableRow temp = new TableRow();
            this.lastAppliedValues.clear();
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                EntryTypes type = entry.getType();
                if (type == EntryTypes.STRING || type == EntryTypes.INTEGER || type == EntryTypes.DOUBLE) {
                    TextFieldWrapper<? extends GuiTextFieldGeneric> tfw = this.textFields.get(i);
                    String text = tfw.getTextField().method_1882();
                    this.lastAppliedValues.add(text);
                    if (type == EntryTypes.STRING) {
                        temp.list().add(StringEntry.of(text));
                        continue;
                    }
                    if (type == EntryTypes.INTEGER) {
                        if (text.isEmpty()) {
                            tfw.getTextField().method_1852("0");
                            temp.list().add(IntegerEntry.of(0));
                            this.checkResetButtonState();
                            continue;
                        }
                        temp.list().add(IntegerEntry.of(Integer.parseInt(text)));
                        continue;
                    }
                    if (type != EntryTypes.DOUBLE) continue;
                    if (text.isEmpty()) {
                        tfw.getTextField().method_1852("0.0");
                        temp.list().add(DoubleEntry.of(0.0));
                        this.checkResetButtonState();
                        continue;
                    }
                    try {
                        temp.list().add(DoubleEntry.of(Double.parseDouble(text)));
                    }
                    catch (NumberFormatException ignored) {
                        temp.list().add(DoubleEntry.of(0.0));
                    }
                    continue;
                }
                if (type == EntryTypes.BOOLEAN) {
                    assert (this.entries.get(i) instanceof BooleanEntry);
                    BooleanEntry booleanEntry = (BooleanEntry)this.entries.get(i);
                    temp.list().add(booleanEntry);
                    this.lastAppliedValues.add(Boolean.toString(booleanEntry.getValue()));
                    continue;
                }
                if (type != EntryTypes.LABEL) continue;
                LabelEntry labelEntry = (LabelEntry)this.entries.get(i);
                temp.list().add(labelEntry);
                this.lastAppliedValues.add(labelEntry.getValue().label() + ";" + labelEntry.getValue().comment());
            }
            list.set(this.listIndex, temp);
            config.setModified();
        }
    }

    private void insertEntryBefore() {
        List<TableRow> list = this.parent.getConfig().getTable();
        int size = list.size();
        int index = this.listIndex < 0 ? size : Math.min(this.listIndex, size);
        list.add(index, ConfigTable.getDummy(this.types));
        this.parent.getConfig().setModified();
        this.parent.refreshEntries();
        this.parent.markConfigsModified();
    }

    private void removeEntry() {
        List<TableRow> list = this.parent.getConfig().getTable();
        int size = list.size();
        if (this.listIndex >= 0 && this.listIndex < size) {
            list.remove(this.listIndex);
            this.parent.getConfig().setModified();
            this.parent.refreshEntries();
            this.parent.markConfigsModified();
        }
    }

    private void moveEntry(boolean down) {
        List<TableRow> list = this.parent.getConfig().getTable();
        int size = list.size();
        if (this.listIndex >= 0 && this.listIndex < size) {
            int index1 = this.listIndex;
            int index2 = -1;
            if (down && this.listIndex < size - 1) {
                index2 = index1 + 1;
            } else if (!down && this.listIndex > 0) {
                index2 = index1 - 1;
            }
            if (index2 >= 0) {
                this.parent.getConfig().setModified();
                this.parent.markConfigsModified();
                this.parent.applyPendingModifications();
                TableRow tmp = list.get(index1);
                list.set(index1, list.get(index2));
                list.set(index2, tmp);
                this.parent.refreshEntries();
            }
        }
    }

    private boolean canBeMoved(boolean down) {
        int size = this.parent.getConfig().getTable().size();
        return this.listIndex >= 0 && this.listIndex < size && (down && this.listIndex < size - 1 || !down && this.listIndex > 0);
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, class_332 ctx) {
        WidgetLabel widgetLabel;
        Label label;
        super.render(mouseX, mouseY, selected, ctx);
        if (this.isOdd) {
            RenderUtils.drawRect(this.x, this.y, this.width, this.height, 0x20FFFFFF);
        } else {
            RenderUtils.drawRect(this.x, this.y, this.width, this.height, 0x30FFFFFF);
        }
        this.drawSubWidgets(mouseX, mouseY, ctx);
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textFieldWrapper : this.textFields) {
            if (textFieldWrapper == null) continue;
            textFieldWrapper.getTextField().method_25394(ctx, mouseX, mouseY, 0.0f);
        }
        for (class_3545 class_35452 : this.keybindWidgets) {
            if (class_35452 == null) continue;
            ConfigButtonKeybind button = (ConfigButtonKeybind)class_35452.method_15442();
            WidgetKeybindSettings settings = (WidgetKeybindSettings)class_35452.method_15441();
            if (button != null) {
                button.render(mouseX, mouseY, selected, ctx);
            }
            if (settings == null) continue;
            settings.render(mouseX, mouseY, selected, ctx);
        }
        super.render(mouseX, mouseY, selected, ctx);
        WidgetBase widgetBase = this.hoveredSubWidget;
        if (widgetBase instanceof WidgetLabel && (label = this.labels.get(widgetLabel = (WidgetLabel)widgetBase)) != null && !label.comment().isEmpty()) {
            RenderUtils.drawHoverText(mouseX, mouseY, Collections.singletonList(label.comment()), ctx);
        }
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (class_3545<ConfigButtonKeybind, WidgetKeybindSettings> pair : this.keybindWidgets) {
            ConfigButtonKeybind button;
            if (pair == null || (button = (ConfigButtonKeybind)pair.method_15442()) == null) continue;
            if (button.isMouseOver(mouseX, mouseY)) {
                boolean selectedPre = button.isSelected();
                button.onMouseClicked(mouseX, mouseY, mouseButton);
                if (!selectedPre) {
                    button.onSelected();
                }
                this.checkResetButtonState();
                return true;
            }
            if (!button.isSelected()) continue;
            button.onClearSelection();
            this.checkResetButtonState();
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        for (class_3545<ConfigButtonKeybind, WidgetKeybindSettings> pair : this.keybindWidgets) {
            ConfigButtonKeybind button;
            if (pair == null || (button = (ConfigButtonKeybind)pair.method_15442()) == null || !button.isSelected()) continue;
            button.onKeyPressed(keyCode);
            if (keyCode == 256) {
                button.onClearSelection();
            }
            this.parent.getConfig().setModified();
            this.parent.markConfigsModified();
            this.checkResetButtonState();
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    private boolean checkResetButtonState() {
        for (int i = 0; i < this.types.size(); ++i) {
            EntryTypes type = this.types.get(i);
            if (type == EntryTypes.STRING || type == EntryTypes.INTEGER || type == EntryTypes.DOUBLE) {
                TextFieldWrapper<? extends GuiTextFieldGeneric> wrapper = this.textFields.get(i);
                if (wrapper == null) continue;
                String defaultText = Entry.getString(this.defaultValue.list().get(i));
                if (wrapper.getTextField().method_1882().equals(defaultText)) continue;
                this.buttonReset.setEnabled(true);
                return true;
            }
            if (type != EntryTypes.BOOLEAN) continue;
            assert (this.entries.get(i) instanceof BooleanEntry);
            BooleanEntry entry = (BooleanEntry)this.entries.get(i);
            if (!entry.getBooleanValue().isModified()) continue;
            this.buttonReset.setEnabled(true);
            return true;
        }
        this.buttonReset.setEnabled(false);
        return false;
    }

    private void reset() {
        for (int i = 0; i < this.types.size(); ++i) {
            EntryTypes type = this.types.get(i);
            if (type == EntryTypes.STRING || type == EntryTypes.INTEGER || type == EntryTypes.DOUBLE) {
                TextFieldWrapper<? extends GuiTextFieldGeneric> wrapper = this.textFields.get(i);
                if (wrapper == null) continue;
                String defaultText = Entry.getString(this.defaultValue.list().get(i));
                wrapper.getTextField().method_1852(defaultText);
                continue;
            }
            if (type != EntryTypes.BOOLEAN) continue;
            assert (this.entries.get(i) instanceof BooleanEntry);
            BooleanEntry entry = (BooleanEntry)this.entries.get(i);
            entry.getBooleanValue().resetToDefault();
            this.booleanWidgets.get(i).updateDisplayString();
        }
        this.checkResetButtonState();
    }

    @Override
    public boolean hasPendingModifications() {
        if (this.textFields.isEmpty()) {
            assert (this.isDummy());
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            TextFieldWrapper<? extends GuiTextFieldGeneric> tfw;
            String text;
            String lastApplied;
            Entry entry = this.entries.get(i);
            String string = lastApplied = i < this.lastAppliedValues.size() ? this.lastAppliedValues.get(i) : null;
            if (entry.getType() == EntryTypes.BOOLEAN) {
                assert (this.entries.get(i) instanceof BooleanEntry);
                BooleanEntry entry1 = (BooleanEntry)this.entries.get(i);
                String boolStr = Boolean.toString(entry1.getValue());
                if (boolStr.equals(lastApplied)) continue;
                return true;
            }
            if (entry.getType() != EntryTypes.DOUBLE && entry.getType() != EntryTypes.INTEGER && entry.getType() != EntryTypes.STRING || (text = (tfw = this.textFields.get(i)).getTextField().method_1882()).equals(lastApplied)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            return true;
        }
        boolean ret = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> tfw : this.textFields) {
            if (tfw == null) continue;
            ret |= tfw.getTextField().method_25402(mouseX, mouseY, mouseButton);
        }
        return ret;
    }

    @Override
    public boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> tfw : this.textFields) {
            if (tfw == null || !tfw.getTextField().method_25370()) continue;
            if (keyCode == 257) {
                this.applyNewValueToConfig();
                return true;
            }
            return tfw.onKeyTyped(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> tfw : this.textFields) {
            if (tfw == null || !tfw.onCharTyped(charIn, modifiers)) continue;
            return true;
        }
        return super.onCharTypedImpl(charIn, modifiers);
    }

    protected static enum ButtonType {
        ADD(MaLiLibIcons.PLUS, "malilib.gui.button.hovertext.add"),
        REMOVE(MaLiLibIcons.MINUS, "malilib.gui.button.hovertext.remove"),
        MOVE_UP(MaLiLibIcons.ARROW_UP, "malilib.gui.button.hovertext.move_up"),
        MOVE_DOWN(MaLiLibIcons.ARROW_DOWN, "malilib.gui.button.hovertext.move_down");

        private final MaLiLibIcons icon;
        private final String hoverTextKey;

        private ButtonType(MaLiLibIcons icon, String hoverTextKey) {
            this.icon = icon;
            this.hoverTextKey = hoverTextKey;
        }

        public IGuiIcon getIcon() {
            return this.icon;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.hoverTextKey, new Object[0]);
        }
    }

    private record ListenerListActions(ButtonType type, WidgetTableEditEntry parent) implements IButtonActionListener
    {
        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.ADD) {
                this.parent.insertEntryBefore();
            } else if (this.type == ButtonType.REMOVE) {
                this.parent.removeEntry();
            } else {
                this.parent.moveEntry(this.type == ButtonType.MOVE_DOWN);
            }
        }
    }
}

