/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigNotifiable;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;

public abstract class ConfigBase<T extends IConfigBase>
implements IConfigBase,
IConfigResettable,
IConfigNotifiable<T> {
    private final ConfigType type;
    private final String name;
    private String prettyName;
    private String comment;
    private String translatedName;
    private String translationPrefix = "";
    @Nullable
    private IValueChangeCallback<T> callback;
    public static final String COMMENT_KEY = "comment";
    public static final String PRETTY_NAME_KEY = "prettyName";
    public static final String TRANSLATED_NAME_KEY = "name";
    private static final boolean CONFIG_TYPE_DEBUG = false;

    public ConfigBase(ConfigType type, String name) {
        this(type, name, name + " Comment ?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigBase(ConfigType type, String name, String comment) {
        this(type, name, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigBase(ConfigType type, String name, String comment, String prettyName, String translatedName) {
        this.type = type;
        this.name = name;
        this.comment = comment;
        this.prettyName = prettyName;
        this.translatedName = translatedName;
    }

    @Override
    public ConfigType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrettyName() {
        String result = this.prettyName.isEmpty() ? StringUtils.splitCamelCase(this.getName()) : (this.prettyName.contains("prettyName.") || this.translationPrefix.isEmpty() ? StringUtils.getTranslatedOrFallback(this.prettyName, StringUtils.splitCamelCase(this.getName())) : StringUtils.getTranslatedOrFallback(this.prettyName, this.prettyName));
        this.printConfigElementDebug(this.type, PRETTY_NAME_KEY, this.prettyName, result);
        return result;
    }

    @Override
    @Nullable
    public String getComment() {
        Object result = this.comment.isEmpty() ? StringUtils.splitCamelCase(this.getName()) + " Comment?" : (this.translationPrefix.isEmpty() ? (this.comment.contains("comment.") ? StringUtils.getTranslatedOrFallback(this.comment, StringUtils.splitCamelCase(this.getName()) + " Comment?") : StringUtils.getTranslatedOrFallback("config.comment." + this.getName().toLowerCase(), this.comment)) : StringUtils.getTranslatedOrFallback(this.comment, this.comment));
        this.printConfigElementDebug(this.type, COMMENT_KEY, this.comment, (String)result);
        return result;
    }

    public T translatedName(String translatedName) {
        this.printConfigElementDebug(this.type, "translatedName", this.translatedName, translatedName);
        this.translatedName = translatedName;
        return (T)this;
    }

    public T apply(String translationPrefix) {
        if (!translationPrefix.isEmpty() && !translationPrefix.contains(" ") && translationPrefix.contains(".")) {
            this.translationPrefix = translationPrefix;
            this.comment = translationPrefix + ".comment." + this.getCleanName();
            this.prettyName = translationPrefix + ".prettyName." + this.getCleanName();
            this.translatedName = translationPrefix + ".name." + this.getCleanName();
        } else {
            this.translationPrefix = "";
            MaLiLib.LOGGER.error("ConfigBase: Failed to apply Translations Prefix for config named [{}].", (Object)this.getName());
        }
        this.printConfigElementDebug(this.type, "apply", "", this.translationPrefix);
        return (T)this;
    }

    @Override
    @Nullable
    public String getTranslatedName() {
        String result = this.translatedName.isEmpty() ? this.getName() : (this.translationPrefix.isEmpty() ? (this.translatedName.contains("name.") ? StringUtils.getTranslatedOrFallback(this.translatedName, this.getName()) : this.translatedName) : StringUtils.getTranslatedOrFallback(this.translatedName, this.translatedName));
        this.printConfigElementDebug(this.type, "translatedName", this.translatedName, result);
        return result;
    }

    @Override
    public void setPrettyName(String prettyName) {
        this.prettyName = prettyName;
    }

    @Override
    public void setTranslatedName(String translatedName) {
        this.translatedName = translatedName;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setValueChangeCallback(IValueChangeCallback<T> callback) {
        this.callback = callback;
    }

    @Override
    public void onValueChanged() {
        if (this.callback != null) {
            this.callback.onValueChanged(this);
        }
    }

    protected void printConfigElementDebug(ConfigType type, String element, String oldStr, String newStr) {
        if (MaLiLibConfigs.Debug.CONFIG_ELEMENT_DEBUG != null && MaLiLibConfigs.Debug.CONFIG_ELEMENT_DEBUG.getBooleanValue()) {
            MaLiLib.LOGGER.info("CONFIG: type [{}], element [{}], oldStr [{}], newStr [{}]", (Object)(type != null ? type.name() : "<NUL>"), (Object)element, (Object)oldStr, (Object)newStr);
        }
    }

    public String toString() {
        return "ConfigBase{type=['" + String.valueOf((Object)this.type) != null ? this.type.name() : "<NUL>'],name=['" + this.name + "'],prettyName=['" + this.prettyName + "'],translatedName=['" + this.translatedName + "'],translationPrefix=['" + this.translationPrefix + "'],comment=['" + this.comment + "']";
    }
}

