/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties;

import journeymap.common.properties.PermissionProperties;
import journeymap.common.properties.ServerOption;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.IntegerField;

public class GlobalProperties
extends PermissionProperties {
    public final BooleanField journeymapEnabled = new BooleanField(Category.Inherit, "jm.server.allow_journeymap", true, 1).categoryMaster(true);
    public final BooleanField useWorldId = new BooleanField(Category.Inherit, "jm.server.edit.chkbox.world.id", true, 10);
    public final BooleanField viewOnlyServerProperties = new BooleanField(Category.Inherit, "jm.server.allow_view_server_prop", true, 15);
    public final EnumField<ServerOption> allowMultiplayerSettings = new EnumField<ServerOption>(Category.Inherit, "jm.server.multiplayer_settings", ServerOption.ALL, 20);
    public final EnumField<ServerOption> worldPlayerRadar = new EnumField<ServerOption>(Category.Inherit, "jm.server.edit.tracking", ServerOption.ALL, 20).setParent("radarEnabled", (Object)ServerOption.ALL);
    public final IntegerField worldPlayerRadarUpdateTime = new IntegerField(Category.Inherit, "jm.server.edit.slider.update", 1, 20, 5, 30).setParent("worldPlayerRadar", (Object)ServerOption.ALL);
    public final EnumField<ServerOption> seeUndergroundPlayers = new EnumField<ServerOption>(Category.Inherit, "jm.server.see_underground_players", ServerOption.ALL, 42);
    public final BooleanField hideOps = new BooleanField(Category.Inherit, "jm.server.edit.hide_ops", false, 43);
    public final BooleanField hideSpectators = new BooleanField(Category.Inherit, "jm.server.radar_hide_spectators", false, 44);
    public final BooleanField allowDeathPoints = new BooleanField(Category.Inherit, "jm.server.allow_death_points", true, 44);
    public final BooleanField showInGameBeacons = new BooleanField(Category.Inherit, "jm.server.allow_in_game_beacons", true, 44);
    public final BooleanField allowWaypoints = new BooleanField(Category.Inherit, "jm.server.allow_waypoints", true, 44);
    public final BooleanField allowRightClickTeleport = new BooleanField(Category.Inherit, "jm.server.allow_right_click_teleport", true, 44);
    public final IntegerField radarLateralDistance = new IntegerField(Category.Inherit, "jm.common.radar_lateral_distance", 16, 512, 512, 200);
    public final IntegerField radarVerticalDistance = new IntegerField(Category.Inherit, "jm.common.radar_vertical_distance", 8, 320, 320, 201);
    public final IntegerField maxAnimalsData = new IntegerField(Category.Inherit, "jm.common.radar_max_animals", 1, 128, 128, 202);
    public final IntegerField maxAmbientCreaturesData = new IntegerField(Category.Inherit, "jm.common.radar_max_ambient_creatures", 1, 128, 128, 203);
    public final IntegerField maxMobsData = new IntegerField(Category.Inherit, "jm.common.radar_max_mobs", 1, 128, 128, 204);
    public final IntegerField maxPlayersData = new IntegerField(Category.Inherit, "jm.common.radar_max_players", 1, 128, 128, 205);
    public final IntegerField maxVillagersData = new IntegerField(Category.Inherit, "jm.common.radar_max_villagers", 1, 128, 128, 206);

    public GlobalProperties() {
        super("Global Server Configuration", "Applies to all dimensions unless overridden.");
    }

    @Override
    public String getName() {
        return "global";
    }

    @Override
    protected void postLoad(boolean isNew) {
        if (!isNew) {
            this.serverOptionFix(this.worldPlayerRadar);
        }
        super.postLoad(isNew);
    }

    @Override
    protected void preSave() {
        super.preSave();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        return ((GlobalProperties)clone).fromJsonString(this.toJsonString(false), this.getClass(), false);
    }
}

