/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.model.ClientState;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ClientPermissionsPacket
implements ClientState {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"journeymap", (String)"perm_req");
    public static final class_9139<class_9129, ClientPermissionsPacket> STREAM_CODEC = class_9139.method_56438(ClientPermissionsPacket::encode, ClientPermissionsPacket::new);
    private String payload;
    private boolean serverAdmin;
    private boolean hasServerMod = false;

    public ClientPermissionsPacket() {
        this.payload = "";
    }

    public ClientPermissionsPacket(String payload, boolean serverAdmin, boolean hasServerMod) {
        this.payload = payload;
        this.serverAdmin = serverAdmin;
        this.hasServerMod = hasServerMod;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    @Override
    public boolean hasServerMod() {
        return this.hasServerMod;
    }

    public ClientPermissionsPacket(class_2540 buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                this.serverAdmin = buf.readBoolean();
                this.payload = buf.method_10800(Short.MAX_VALUE);
                try {
                    this.hasServerMod = buf.readBoolean();
                }
                catch (Exception e) {
                    Journeymap.getLogger().debug("Permission set from external source.");
                    this.hasServerMod = false;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for client permissions: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            if (this.payload != null) {
                buf.method_52997(42);
                buf.method_52964(this.serverAdmin);
                buf.method_10814(this.payload);
                buf.method_52964(this.hasServerMod);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for client permissions:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<ClientPermissionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onClientPermsRequest(ctx.sender());
        } else {
            JourneymapClient.getInstance().getPacketHandler().onClientStateUpdate((ClientState)ctx.message());
        }
    }
}

