/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.ui.UIManager;
import journeymap.common.properties.config.StringField;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ThemeLabelSource
implements StringField.ValuesProvider {
    public static final Map<String, InfoSlot> values = new HashMap<String, InfoSlot>();
    public static InfoSlot FPS = ThemeLabelSource.create("jm.theme.labelsource.fps", 10L, 1L, ThemeLabelSource::getFps);
    public static InfoSlot GameTime = ThemeLabelSource.create("jm.theme.labelsource.gametime", 0L, 500L, ThemeLabelSource::getGameTime);
    public static InfoSlot GameTimeReal = ThemeLabelSource.create("jm.theme.labelsource.gametime.real", 0L, 500L, ThemeLabelSource::getGameTimeReal);
    public static InfoSlot RealTime = ThemeLabelSource.create("jm.theme.labelsource.realtime", 0L, 500L, ThemeLabelSource::getRealTime);
    public static InfoSlot Day = ThemeLabelSource.create("jm.theme.labelsource.day", 0L, 1000L, ThemeLabelSource::getDay);
    public static InfoSlot Location = ThemeLabelSource.create("jm.theme.labelsource.location", 100L, 1L, ThemeLabelSource::getLocation);
    public static InfoSlot Biome = ThemeLabelSource.create("jm.theme.labelsource.biome", 1000L, 1L, ThemeLabelSource::getBiome);
    public static InfoSlot Dimension = ThemeLabelSource.create("jm.theme.labelsource.dimension", 1000L, 1L, ThemeLabelSource::getDimension);
    public static InfoSlot Region = ThemeLabelSource.create("jm.theme.labelsource.region", 1000L, 1L, ThemeLabelSource::getRegion);
    public static InfoSlot LightLevel = ThemeLabelSource.create("jm.theme.labelsource.lightlevel", 100L, 100L, ThemeLabelSource::getLightLevel);
    public static InfoSlot MoonPhase = ThemeLabelSource.create("jm.theme.labelsource.moonphase", 100L, 100L, ThemeLabelSource::getMoonPhase);
    public static InfoSlot Blank = ThemeLabelSource.create("jm.theme.labelsource.blank", 0L, 1L, () -> class_2561.method_43470((String)""));
    public static InfoSlot Weather = ThemeLabelSource.create("jm.common.info_slot.weather", 10L, 10L, ThemeLabelSource::getCurrentWeather);
    public static InfoSlot MovementSpeed = ThemeLabelSource.create("jm.common.info_slot.movement_speed", 10L, 10L, ThemeLabelSource::getMovementsSpeed);

    public static InfoSlot create(String key, long cacheMillis, long granularityMillis, Supplier<class_2561> supplier) {
        InfoSlot slot = new InfoSlot(key, cacheMillis, granularityMillis, supplier);
        values.put(key, slot);
        return slot;
    }

    public static InfoSlot create(String modId, String key, long cacheMillis, long granularityMillis, Supplier<class_2561> supplier) {
        InfoSlot slot = new InfoSlot(modId, key, cacheMillis, granularityMillis, supplier);
        values.put(key, slot);
        return slot;
    }

    public static void resetCaches() {
        for (InfoSlot source : values.values()) {
            source.lastCallTime = 0L;
            source.lastValue = class_2561.method_43470((String)"");
        }
    }

    @Override
    public List<String> getStrings() {
        return values.values().stream().map(infoSlot -> infoSlot.key).sorted((o1, o2) -> Constants.getString(o1).compareToIgnoreCase(Constants.getString(o2))).collect(Collectors.toList());
    }

    @Override
    public String getDefaultString() {
        return null;
    }

    @Override
    public String getTooltip(String value) {
        InfoSlot slot = values.get(value);
        if (slot == null) {
            return null;
        }
        return slot.getTooltip();
    }

    private static class_2561 getDay() {
        return class_2561.method_43470((String)WorldData.getDay());
    }

    private static class_2561 getCurrentWeather() {
        return class_2561.method_43470((String)WorldData.getCurrentWeather());
    }

    private static class_2561 getFps() {
        return class_2561.method_43470((String)(class_310.field_1738 + " fps"));
    }

    private static class_2561 getGameTime() {
        return class_2561.method_43470((String)WorldData.getGameTime());
    }

    private static class_2561 getGameTimeReal() {
        return class_2561.method_43470((String)WorldData.getRealGameTime());
    }

    private static class_2561 getRealTime() {
        return class_2561.method_43470((String)WorldData.getSystemTime());
    }

    private static class_2561 getLocation() {
        if (JourneymapClient.getInstance().getStateHandler().isHideCoordinates()) {
            return class_2561.method_43471((String)"jm.common.unknown_location");
        }
        return class_2561.method_43470((String)UIManager.INSTANCE.getMiniMap().getLocation());
    }

    private static class_2561 getBiome() {
        return class_2561.method_43470((String)UIManager.INSTANCE.getMiniMap().getBiome());
    }

    private static class_2561 getDimension() {
        return class_2561.method_43470((String)WorldData.getDimension());
    }

    private static class_2561 getLightLevel() {
        return class_2561.method_43470((String)WorldData.getLightLevel());
    }

    private static class_2561 getRegion() {
        return class_2561.method_43470((String)WorldData.getRegion());
    }

    private static class_2561 getMoonPhase() {
        return class_2561.method_43470((String)WorldData.getMoonPhase());
    }

    private static class_2561 getMovementsSpeed() {
        return class_2561.method_43470((String)WorldData.getMovementSpeed());
    }

    public static class InfoSlot {
        private final String key;
        private final String modId;
        private final Supplier<class_2561> supplier;
        private final long cacheMillis;
        private final long granularityMillis;
        private long lastCallTime;
        private class_2561 lastValue = class_2561.method_43470((String)"");

        public InfoSlot(String key, long cacheMillis, long granularityMillis, Supplier<class_2561> supplier) {
            this.key = key;
            this.modId = "";
            this.supplier = supplier;
            this.cacheMillis = cacheMillis;
            this.granularityMillis = granularityMillis;
        }

        public InfoSlot(String modId, String key, long cacheMillis, long granularityMillis, Supplier<class_2561> supplier) {
            this.key = key;
            this.modId = modId;
            this.supplier = supplier;
            this.cacheMillis = cacheMillis;
            this.granularityMillis = granularityMillis;
        }

        public class_2561 getLabelText(long currentTimeMillis) {
            try {
                long now = this.granularityMillis * (currentTimeMillis / this.granularityMillis);
                if (now - this.lastCallTime <= this.cacheMillis) {
                    return this.lastValue;
                }
                this.lastCallTime = now;
                this.lastValue = this.supplier.get();
                return this.lastValue;
            }
            catch (Exception e) {
                return class_2561.method_43470((String)"?");
            }
        }

        public boolean isShown() {
            if (class_310.method_1551().field_1687 != null) {
                return this != Blank && this.supplier != null && this.supplier.get() != null && this.supplier.get() != null && !class_2561.method_43470((String)"").equals((Object)this.supplier.get());
            }
            return false;
        }

        public String getTooltip() {
            if (!Constants.getString(this.key + ".tooltip").equals(this.key + ".tooltip")) {
                String prefix = this.modId + ":";
                if ("".equals(this.modId)) {
                    return Constants.getString(this.key + ".tooltip");
                }
                return prefix + Constants.getString(this.key + ".tooltip");
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }
    }
}

