/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointOrigin;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_898;

public abstract class WaypointRenderer {
    protected WaypointProperties waypointProperties;
    protected final class_310 minecraft = class_310.method_1551();
    protected class_898 renderManager = this.minecraft.method_1561();
    protected List<ClientWaypointImpl> deleteQueue;

    protected WaypointRenderer() {
    }

    public abstract void render(class_332 var1);

    protected boolean canDrawWaypoint(ClientWaypointImpl waypoint, String playerDim) {
        WaypointGroupImpl group = WaypointGroupStore.getInstance().get(waypoint.getGroupId());
        return (WaypointOrigin.EXTERNAL_FORCE.getValue().equals(waypoint.getOrigin()) || waypoint.isEnabled() && (group != null && group.isEnabled() || "player_icon_display".equals(waypoint.getGroupId())) && JourneymapClient.getInstance().getWaypointProperties().beaconEnabled.get() != false && JourneymapClient.getInstance().getStateHandler().canShowInGameBeacons() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) && waypoint.getDimensions().contains(playerDim);
    }

    protected void renderWaypoint(ClientWaypointImpl waypoint, class_332 graphics, DrawStep.Pass pass, class_4597 buffers) {
        if (pass == DrawStep.Pass.Tooltip) {
            return;
        }
        if (this.renderManager == null) {
            this.renderManager = this.minecraft.method_1561();
        }
        float partialTicks = this.minecraft.method_60646().method_60637(true);
        long gameTime = this.minecraft.field_1687.method_8510();
        float fadeAlpha = 1.0f;
        class_243 waypointVec = waypoint.getPosition().method_1031(0.0, 0.118, 0.0);
        class_243 playerVec = this.minecraft.field_1724.method_19538();
        double actualDistance = playerVec.method_1022(waypointVec);
        int maxDistance = this.waypointProperties.maxDistance.get();
        int minDistance = this.waypointProperties.minDistance.get();
        float[] rgba = RGB.floats(waypoint.getRenderColor(), fadeAlpha * 0.4f);
        double viewX = this.renderManager.field_4686.method_19326().method_10216();
        double viewY = this.renderManager.field_4686.method_19326().method_10214();
        double viewZ = this.renderManager.field_4686.method_19326().method_10215();
        double viewDistance = actualDistance;
        double maxRenderDistance = (Integer)this.minecraft.field_1690.method_42503().method_41753() * 16;
        if (maxDistance > 0 && actualDistance > (double)maxDistance) {
            return;
        }
        if (waypoint.isDeathPoint() && this.waypointProperties.autoRemoveDeathpoints.get().booleanValue() && actualDistance < (double)this.waypointProperties.autoRemoveDeathpointDistance.get().intValue() && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing deathpoint " + String.valueOf(waypoint));
            this.deleteQueue.add(waypoint);
            return;
        }
        if (WaypointGroupStore.TEMP.getGuid().equals(waypoint.getGroupId()) && (actualDistance <= (double)this.waypointProperties.autoRemoveTempWaypoints.get().intValue() || actualDistance <= (double)(minDistance + 4)) && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing temp waypoint " + String.valueOf(waypoint));
            this.deleteQueue.add(waypoint);
            return;
        }
        if (minDistance > 0) {
            if ((int)actualDistance <= minDistance) {
                return;
            }
            if ((int)actualDistance <= minDistance + 4) {
                fadeAlpha = Math.min((float)(actualDistance - (double)minDistance) / 3.0f, 1.0f);
            }
        }
        if (viewDistance > maxRenderDistance && !this.waypointProperties.ignoreRenderDistance.get().booleanValue()) {
            class_243 delta = waypointVec.method_1020(playerVec).method_1029();
            waypointVec = playerVec.method_1031(delta.field_1352 * maxRenderDistance, delta.field_1351 * maxRenderDistance, delta.field_1350 * maxRenderDistance);
            viewDistance = maxRenderDistance;
        }
        double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
        double shiftX = waypointVec.field_1352 - viewX;
        double shiftY = waypointVec.field_1351 - viewY;
        double shiftZ = waypointVec.field_1350 - viewZ;
        this.render(graphics, pass, buffers, waypoint, partialTicks, gameTime, rgba, fadeAlpha, shiftX, shiftY, shiftZ, playerVec, waypointVec, viewDistance, actualDistance, scale);
    }

    protected abstract void render(class_332 var1, DrawStep.Pass var2, class_4597 var3, ClientWaypointImpl var4, float var5, long var6, float[] var8, float var9, double var10, double var12, double var14, class_243 var16, class_243 var17, double var18, double var20, double var22);
}

