/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.event.handlers.EntityRadarUpdateEventHandler;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.EntityDisplay;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class DrawEntityStep
implements DrawStep {
    static final Integer labelBg = 0;
    static final float labelBgAlpha = 0.7f;
    static final Integer labelFg = 0xFFFFFF;
    static final float labelFgAlpha = 0.88f;
    static class_1043 playerOutlineTexture;
    boolean useDots;
    int elevationOffset;
    int color;
    int labelColor;
    boolean hideSneaks;
    boolean hideSpectators;
    boolean showHeading = true;
    boolean showOutline = false;
    class_310 minecraft = class_310.method_1551();
    class_1043 entityTexture;
    class_1043 locatorTexture;
    class_1043 locatorBGTexture;
    WeakReference<class_1309> entityRef;
    class_2561 customName;
    class_2561 playerTeamName;
    Point2D screenPosition;
    EntityDTO entityDTO;
    float drawScale = 1.0f;
    private boolean showTeamName;
    private boolean showPlayerName;

    private DrawEntityStep(class_1309 entityLiving) {
        this.entityRef = new WeakReference<class_1309>(entityLiving);
        this.hideSneaks = JourneymapClient.getInstance().getCoreProperties().hideSneakingEntities.get();
        this.hideSpectators = JourneymapClient.getInstance().getCoreProperties().hideSpectators.get();
        if (playerOutlineTexture == null) {
            playerOutlineTexture = TextureCache.getTexture(TextureCache.PlayerOutline);
        }
    }

    public void update(EntityDisplay entityDisplay, class_1043 locatorTexture, class_1043 locatorBGTexture, class_1043 entityTexture, int color, int labelColor, boolean showHeading, boolean showTeamName, boolean showPlayerName, boolean showOutline, float entityDrawScale) {
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        this.entityDTO = DataCache.INSTANCE.getEntityDTO(entityLiving);
        if (entityLiving != null) {
            this.customName = this.entityDTO.getCustomName();
        }
        this.useDots = entityDisplay.isDots();
        this.color = color;
        this.labelColor = labelColor;
        this.locatorTexture = locatorTexture;
        this.locatorBGTexture = locatorBGTexture;
        this.entityTexture = entityTexture;
        this.drawScale = entityDrawScale;
        this.showHeading = showHeading;
        this.showTeamName = showTeamName;
        this.showPlayerName = showPlayerName;
        this.showOutline = showOutline;
        if (entityLiving instanceof class_1657) {
            class_268 team = entityLiving.method_5781();
            this.playerTeamName = team != null && showTeamName ? class_268.method_1142((class_270)entityLiving.method_5781(), (class_2561)entityLiving.method_5477()) : null;
        }
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Tooltip) {
            return;
        }
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.Object || pass == DrawStep.Pass.PostObject) {
            if (entityLiving == null || !entityLiving.method_5805() || entityLiving.method_5756((class_1657)this.minecraft.field_1724) || this.hideSneaks && entityLiving.method_5715() || this.hideSpectators && entityLiving.method_7325()) {
                this.screenPosition = null;
                return;
            }
            this.screenPosition = renderer.getPixel(entityLiving.method_23317(), entityLiving.method_23321());
        }
        if (this.screenPosition != null) {
            double heading = entityLiving.method_36454();
            double drawX = this.screenPosition.getX() + xOffset;
            double drawY = this.screenPosition.getY() + yOffset;
            float alpha = 1.0f;
            if (entityLiving.method_23318() > this.minecraft.field_1724.method_23318()) {
                alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.method_23318() - this.minecraft.field_1724.method_23318()) / 32.0));
            } else if (entityLiving.method_23318() < this.minecraft.field_1724.method_23318()) {
                alpha = 1.0f - Math.max(0.1f, (float)((this.minecraft.field_1724.method_23318() - entityLiving.method_23318()) / 32.0));
            }
            if (entityLiving instanceof class_1657) {
                alpha = JourneymapClient.getInstance().getCoreProperties().playerIconFade.get() != false ? alpha : 1.0f;
                this.drawPlayer(graphics, pass, buffers, drawX, drawY, renderer, alpha, heading, fontScale, rotation);
            } else {
                alpha = JourneymapClient.getInstance().getCoreProperties().mobIconFade.get() != false ? alpha : 1.0f;
                this.drawCreature(graphics, pass, buffers, drawX, drawY, renderer, alpha, heading, fontScale, rotation);
            }
        }
    }

    private void drawEntityTooltip(class_332 graphics, Renderer renderer, double drawX, double drawY, int imageWidth, int imageHeight) {
        boolean specialDebug;
        if (renderer.getFullscreen() != null && this.entityDTO != null && this.entityDTO.getEntityToolTips() != null && this.isMouseOverEntity(renderer, drawX, drawY, imageWidth, imageHeight)) {
            renderer.getFullscreen().queueToolTip(this.entityDTO.getEntityToolTips());
        }
        if (specialDebug = false) {
            double thick = 2.0;
            double x = drawX - (double)(imageWidth / 2);
            double y = drawY - (double)(imageHeight / 2);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick * thick, (double)imageWidth + thick * 4.0, thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y - thick, (double)imageWidth + thick * thick, thick, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick, thick, (double)imageHeight + thick * thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y, thick, imageHeight, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x + (double)imageWidth, y, thick, imageHeight, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x + (double)imageWidth + thick, y - thick, thick, (double)imageHeight + thick * thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y + (double)imageHeight, (double)imageWidth + thick * thick, thick, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y + (double)imageHeight + thick, (double)imageWidth + thick * 4.0, thick, 0, 0.6f);
        }
    }

    private boolean isMouseOverEntity(Renderer renderer, double drawX, double drawY, int imageWidth, int imageHeight) {
        double mouseX = (double)renderer.getMouseX() * renderer.getFullscreen().getScreenScaleFactor();
        double mouseY = (double)renderer.getMouseY() * renderer.getFullscreen().getScreenScaleFactor();
        double x = drawX - (double)(imageWidth / 2);
        double y = drawY - (double)(imageHeight / 2);
        return mouseX >= x && mouseX <= x + (double)imageWidth && mouseY >= y && mouseY <= y + (double)imageHeight;
    }

    private void drawPlayer(class_332 graphics, DrawStep.Pass pass, class_4597 buffers, double drawX, double drawY, Renderer renderer, float alpha, double heading, double fontScale, double rotation) {
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        if (entityLiving == null) {
            return;
        }
        if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.Object || pass == DrawStep.Pass.PostObject) {
            boolean drawingIcon;
            boolean bl = drawingIcon = this.entityTexture != null && !this.useDots;
            if (pass == DrawStep.Pass.PreObject && this.locatorTexture != null && !drawingIcon) {
                class_1921 renderType = JMRenderTypes.getIconUnmasked((class_1044)this.locatorTexture);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.locatorTexture, this.color, alpha, drawX, drawY, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                this.drawEntityTooltip(graphics, renderer, drawX, drawY, ((TextureAccess)this.locatorTexture).journeymap$getWidth() / 5, ((TextureAccess)this.locatorTexture).journeymap$getHeight() / 5);
            }
            if (this.entityTexture != null) {
                if (this.useDots) {
                    if (pass == DrawStep.Pass.Object) {
                        boolean flip = false;
                        this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.method_23318());
                        if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                            flip = this.elevationOffset < -1;
                            renderType = JMRenderTypes.getIconUnmasked((class_1044)this.entityTexture);
                            class_4588 vertexBuilder = buffers.getBuffer(renderType);
                            DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.entityTexture, this.color, alpha, drawX, drawY, this.drawScale / 5.0f, flip ? -rotation + 180.0 : -rotation);
                            this.drawEntityTooltip(graphics, renderer, drawX, drawY, ((TextureAccess)this.entityTexture).journeymap$getWidth() / 5, ((TextureAccess)this.entityTexture).journeymap$getHeight() / 5);
                        }
                    }
                } else {
                    class_4588 vertexBuilder;
                    float locatorScale = this.drawScale * 1.5f;
                    if (pass == DrawStep.Pass.PreObject && this.locatorBGTexture != null) {
                        renderType = JMRenderTypes.getIconUnmasked((class_1044)this.locatorBGTexture);
                        vertexBuilder = buffers.getBuffer(renderType);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.locatorBGTexture, this.color, alpha, drawX, drawY, locatorScale / 5.0f, this.showHeading ? -heading : -rotation);
                    }
                    if (pass == DrawStep.Pass.Object) {
                        renderType = JMRenderTypes.getIconUnmasked((class_1044)this.entityTexture);
                        vertexBuilder = buffers.getBuffer(renderType);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.entityTexture, 0xFFFFFF, alpha, drawX, drawY, this.drawScale, rotation);
                    }
                    if (pass == DrawStep.Pass.Object && this.showOutline) {
                        renderType = JMRenderTypes.getIconUnmasked((class_1044)playerOutlineTexture);
                        vertexBuilder = buffers.getBuffer(renderType);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder, playerOutlineTexture, this.color, alpha, drawX, drawY, this.drawScale, rotation);
                    }
                    if (pass == DrawStep.Pass.PostObject && this.locatorTexture != null) {
                        int locatorColor = this.entityDTO.getAggro() != false ? 0xFF0000 : 0;
                        class_1921 renderType = JMRenderTypes.getIconUnmasked((class_1044)this.locatorTexture);
                        class_4588 vertexBuilder2 = buffers.getBuffer(renderType);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder2, this.locatorTexture, locatorColor, alpha, drawX, drawY, locatorScale / 5.0f, this.showHeading ? -heading : -rotation);
                    }
                    if (pass == DrawStep.Pass.PostObject) {
                        this.drawEntityTooltip(graphics, renderer, drawX, drawY, ((TextureAccess)this.entityTexture).journeymap$getWidth(), ((TextureAccess)this.entityTexture).journeymap$getHeight());
                    }
                }
            }
        }
        if ((pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text) && JourneymapClient.getInstance().getStateHandler().isPlayerRadarNamesEnabled()) {
            int labelOffset = this.entityTexture == null ? 0 : (rotation == 0.0 ? -((TextureAccess)this.entityTexture).journeymap$getHeight() / 2 : ((TextureAccess)this.entityTexture).journeymap$getHeight() / 2);
            labelOffset = this.useDots ? (int)((double)labelOffset * ((double)(this.drawScale / 5.0f) * 0.4)) : (int)((float)labelOffset * this.drawScale);
            Point2D labelPoint = renderer.shiftWindowPosition((int)drawX, (int)drawY, 0, -labelOffset);
            if (this.playerTeamName != null && this.showTeamName) {
                DrawUtil.drawBatchLabel(graphics, this.playerTeamName, pass, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, this.labelColor, 1.0f, fontScale, false, rotation);
            } else if (this.showPlayerName) {
                class_2561 playerName = this.customName != null ? this.customName : entityLiving.method_5477();
                DrawUtil.drawBatchLabel(graphics, playerName, pass, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, this.labelColor, 1.0f, fontScale, false, rotation);
            }
        }
    }

    private void drawCreature(class_332 graphics, DrawStep.Pass pass, class_4597 buffers, double drawX, double drawY, Renderer renderer, float alpha, double heading, double fontScale, double rotation) {
        boolean tabDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)258) && (class_310.method_1551().field_1755 == null || class_310.method_1551().field_1755 instanceof Fullscreen);
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        if (entityLiving == null) {
            return;
        }
        if (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text) {
            class_2561 name = this.customName;
            if (name == null && tabDown) {
                name = EntityRadarUpdateEventHandler.getEntityName(this.entityDTO, renderer.getUIState(), true);
                EntityRadarUpdateEventHandler.addEntityToolTips(this.entityDTO, renderer.getUIState(), name, true);
            }
            if (name != null) {
                int labelOffset = this.entityTexture == null ? 8 : (rotation == 0.0 ? ((TextureAccess)this.entityTexture).journeymap$getHeight() : -((TextureAccess)this.entityTexture).journeymap$getHeight());
                labelOffset = this.useDots ? (int)((double)labelOffset * ((double)(this.drawScale / 5.0f) * 0.4)) : labelOffset;
                Point2D labelPoint = renderer.shiftWindowPosition(drawX, drawY, 0, Math.max(labelOffset, 16));
                int color = name.method_10866().method_10973() != null ? name.method_10866().method_10973().method_27716() : 0xFFFFFF;
                DrawUtil.drawBatchLabel(graphics, name, pass, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelBg, alpha, color, alpha, fontScale, false, rotation);
            }
        }
        if (pass == DrawStep.Pass.Object) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        }
        if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.Object || pass == DrawStep.Pass.PostObject) {
            boolean drawingIcon;
            boolean bl = drawingIcon = this.entityTexture != null && (!this.useDots || tabDown && EntityDisplay.hasEntityIcon(EntityDisplay.DotsAndOutlinedIcons, this.entityDTO));
            if (pass == DrawStep.Pass.Object && this.locatorTexture != null && !drawingIcon) {
                class_1921 renderType = JMRenderTypes.getIcon((class_1044)this.locatorTexture);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.locatorTexture, this.color, alpha, drawX, drawY, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                class_1043 tex = this.locatorTexture == null || this.locatorTexture.method_4525() == null ? this.locatorBGTexture : this.locatorTexture;
                this.drawEntityTooltip(graphics, renderer, drawX, drawY, (int)((float)(((TextureAccess)tex).journeymap$getWidth() / 5) * (this.drawScale / 2.0f)), (int)((float)(((TextureAccess)tex).journeymap$getHeight() / 5) * (this.drawScale / 2.0f)));
            }
            if (this.entityTexture != null) {
                if (!drawingIcon) {
                    if (pass == DrawStep.Pass.PreObject) {
                        this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.method_23318());
                        if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                            boolean flip = this.elevationOffset < -1;
                            class_1921 renderType = JMRenderTypes.getIcon((class_1044)this.entityTexture);
                            class_4588 vertexBuilder = buffers.getBuffer(renderType);
                            DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.entityTexture, this.color, alpha, drawX, drawY, this.drawScale / 5.0f, flip ? rotation + 180.0 : rotation);
                            class_1043 tex = this.entityTexture == null || this.entityTexture.method_4525() == null ? this.locatorBGTexture : this.entityTexture;
                            this.drawEntityTooltip(graphics, renderer, drawX, drawY, ((TextureAccess)tex).journeymap$getWidth() / 5, ((TextureAccess)tex).journeymap$getHeight() / 5);
                        }
                    }
                } else {
                    class_4588 vertexBuilder;
                    class_1921 renderType;
                    class_1043 locBGTexTemp = this.locatorBGTexture;
                    class_1043 entityTexTemp = this.entityTexture;
                    class_1043 locTexTemp = this.locatorTexture;
                    if (this.useDots) {
                        class_1043 quickTexture = EntityDisplay.getLocatorBGTexture(EntityDisplay.DotsAndOutlinedIcons, this.showHeading);
                        this.locatorBGTexture = quickTexture != null ? quickTexture : this.locatorBGTexture;
                        quickTexture = EntityDisplay.getEntityTexture(EntityDisplay.DotsAndOutlinedIcons, this.entityDTO);
                        this.entityTexture = quickTexture != null ? quickTexture : this.entityTexture;
                        quickTexture = EntityDisplay.getLocatorTexture(EntityDisplay.DotsAndOutlinedIcons, this.showHeading);
                        class_1043 class_10432 = this.locatorTexture = quickTexture != null ? quickTexture : this.locatorTexture;
                    }
                    if (this.drawScale > 1.0f) {
                        this.entityTexture = ((TextureAccess)this.entityTexture).journeymap$getScaledImage(this.drawScale);
                    }
                    if (pass == DrawStep.Pass.Object && this.locatorBGTexture != null) {
                        renderType = JMRenderTypes.getIcon((class_1044)this.locatorBGTexture);
                        vertexBuilder = buffers.getBuffer(renderType);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.locatorBGTexture, this.color, alpha, drawX, drawY, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                    }
                    if (pass == DrawStep.Pass.PreObject && this.entityTexture != null && this.entityTexture.method_4525() != null) {
                        renderType = JMRenderTypes.getIcon((class_1044)this.entityTexture);
                        vertexBuilder = buffers.getBuffer(renderType);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder, this.entityTexture, 0xFFFFFF, alpha, drawX, drawY, this.drawScale <= 1.0f ? this.drawScale : 1.0f, rotation);
                    }
                    if (pass == DrawStep.Pass.PostObject && this.locatorTexture != null && (!this.entityDTO.hasCustomIcon || this.entityDTO.drawOutline)) {
                        int locatorColor = this.entityDTO.getAggro() != false ? 0xFF0000 : 0;
                        class_1921 renderType2 = JMRenderTypes.getIcon((class_1044)this.locatorTexture);
                        class_4588 vertexBuilder2 = buffers.getBuffer(renderType2);
                        DrawUtil.drawColoredEntity(graphics, vertexBuilder2, this.locatorTexture, locatorColor, alpha, drawX, drawY, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                    }
                    if (pass == DrawStep.Pass.PostObject) {
                        graphics.method_51448().method_22903();
                        graphics.method_51448().method_46416(0.0f, 0.0f, 900.0f);
                        class_1043 tex = this.entityTexture == null || this.entityTexture.method_4525() == null ? this.locatorBGTexture : this.entityTexture;
                        this.drawEntityTooltip(graphics, renderer, drawX, drawY, ((TextureAccess)tex).journeymap$getWidth(), ((TextureAccess)tex).journeymap$getHeight());
                        graphics.method_51448().method_22909();
                    }
                    if (this.useDots) {
                        this.locatorBGTexture = locBGTexTemp;
                        this.entityTexture = entityTexTemp;
                        this.locatorTexture = locTexTemp;
                    }
                }
            }
        }
        if (pass == DrawStep.Pass.Object) {
            graphics.method_51448().method_22909();
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, Renderer renderer, boolean forceUpdate) {
        double x = this.entityDTO.posX;
        double z = this.entityDTO.posZ;
        double halfBlock = renderer.getUIState().blockSize / 2.0;
        Point2D.Double pixel = renderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        return pixel;
    }

    public void drawOffscreen(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, Point2D pixel, Renderer renderer, double rotation) {
        this.drawOffscreen(graphics, buffers, pass, pixel, renderer, rotation, false);
    }

    public void drawOffscreen(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, Point2D pixel, Renderer renderer, double rotation, boolean zeroOffset) {
        Object t = this.entityRef.get();
        if (t instanceof class_1657) {
            class_1657 entityLiving = (class_1657)t;
            if ((pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.Object || pass == DrawStep.Pass.PostObject || this.useDots && (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text)) && JourneymapClient.getInstance().getActiveMiniMapProperties().showOffScreenPlayers.get().booleanValue()) {
                double heading = entityLiving.method_36454();
                float alpha = 1.0f;
                if (entityLiving.method_23318() > this.minecraft.field_1724.method_23318()) {
                    alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.method_23318() - this.minecraft.field_1724.method_23318()) / 32.0));
                } else if (entityLiving.method_23318() < this.minecraft.field_1724.method_23318()) {
                    alpha = 1.0f - Math.max(0.1f, (float)((this.minecraft.field_1724.method_23318() - entityLiving.method_23318()) / 32.0));
                }
                float texOffsetX = (float)(((TextureAccess)this.entityTexture).journeymap$getWidth() >> 1) * (this.drawScale * 0.5f);
                float texOffsetY = (float)(((TextureAccess)this.entityTexture).journeymap$getHeight() >> 1) * (this.drawScale * 0.5f);
                if (this.useDots) {
                    texOffsetX *= 0.25f;
                    texOffsetY *= 0.25f;
                }
                if (zeroOffset) {
                    if (pixel.getX() <= 0.0) {
                        texOffsetX = -(texOffsetX * (this.useDots ? 0.25f : 0.5f));
                    }
                    if (pixel.getY() <= 0.0) {
                        texOffsetY = -(texOffsetY * (this.useDots ? 0.25f : 0.5f));
                    }
                }
                if (entityLiving instanceof class_1657) {
                    alpha = JourneymapClient.getInstance().getCoreProperties().playerIconFade.get() != false ? alpha : 1.0f;
                    this.drawPlayer(graphics, pass, buffers, pixel.getX() - (double)texOffsetX, pixel.getY() - (double)texOffsetY, renderer, alpha, heading, 1.0, rotation);
                }
            }
        }
    }

    @Override
    public int getDisplayOrder() {
        return this.customName != null ? 1 : 0;
    }

    @Override
    public String getModId() {
        return "journeymap";
    }

    public static class SimpleCacheLoader
    extends CacheLoader<class_1309, DrawEntityStep> {
        public DrawEntityStep load(class_1309 entityLiving) throws Exception {
            return new DrawEntityStep(entityLiving);
        }
    }
}

