/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.services;

import java.util.List;
import journeymap.api.v2.common.event.impl.EventFactory;
import journeymap.api.v2.common.event.impl.EventImpl;
import journeymap.api.v2.common.event.impl.JourneyMapEvent;

public class EventBus {
    public static <T extends JourneyMapEvent> T post(T event) {
        EventImpl impl = (EventImpl)EventFactory.getInstance().getEvents().get(event.getClass());
        if (impl != null && impl.getListeners() != null) {
            impl.getListeners().forEach(listener -> listener.listener().accept(event));
        }
        return event;
    }

    public static <T extends JourneyMapEvent> boolean hasListeners(T event) {
        List<EventImpl.Listener<JourneyMapEvent>> listeners = EventBus.getEventListeners(event);
        return listeners != null && !listeners.isEmpty();
    }

    public static <T extends JourneyMapEvent> List<EventImpl.Listener<JourneyMapEvent>> getEventListeners(T event) {
        return ((EventImpl)EventFactory.getInstance().getEvents().get(event.getClass())).getListeners();
    }

    public static <T extends JourneyMapEvent> boolean pluginHasListeners(String modId, T event) {
        List<EventImpl.Listener<JourneyMapEvent>> listeners = EventBus.getEventListeners(event);
        return listeners != null && listeners.size() > 0 && listeners.stream().anyMatch(listener -> listener.modId().equals(modId));
    }
}

