/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.screen.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4265;
import net.pneumono.pneumonocore.config_api.ClientConfigApi;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.ConfigFile;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigListEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.CategoryTitleEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.ErroneousConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.NoConfigsEntry;

@Environment(value=EnvType.CLIENT)
public class ConfigsList
extends class_4265<AbstractConfigListEntry> {
    private static final String MISC = "misc";
    protected final ConfigOptionsScreen parentScreen;
    public final ConfigFile configFile;
    private final Map<String, List<AbstractConfiguration<?>>> categorizedConfigs;
    private List<AbstractConfigListEntry> entries;

    public ConfigsList(ConfigOptionsScreen parentScreen) {
        super(parentScreen.getMinecraft(), parentScreen.field_22789, parentScreen.getContentHeight(), parentScreen.getHeaderHeight(), 20);
        this.parentScreen = parentScreen;
        this.configFile = ConfigApi.getConfigFile(this.parentScreen.modId);
        this.categorizedConfigs = new HashMap();
        List<Object> configurations = this.configFile == null ? new ArrayList() : this.configFile.getConfigurations();
        for (AbstractConfiguration abstractConfiguration : configurations) {
            this.categorizedConfigs.computeIfAbsent(abstractConfiguration.info().getCategory(), string -> new ArrayList()).add(abstractConfiguration);
        }
        if (this.categorizedConfigs.containsKey(MISC)) {
            this.categorizedConfigs.put(MISC, this.categorizedConfigs.remove(MISC));
        }
    }

    public void init() {
        this.entries = this.initEntryList();
        this.updateEntryList();
        this.updateEntryValues();
        this.method_25307(0.0);
    }

    public List<AbstractConfigListEntry> initEntryList() {
        ArrayList<AbstractConfigListEntry> newEntries = new ArrayList<AbstractConfigListEntry>();
        if (this.categorizedConfigs.isEmpty()) {
            newEntries.add(new NoConfigsEntry(this.parentScreen));
            return newEntries;
        }
        for (Map.Entry<String, List<AbstractConfiguration<?>>> categorizedConfig : this.categorizedConfigs.entrySet()) {
            if (this.categorizedConfigs.size() > 1) {
                Object translationKey = categorizedConfig.getKey().equals(MISC) ? "configs.category.pneumonocore.misc" : "configs.category." + this.configFile.getModId() + "." + categorizedConfig.getKey();
                newEntries.add(new CategoryTitleEntry(this.parentScreen, (String)translationKey));
            }
            for (AbstractConfiguration<?> configuration : categorizedConfig.getValue()) {
                AbstractConfigurationEntry<?, ?> entry = ClientConfigApi.getConfigEntryType(configuration.info().getConfigTypeId()).build(this.parentScreen, this, configuration);
                if (entry == null) {
                    entry = new ErroneousConfigurationEntry(this.parentScreen, this, configuration);
                }
                newEntries.add(entry);
            }
        }
        return newEntries;
    }

    public void updateEntryList() {
        this.method_25314(this.entries.stream().filter(AbstractConfigListEntry::shouldDisplay).toList());
    }

    public void updateEntryValues() {
        this.entries.forEach(AbstractConfigListEntry::updateButtons);
    }

    public List<AbstractConfigListEntry> getEntries() {
        return this.entries;
    }

    public AbstractConfigurationEntry<?, ?> getEntry(class_2960 id) {
        for (AbstractConfigListEntry entry : this.entries) {
            AbstractConfigurationEntry configEntry;
            if (!(entry instanceof AbstractConfigurationEntry) || !((AbstractConfiguration)(configEntry = (AbstractConfigurationEntry)entry).getConfiguration()).info().getId().equals((Object)id)) continue;
            return configEntry;
        }
        return null;
    }

    public int method_25322() {
        return super.method_25322() + 120;
    }
}

