/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigManager;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

public class ConfigFile {
    private final String modId;
    private final List<AbstractConfiguration<?>> configurations = new ArrayList();

    protected ConfigFile(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public void addConfiguration(AbstractConfiguration<?> configuration) {
        this.configurations.add(configuration);
    }

    public List<AbstractConfiguration<?>> getConfigurations() {
        return this.configurations;
    }

    public AbstractConfiguration<?> getConfiguration(String name) {
        for (AbstractConfiguration<?> configuration : this.configurations) {
            if (!configuration.info().getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    public void readSavedFromFile(LoadType loadType) {
        JsonObject jsonObject;
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.modId + ".json");
        if (!configFile.exists()) {
            ConfigApi.LOGGER.info("Config file for mod '{}' does not exist. Creating new one with default values...", (Object)this.modId);
            this.writeSavedToFile();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(configFile.toPath());
            jsonObject = (JsonObject)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            ConfigApi.LOGGER.error("Could not read config file for mod '{}'. Default config values will be used instead.", (Object)this.modId, (Object)e);
            return;
        }
        catch (JsonSyntaxException e) {
            ConfigApi.LOGGER.error("Config file for mod '{}' did not use valid syntax. Default config values will be used instead.", (Object)this.modId, (Object)e);
            return;
        }
        if (jsonObject == null) {
            ConfigApi.LOGGER.error("An error occurred reading config file for mod '{}'. Default config values will be used instead.", (Object)this.modId);
            return;
        }
        boolean shouldWrite = false;
        for (AbstractConfiguration<?> configuration : this.configurations) {
            String name = configuration.info().getName();
            JsonElement element = jsonObject.get(name);
            if (element == null) {
                shouldWrite = true;
                for (String alias : configuration.info().getAliases()) {
                    element = jsonObject.get(alias);
                    if (element == null) continue;
                    ConfigApi.LOGGER.info("Config file for mod '{}' contains a value for an alias of config '{}'.", (Object)this.modId, (Object)configuration.info().getId());
                    break;
                }
                if (element == null) {
                    ConfigApi.LOGGER.warn("Config file for mod '{}' does not contain a value for config '{}'. The default config value will be used instead.", (Object)this.modId, (Object)configuration.info().getId());
                    continue;
                }
            }
            if (ConfigFile.setConfigValue(configuration, element, loadType)) continue;
            ConfigApi.LOGGER.warn("Config file for mod '{}' contains invalid value '{}' for config '{}'. The default config value will be used instead.", new Object[]{this.modId, element, configuration.info().getId()});
            shouldWrite = true;
        }
        if (shouldWrite) {
            this.writeSavedToFile();
        }
    }

    private static <T> boolean setConfigValue(AbstractConfiguration<T> config, JsonElement jsonElement, LoadType loadType) {
        DataResult result = config.getValueCodec().decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
        if (MultiVersionUtil.resultIsError(result)) {
            return false;
        }
        ConfigManager.setValue(config, ((Pair)MultiVersionUtil.resultGetOrThrow(result)).getFirst(), loadType, null);
        return true;
    }

    public void writeSavedToFile() {
        JsonObject jsonObject = new JsonObject();
        for (AbstractConfiguration<?> config : this.configurations) {
            JsonElement jsonElement = ConfigFile.encodeJson(config);
            jsonObject.add(config.info().getName(), jsonElement);
        }
        this.writeObjectToFile(jsonObject);
    }

    private static <T> JsonElement encodeJson(AbstractConfiguration<T> config) {
        DataResult result = config.getValueCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, ConfigManager.getSavedValue(config));
        if (MultiVersionUtil.resultIsError(result)) {
            ConfigApi.LOGGER.error("Could not encode value for config '{}'. The default value will be encoded instead.", (Object)config.info().getId());
            result = config.getValueCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, config.info().getDefaultValue());
        }
        return (JsonElement)result.getOrThrow(message -> new IllegalStateException("Could not encode default value for config '" + String.valueOf(config.info().getId()) + "'"));
    }

    public void writeObjectToFile(JsonObject jsonObject) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.modId + ".json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(configFile.toPath(), new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            ConfigApi.LOGGER.error("Could not write configuration file for mod {}.", (Object)this.modId, (Object)e);
        }
    }
}

