/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.server;

import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.server.ManifestManager;
import com.plsnerfrito.plsnerfmodcheck.server.ModListManager;
import com.plsnerfrito.plsnerfmodcheck.server.ServerInitializer;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;

public class ServerConfigInitializer {
    public static void initialize(Class<? extends ServerInitializer> serverInitializerClass) {
        Logger.DEV_LOGGER.debug("Starting configuration load process for: {}", serverInitializerClass);
        Config.loadConfig(serverInitializerClass);
        if (Config.useManifestFile) {
            Logger.USER_LOGGER.info("The configuration is using manifest.json.");
            Logger.DEV_LOGGER.debug("Manifest file creation is starting.");
            ManifestManager.createManifest();
            Logger.DEV_LOGGER.debug("Manifest file creation completed.");
        } else {
            Logger.USER_LOGGER.info("The configuration is using modlist.json.");
            Logger.DEV_LOGGER.debug("Modlist file creation is starting.");
            ModListManager.createModList();
            Logger.DEV_LOGGER.debug("Modlist file creation completed.");
        }
    }
}

