/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ModListManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void createModList() {
        File modlistFile = new File(Config.modListPath);
        if (!modlistFile.exists()) {
            try (FileWriter writer = new FileWriter(modlistFile);){
                ArrayList initialContent = new ArrayList();
                HashMap<String, String> fabricApiMod = new HashMap<String, String>();
                fabricApiMod.put("id", "fabric-api");
                fabricApiMod.put("name", "Fabric API");
                fabricApiMod.put("version", "0.114.0+1.21.1");
                HashMap<String, String> plsnerfModCheck = new HashMap<String, String>();
                plsnerfModCheck.put("id", "plsnerfmodcheck");
                plsnerfModCheck.put("name", "plsnerfModCheck");
                plsnerfModCheck.put("version", "1.0.0");
                initialContent.add(fabricApiMod);
                initialContent.add(plsnerfModCheck);
                GSON.toJson(initialContent, (Appendable)writer);
                Logger.USER_LOGGER.info("The mod list file has been successfully created at: {}", (Object)modlistFile.getAbsolutePath());
                Logger.DEV_LOGGER.debug("File creation details: path={}, initialContent={}", (Object)modlistFile.getAbsolutePath(), initialContent);
            }
            catch (IOException e) {
                Logger.USER_LOGGER.error("An error occurred while creating the mod list file.");
                Logger.DEV_LOGGER.error("Technical error details: {}", (Object)e.getMessage());
            }
        } else {
            Logger.USER_LOGGER.info("The mod list file already exists. No changes required.");
            Logger.DEV_LOGGER.debug("File existence confirmed at: {}", (Object)modlistFile.getAbsolutePath());
        }
    }
}

