/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class CurseForgeIntegration {
    private static final String CURSEFORGE_API_URL = "XXX";
    private static final String API_KEY = "XXX";

    public static void processManifest(File manifestFile, File modlistFile) {
        try {
            Logger.USER_LOGGER.info("Processing manifest file: {}", (Object)manifestFile.getName());
            Logger.DEV_LOGGER.debug("Full path of manifest file: {}", (Object)manifestFile.getAbsolutePath());
            JsonObject manifest = CurseForgeIntegration.readJsonFile(manifestFile);
            if (manifest == null || !manifest.has("files")) {
                Logger.USER_LOGGER.warn("The manifest.json is invalid or does not contain a 'files' section.");
                Logger.DEV_LOGGER.warn("Manifest file validation failed: 'files' section missing or null.");
                return;
            }
            JsonArray filesArray = manifest.getAsJsonArray("files");
            ArrayList<JsonObject> modDataList = new ArrayList<JsonObject>();
            for (JsonElement fileElement : filesArray) {
                JsonObject file = fileElement.getAsJsonObject();
                int projectId = file.get("projectID").getAsInt();
                int fileId = file.get("fileID").getAsInt();
                boolean required = file.get("required").getAsBoolean();
                Logger.DEV_LOGGER.debug("Fetching mod information for Project ID: {}, File ID: {}", (Object)projectId, (Object)fileId);
                JsonObject modInfo = CurseForgeIntegration.fetchModInfoFromCurseForge(projectId, fileId);
                if (modInfo != null) {
                    modInfo.addProperty("required", Boolean.valueOf(required));
                    modDataList.add(modInfo);
                    Logger.USER_LOGGER.info("Successfully retrieved information for mod with Project ID: {}", (Object)projectId);
                    Logger.DEV_LOGGER.debug("Full mod information retrieved: {}", (Object)modInfo);
                    continue;
                }
                Logger.USER_LOGGER.warn("No mod information found for mod with Project ID: {}", (Object)projectId);
                Logger.DEV_LOGGER.warn("Unable to retrieve information for Project ID: {}, File ID: {}", (Object)projectId, (Object)fileId);
            }
            CurseForgeIntegration.writeModList(modlistFile, modDataList);
            Logger.DEV_LOGGER.debug("Die Mod-Liste wurde erfolgreich aktualisiert und in {} geschrieben.", (Object)modlistFile.getAbsolutePath());
        }
        catch (Exception e) {
            Logger.DEV_LOGGER.debug("Fehler beim Verarbeiten der Manifest-Datei.", (Throwable)e);
        }
    }

    private static JsonObject readJsonFile(File file) throws IOException {
        Logger.DEV_LOGGER.debug("Reading JSON file: {}", (Object)file.getAbsolutePath());
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            return jsonObject;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject fetchModInfoFromCurseForge(int projectId, int fileId) {
        try {
            URI uri = new URI("XXX/mods/" + projectId + "/files/" + fileId);
            URL url = uri.toURL();
            Logger.DEV_LOGGER.debug("Sending request to CurseForge API: {}", (Object)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("x-api-key", "XXX");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Logger.DEV_LOGGER.warn("Error fetching mod information: HTTP {} for Project ID: {}, File ID: {}", new Object[]{responseCode, projectId, fileId});
                Logger.USER_LOGGER.warn("Unable to retrieve mod details for Project ID: {}", (Object)projectId);
                return null;
            }
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                JsonObject response = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                Logger.DEV_LOGGER.debug("Response received from CurseForge API: {}", (Object)response);
                JsonObject jsonObject = response.getAsJsonObject("data");
                return jsonObject;
            }
        }
        catch (Exception e) {
            Logger.DEV_LOGGER.error("Error while fetching mod information for Project ID: {}, File ID: {}", new Object[]{projectId, fileId, e});
        }
        return null;
    }

    private static void writeModList(File modlistFile, List<JsonObject> modDataList) throws IOException {
        Logger.DEV_LOGGER.debug("Writing mod list to file: {}", (Object)modlistFile.getAbsolutePath());
        Logger.USER_LOGGER.info("Saving fetched mod information...");
        try (FileWriter writer = new FileWriter(modlistFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(modDataList, (Appendable)writer);
        }
    }
}

