/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ModListComparator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final boolean multiClient;
    private final File singleClientHashFile;
    private final File multiClientHashFile;
    private List<String> hashList;
    private String singleHash;

    public ModListComparator(boolean multiClient) {
        this.multiClient = multiClient;
        this.singleClientHashFile = Config.SINGLE_CLIENT_HASH_FILE;
        this.multiClientHashFile = Config.MULTI_CLIENT_HASH_FILE;
        if (multiClient) {
            this.createHashFile(this.multiClientHashFile, true);
            this.hashList = this.loadHashList();
        }
        this.createHashFile(this.singleClientHashFile, false);
        this.singleHash = this.generateHash();
        this.saveSingleHash(this.singleHash);
        this.addSingleHashToMultiClientFile(this.singleHash);
    }

    private void addSingleHashToMultiClientFile(String singleHash) {
        block15: {
            if (!this.multiClientHashFile.exists()) {
                Logger.USER_LOGGER.warn("The multi-client hash file does not exist. It will be created.");
                Logger.DEV_LOGGER.debug("Creating missing multi-client hash file: {}", (Object)this.multiClientHashFile.getAbsolutePath());
                this.createHashFile(this.multiClientHashFile, true);
            }
            try (FileReader reader = new FileReader(this.multiClientHashFile);){
                JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                JsonArray hashArray = element != null && element.isJsonArray() ? element.getAsJsonArray() : new JsonArray();
                boolean exists = false;
                for (JsonElement hashElement : hashArray) {
                    if (!hashElement.isJsonPrimitive() || !hashElement.getAsString().equals(singleHash)) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    hashArray.add(singleHash);
                    try (FileWriter writer = new FileWriter(this.multiClientHashFile);){
                        GSON.toJson((JsonElement)hashArray, (Appendable)writer);
                        Logger.USER_LOGGER.info("Single-client hash added to the multi-client hash file.");
                        Logger.DEV_LOGGER.debug("Added single-client hash '{}' to multi-client hash file.", (Object)singleHash);
                        break block15;
                    }
                }
                Logger.USER_LOGGER.info("The single-client hash already exists in the multi-client hash file.");
                Logger.DEV_LOGGER.debug("Hash '{}' already exists in the multi-client file.", (Object)singleHash);
            }
            catch (IOException e) {
                Logger.DEV_LOGGER.error("Error adding the single-client hash to the multi-client hash file: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public String generateHash() {
        try {
            File modListFile = Config.MODLIST_FILE;
            return ModListComparator.generateModListHash(modListFile);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            Logger.DEV_LOGGER.error("Error generating hash: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public boolean compareHash(String clientHash) {
        if (this.multiClient) {
            return this.hashList != null && this.hashList.contains(clientHash);
        }
        return this.singleHash != null && this.singleHash.equals(clientHash);
    }

    public void saveSingleHash(String hash) {
        try (FileWriter writer = new FileWriter(this.singleClientHashFile);){
            JsonObject hashJson = new JsonObject();
            hashJson.addProperty("hash", hash);
            GSON.toJson((JsonElement)hashJson, (Appendable)writer);
            Logger.USER_LOGGER.info("Single-client hash has been saved.");
            Logger.DEV_LOGGER.debug("Single-client hash '{}' saved to file: {}", (Object)hash, (Object)this.singleClientHashFile.getAbsolutePath());
        }
        catch (IOException e) {
            Logger.DEV_LOGGER.error("Error saving single-client hash: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void saveHashList(List<String> hashList) {
        try (FileWriter writer = new FileWriter(this.multiClientHashFile);){
            JsonArray hashArray = new JsonArray();
            for (String hash : hashList) {
                hashArray.add(hash);
            }
            GSON.toJson((JsonElement)hashArray, (Appendable)writer);
            Logger.USER_LOGGER.info("Multi-client hash list has been saved.");
            Logger.DEV_LOGGER.debug("Saved multi-client hash list '{}' to file: {}", hashList, (Object)this.multiClientHashFile.getAbsolutePath());
        }
        catch (IOException e) {
            Logger.DEV_LOGGER.error("Error saving the multi-client hash list: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createHashFile(File file, boolean multiClient) {
        if (!file.exists()) {
            try (FileWriter writer = new FileWriter(file);){
                if (multiClient) {
                    JsonArray hashArray = new JsonArray();
                    GSON.toJson((JsonElement)hashArray, (Appendable)writer);
                    Logger.USER_LOGGER.info("An empty hash list for multi-client mode has been created.");
                    Logger.DEV_LOGGER.debug("Created empty hash list file for multi-client mode at: {}", (Object)file.getAbsolutePath());
                } else {
                    JsonObject hashJson = new JsonObject();
                    hashJson.addProperty("hash", "");
                    GSON.toJson((JsonElement)hashJson, (Appendable)writer);
                    Logger.USER_LOGGER.info("An empty hash for single-client mode has been created.");
                    Logger.DEV_LOGGER.debug("Created empty hash file for single-client mode at: {}", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                Logger.DEV_LOGGER.error("Error while creating hash file: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            Logger.USER_LOGGER.info("Hash file already exists. No need to create a new one.");
            Logger.DEV_LOGGER.debug("Hash file exists at: {}", (Object)file.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadSingleHash() {
        if (!this.singleClientHashFile.exists()) {
            Logger.USER_LOGGER.warn("The single-client hash file does not exist.");
            Logger.DEV_LOGGER.debug("Missing single-client hash file: {}", (Object)this.singleClientHashFile.getAbsolutePath());
            return null;
        }
        try (FileReader reader = new FileReader(this.singleClientHashFile);){
            JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (element.isJsonObject()) {
                JsonObject hashJson = element.getAsJsonObject();
                String string = hashJson.has("hash") ? hashJson.get("hash").getAsString() : null;
                return string;
            }
            Logger.DEV_LOGGER.error("The single-client hash file does not contain a valid JSON object.");
            return null;
        }
        catch (IOException e) {
            Logger.DEV_LOGGER.error("Error loading saved hash: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadHashList() {
        if (!this.multiClientHashFile.exists()) {
            Logger.USER_LOGGER.warn("The multi-client hash file does not exist.");
            Logger.DEV_LOGGER.debug("Missing multi-client hash file at: {}", (Object)this.multiClientHashFile.getAbsolutePath());
            return Collections.emptyList();
        }
        try (FileReader reader = new FileReader(this.multiClientHashFile);){
            JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (element.isJsonArray()) {
                ArrayList<String> hashes = new ArrayList<String>();
                Object arrayList = element.getAsJsonArray().iterator();
                while (true) {
                    if (!arrayList.hasNext()) {
                        arrayList = hashes;
                        return arrayList;
                    }
                    JsonElement hashElement = (JsonElement)arrayList.next();
                    hashes.add(hashElement.getAsString());
                }
            }
            Logger.DEV_LOGGER.error("The multi-client hash file does not contain a valid JSON array.");
            return Collections.emptyList();
        }
        catch (IOException e) {
            Logger.DEV_LOGGER.error("Error loading hash list: {}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.emptyList();
    }

    public static String generateModListHash(File modListFile) throws IOException, NoSuchAlgorithmException {
        JsonArray modList = ModListComparator.readModList(modListFile);
        if (modList == null) {
            throw new IOException("Modliste konnte nicht gelesen werden: " + modListFile.getAbsolutePath());
        }
        ArrayList<JsonObject> modObjects = new ArrayList<JsonObject>();
        for (Object element : modList) {
            if (!element.isJsonObject()) continue;
            modObjects.add(element.getAsJsonObject());
        }
        modObjects.sort(Comparator.comparing(JsonElement::toString));
        StringBuilder modListString = new StringBuilder();
        for (JsonObject modObject : modObjects) {
            modListString.append(modObject.toString());
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(modListString.toString().getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashBytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonArray readModList(File modListFile) {
        try (FileReader reader = new FileReader(modListFile);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element.isJsonArray()) {
                JsonArray jsonArray = element.getAsJsonArray();
                return jsonArray;
            }
            Logger.DEV_LOGGER.error("The mod list file does not contain a valid JSON array.");
            return null;
        }
        catch (IOException e) {
            Logger.DEV_LOGGER.error("Error reading mod list file: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

