/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String CONFIG_FOLDER = String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/plsnerfmodcheck";
    public static final File CONFIG_FILE = new File(CONFIG_FOLDER, "config.json");
    public static final File MANIFEST_FILE = new File(CONFIG_FOLDER, "manifest.json");
    public static final File MODLIST_FILE = new File(CONFIG_FOLDER, "modlist.json");
    public static final File SINGLE_CLIENT_HASH_FILE = new File(CONFIG_FOLDER, "single_client_modlist.hash");
    public static final File MULTI_CLIENT_HASH_FILE = new File(CONFIG_FOLDER, "multi_client_modlist.hash");
    public static int TIMEOUT_SECONDS = 3;
    public static boolean enableMod = true;
    public static String configPath = CONFIG_FILE.getPath();
    public static String manifestPath = MANIFEST_FILE.getPath();
    public static String modListPath = MODLIST_FILE.getPath();
    public static boolean useManifestFile = false;
    public static boolean enableLogging = true;
    public static boolean multiClient = false;
    public static String downloadLink = "https://www.curseforge.com/minecraft/modpacks/bmplsnerfrito-client";

    public static void loadConfig(Class<?> clazz) {
        Config.createConfigFolder();
        List<String> clientAttributes = List.of("enableMod", "configPath");
        List<String> serverAttributes = List.of("enableMod", "configPath", "useManifestFile", "multiClient", "TIMEOUT_SECONDS", "downloadLink");
        List<String> selectedAttributes = null;
        if (clazz.getName().equals("com.plsnerfrito.plsnerfmodcheck.client.ClientInitializer")) {
            selectedAttributes = clientAttributes;
        } else if (clazz.getName().equals("com.plsnerfrito.plsnerfmodcheck.server.ServerInitializer")) {
            selectedAttributes = serverAttributes;
        }
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Logger.DEV_LOGGER.debug("Reading configuration file: {}", (Object)CONFIG_FILE.getPath());
                Map filteredConfig = (Map)GSON.fromJson((Reader)reader, Map.class);
                for (String attribute : selectedAttributes) {
                    if (!filteredConfig.containsKey(attribute)) continue;
                    Field field = Config.class.getDeclaredField(attribute);
                    field.setAccessible(true);
                    Object value = filteredConfig.get(attribute);
                    if (field.getType() == Integer.TYPE && value instanceof Double) {
                        field.set(null, ((Double)value).intValue());
                        continue;
                    }
                    field.set(null, value);
                }
                Logger.USER_LOGGER.info("Configuration loaded successfully.");
                Logger.DEV_LOGGER.debug("Configuration loaded with filtered attributes: {}", selectedAttributes);
            }
            catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                Logger.DEV_LOGGER.error("Error while loading configuration: {}", (Object)e.getMessage(), (Object)e);
                Logger.USER_LOGGER.warn("Failed to load configuration. Using default values.");
            }
        } else {
            Logger.USER_LOGGER.info("No configuration file found. Creating default configuration.");
            Logger.DEV_LOGGER.debug("Creating and saving default configuration.");
            Config.saveConfig(selectedAttributes);
        }
    }

    public static void saveConfig(List<String> attributeNames) {
        Config.createConfigFolder();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            Logger.DEV_LOGGER.debug("Saving configuration to file: {}", (Object)CONFIG_FILE.getPath());
            Map<String, Object> filteredConfig = Config.filterConfigForAttributes(attributeNames, true);
            GSON.toJson(filteredConfig, (Appendable)writer);
            Logger.USER_LOGGER.info("Configuration saved successfully.");
            Logger.DEV_LOGGER.debug("Configuration saved with filtered attributes: {}", attributeNames);
        }
        catch (IOException e) {
            Logger.DEV_LOGGER.error("Error while saving configuration: {}", (Object)e.getMessage(), (Object)e);
            Logger.USER_LOGGER.error("Failed to save configuration.");
        }
    }

    public static Map<String, Object> filterConfigForAttributes(List<String> attributeNames, boolean save) {
        HashMap<String, Object> filteredConfig = new HashMap<String, Object>();
        try {
            Field[] fields;
            for (Field field : fields = Config.class.getDeclaredFields()) {
                field.setAccessible(true);
                if (!attributeNames.contains(field.getName())) continue;
                if (save) {
                    filteredConfig.put(field.getName(), field.get(null));
                    continue;
                }
                Object value = filteredConfig.get(field.getName());
                if (value == null) continue;
                field.set(null, value);
            }
            Logger.DEV_LOGGER.debug("Filtered configuration: {}", filteredConfig);
        }
        catch (Exception e) {
            Logger.DEV_LOGGER.error("Error while filtering configuration: {}", (Object)e.getMessage(), (Object)e);
        }
        return filteredConfig;
    }

    public static void createConfigFolder() {
        File folder = new File(CONFIG_FOLDER);
        if (!folder.exists() && folder.mkdirs()) {
            Logger.USER_LOGGER.info("Configuration folder created: {}", (Object)CONFIG_FOLDER);
            Logger.DEV_LOGGER.debug("Configuration folder successfully created.");
        } else {
            Logger.DEV_LOGGER.debug("Configuration folder already exists or failed to create: {}", (Object)CONFIG_FOLDER);
        }
    }
}

