/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

@Environment(value=EnvType.CLIENT)
public class ClientModListProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void initialize() {
        Logger.USER_LOGGER.info("Initializing mod list creation and hash generation for the client...");
        Logger.DEV_LOGGER.debug("[ClientModListProvider] Starting mod list creation process.");
        ClientModListProvider.createModList();
    }

    private static void createModList() {
        try {
            Logger.DEV_LOGGER.debug("[ClientModListProvider] Ensuring configuration folder exists...");
            Config.createConfigFolder();
            Logger.DEV_LOGGER.debug("[ClientModListProvider] Configuration folder exists or has been created.");
        }
        catch (Exception e) {
            Logger.USER_LOGGER.error("An error occurred while creating the configuration folder.");
            Logger.DEV_LOGGER.error("Error creating configuration folder at {}: {}", new Object[]{Config.MODLIST_FILE.getAbsolutePath(), e.getMessage(), e});
            return;
        }
        ArrayList<ModInfo> modList = new ArrayList<ModInfo>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModInfo modInfo = new ModInfo(mod.getMetadata().getId(), mod.getMetadata().getName(), mod.getMetadata().getVersion().getFriendlyString());
            modList.add(modInfo);
        }
        if (modList.isEmpty()) {
            Logger.USER_LOGGER.warn("No mods were found. The mod list will be empty.");
            Logger.DEV_LOGGER.warn("[ClientModListProvider] No mods detected. Generating an empty mod list.");
        } else {
            Logger.USER_LOGGER.info("Found {} mods installed.", (Object)modList.size());
            Logger.DEV_LOGGER.debug("[ClientModListProvider] Collected mod information for {} mods.", (Object)modList.size());
        }
        try (FileWriter writer = new FileWriter(Config.MODLIST_FILE);){
            Logger.DEV_LOGGER.debug("[ClientModListProvider] Writing mod list to file: {}", (Object)Config.MODLIST_FILE.getAbsolutePath());
            GSON.toJson(modList, (Appendable)writer);
            Logger.USER_LOGGER.info("The mod list has been successfully created and saved.");
            Logger.DEV_LOGGER.debug("[ClientModListProvider] Mod list written to file successfully: {}", (Object)Config.MODLIST_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            Logger.USER_LOGGER.error("Failed to write the mod list to the file.");
            Logger.DEV_LOGGER.error("Error writing mod list to file {}: {}", new Object[]{Config.MODLIST_FILE.getAbsolutePath(), e.getMessage(), e});
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ModInfo {
        private final String id;
        private final String name;
        private final String version;

        public ModInfo(String id, String name, String version) {
            this.id = id;
            this.name = name;
            this.version = version;
        }
    }
}

