/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.s2c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PaintingSyncPayload(Map<class_2960, Optional<Painting>> paintings, boolean clear) implements ImmersivePayload
{
    public static final class_8710.class_9154<PaintingSyncPayload> TYPE = new class_8710.class_9154(Main.locate("painting_list"));
    public static final class_9139<class_2540, PaintingSyncPayload> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_2960.field_48267, (class_9139)class_9135.method_56382(Painting.STREAM_CODEC)), PaintingSyncPayload::paintings, (class_9139)class_9135.field_48547, PaintingSyncPayload::clear, PaintingSyncPayload::new);

    public PaintingSyncPayload(class_2960 identifier, Painting painting) {
        this(Map.of(identifier, Optional.ofNullable(painting)), false);
    }

    public static List<PaintingSyncPayload> splitPaintings(Map<class_2960, Optional<Painting>> paintings, boolean clearFirst) {
        int currentSize;
        ArrayList<PaintingSyncPayload> paintingsList = new ArrayList<PaintingSyncPayload>();
        int interval = Configs.COMMON.packetSplitInterval;
        Map<class_2960, Optional<Painting>> optionalPaintings = paintings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (paintings.size() < interval) {
            Main.LOGGER.debug("Found {} paintings, < {}", (Object)paintings.size(), (Object)interval);
            paintingsList.add(new PaintingSyncPayload(optionalPaintings, clearFirst));
            return paintingsList;
        }
        Main.LOGGER.debug("Found {} paintings, >= {}, splitting into {} groups", (Object)paintings.size(), (Object)interval, (Object)(paintings.size() / interval + Math.min(paintings.size() % interval, 1)));
        int totalSize = paintings.size();
        for (int processed = 0; processed < totalSize; processed += currentSize) {
            currentSize = Math.min(totalSize - processed, interval);
            Map<class_2960, Optional<Painting>> p = optionalPaintings.entrySet().stream().skip(processed).limit(currentSize).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            paintingsList.add(new PaintingSyncPayload(p, processed == 0 && clearFirst));
        }
        return paintingsList;
    }

    @Override
    public void handle(class_1657 player, ImmersivePayload.Runner runner) {
        Map<class_2960, Optional<Painting>> paintings = this.paintings();
        boolean cleared = this.clear();
        runner.run(() -> {
            if (cleared) {
                ClientPaintingManager.getPaintings().clear();
            }
            paintings.forEach((id, painting) -> {
                if (painting.isEmpty()) {
                    ClientPaintingManager.deregisterPainting(id);
                } else {
                    ClientPaintingManager.registerPainting(id, (Painting)painting.get());
                }
            });
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof ImmersivePaintingScreen) {
                ImmersivePaintingScreen screen = (ImmersivePaintingScreen)patt0$temp;
                screen.refreshPage();
            }
        });
    }

    public class_8710.class_9154<PaintingSyncPayload> method_56479() {
        return TYPE;
    }
}

