/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.entity;

import java.util.Optional;
import java.util.function.Predicate;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.compat.XercaPaintCompat;
import net.conczin.immersive_paintings.config.CommonConfig;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.s2c.OpenGuiPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.registration.Entities;
import net.conczin.immersive_paintings.registration.Items;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class ImmersivePaintingEntity
extends class_1530 {
    protected static final Predicate<class_1297> PREDICATE = entity -> entity instanceof ImmersivePaintingEntity;
    private static final class_2940<class_2960> MOTIVE = class_2945.method_12791(ImmersivePaintingEntity.class, Entities.TRACKED_IDENTIFIER);
    private static final class_2940<class_2960> FRAME = class_2945.method_12791(ImmersivePaintingEntity.class, Entities.TRACKED_IDENTIFIER);
    private static final class_2940<class_2960> MATERIAL = class_2945.method_12791(ImmersivePaintingEntity.class, Entities.TRACKED_IDENTIFIER);
    private static final class_2940<Integer> WIDTH = class_2945.method_12791(ImmersivePaintingEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HEIGHT = class_2945.method_12791(ImmersivePaintingEntity.class, (class_2941)class_2943.field_13327);
    private int rotation;

    public ImmersivePaintingEntity(class_1299<? extends class_1530> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_6892(class_2350 direction) {
        this.setDirection(direction, this.rotation);
    }

    public void setDirection(class_2350 direction, int rotation) {
        if (direction == null) {
            return;
        }
        this.field_7099 = direction;
        this.rotation = rotation;
        if (direction.method_10166().method_10179()) {
            this.method_60608(direction.method_10161() * 90, 0.0f);
        } else {
            this.method_60608(rotation, direction == class_2350.field_11036 ? 90.0f : -90.0f);
        }
        this.method_6895();
    }

    public void setPos(class_2338 pos) {
        this.field_51589 = pos;
    }

    protected class_238 method_59943(class_2338 pos, class_2350 side) {
        class_2350 counter;
        class_2350 facing;
        class_243 front = class_243.method_24954((class_2382)side.method_10163());
        class_243 up = side.method_10166().method_10178() ? new class_243(0.0, 0.0, 1.0) : new class_243(0.0, 1.0, 0.0);
        class_243 cross = up.method_1036(front);
        if (this.rotation != 0) {
            float radians = (float)((double)this.rotation * Math.PI / 180.0);
            up = up.method_1024(radians);
            cross = cross.method_1024(radians);
        }
        double dx = this.offsetForPaintingSize(this.getPaintingWidth());
        double dy = this.offsetForPaintingSize(this.getPaintingHeight());
        if (side.method_10166().method_10178()) {
            facing = class_2350.method_10150((double)this.rotation);
            if (side.equals((Object)class_2350.field_11036)) {
                facing = facing.method_10153();
                counter = facing.method_10170();
            } else {
                counter = facing.method_10160();
            }
        } else {
            facing = class_2350.field_11036;
            counter = side.method_10160();
        }
        class_243 vec3d = class_243.method_24953((class_2382)pos).method_43206(side, -0.46875).method_43206(counter, dx).method_43206(facing, dy);
        class_243 shift = up.method_1021((double)this.getPaintingHeight()).method_1019(cross.method_1021((double)this.getPaintingWidth())).method_1019(front.method_1021(0.0625));
        return class_238.method_30048((class_243)vec3d, (double)shift.method_10216(), (double)shift.method_10214(), (double)shift.method_10215());
    }

    private double offsetForPaintingSize(int size) {
        return size % 2 == 0 ? 0.5 : 0.0;
    }

    public boolean method_6888() {
        if (Configs.COMMON.testIfSpaceEmpty && !this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2338 blockPos = this.field_51589.method_10093(this.field_7099.method_10153());
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_51367() && !class_2312.method_9999((class_2680)blockState)) {
            return false;
        }
        return this.method_37908().method_8333((class_1297)this, this.method_5829(), PREDICATE).stream().noneMatch(v -> ((ImmersivePaintingEntity)v).field_7099 == this.field_7099);
    }

    public boolean method_30948() {
        return Configs.COMMON.paintingsHaveCollision;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (serverPlayer.field_13974.method_14257() != class_1934.field_9216) {
                if (!XercaPaintCompat.interactWithPainting(this, player, hand)) {
                    CommonConfig config = Configs.COMMON;
                    NetworkHandler.sendToClient(serverPlayer, new OpenGuiPayload(OpenGuiPayload.GuiType.EDITOR, this.method_5628(), config.minPaintingResolution, config.maxPaintingResolution, config.showOtherPlayersPaintings, config.uploadPermissionLevel));
                }
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getItem());
    }

    public void method_6889(@Nullable class_1297 entity) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1657 playerEntity;
            this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
            if (entity instanceof class_1657 && (playerEntity = (class_1657)entity).method_56992()) {
                return;
            }
            this.method_5706((class_1935)this.getItem());
        }
    }

    public void method_5808(double x, double y, double z, float yRot, float xRot) {
        this.method_5814(x, y, z);
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int steps) {
        this.method_5814(x, y, z);
    }

    public class_243 method_43390() {
        return class_243.method_24954((class_2382)this.field_51589);
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    public void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(MOTIVE, (Object)Main.locate("none"));
        builder.method_56912(FRAME, (Object)Main.locate("none"));
        builder.method_56912(MATERIAL, (Object)Main.locate("none"));
        builder.method_56912(WIDTH, (Object)1);
        builder.method_56912(HEIGHT, (Object)1);
    }

    public void method_5674(class_2940<?> data) {
        if (MOTIVE.equals(data)) {
            Optional<Painting> painting = this.method_37908().field_9236 ? ClientPaintingManager.getPainting(this.getMotive()) : ServerPaintingManager.getPainting(this.method_5682(), this.getMotive());
            painting.ifPresent(p -> {
                this.method_5841().method_12778(WIDTH, (Object)Math.max(p.width(), 1));
                this.method_5841().method_12778(HEIGHT, (Object)Math.max(p.height(), 1));
                this.method_6895();
            });
        }
        super.method_5674(data);
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, this.rotation << 4 | (byte)this.field_7099.method_10146(), this.method_59940());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        int data = packet.method_11166();
        this.setDirection(class_2350.method_10143((int)(data & 0xF)), data >> 4);
    }

    public void method_5652(class_2487 nbt) {
        class_2945 tracker = this.method_5841();
        nbt.method_10582("Motive", ((class_2960)tracker.method_12789(MOTIVE)).toString());
        nbt.method_10582("Frame", ((class_2960)tracker.method_12789(FRAME)).toString());
        nbt.method_10582("Material", ((class_2960)tracker.method_12789(MATERIAL)).toString());
        nbt.method_10569("Facing", this.field_7099.method_10146());
        nbt.method_10569("Rotation", this.rotation);
        super.method_5652(nbt);
    }

    public void method_5749(class_2487 nbt) {
        this.setFrame(class_2960.method_60654((String)nbt.method_10558("Frame")));
        this.setMaterial(class_2960.method_60654((String)nbt.method_10558("Material")));
        this.field_7099 = class_2350.method_10143((int)nbt.method_10550("Facing"));
        this.rotation = nbt.method_10550("Rotation");
        super.method_5749(nbt);
        this.setMotive(class_2960.method_60654((String)nbt.method_10558("Motive")));
    }

    public class_1792 getItem() {
        return Items.PAINTING;
    }

    public boolean isGraffiti() {
        return false;
    }

    public boolean isGlowing() {
        return false;
    }

    public int getPaintingWidth() {
        return (Integer)this.method_5841().method_12789(WIDTH);
    }

    public int getPaintingHeight() {
        return (Integer)this.method_5841().method_12789(HEIGHT);
    }

    public class_2960 getMotive() {
        return (class_2960)this.method_5841().method_12789(MOTIVE);
    }

    public void setMotive(class_2960 motive) {
        this.method_5841().method_12778(MOTIVE, (Object)motive);
    }

    public class_2960 getFrame() {
        return (class_2960)this.method_5841().method_12789(FRAME);
    }

    public void setFrame(class_2960 frame) {
        this.method_5841().method_12778(FRAME, (Object)frame);
    }

    public class_2960 getMaterial() {
        return (class_2960)this.method_5841().method_12789(MATERIAL);
    }

    public void setMaterial(class_2960 material) {
        this.method_5841().method_12778(MATERIAL, (Object)material);
    }
}

