/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.sittingplus.networking;

import dev.kosmx.playerAnim.api.IPlayable;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_742;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class SittingPlusNetworking {
    private static final class_2960 START_SIT_ID = class_2960.method_60655((String)"sittingplus", (String)"start_sit");
    private static final class_2960 STOP_SIT_ID = class_2960.method_60655((String)"sittingplus", (String)"stop_sit");

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(StartSitPayload.ID, (payload, context) -> context.player().method_5682().execute(() -> {
            for (class_3222 sp : context.player().method_5682().method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)sp, (class_8710)payload);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(StopSitPayload.ID, (payload, context) -> context.player().method_5682().execute(() -> {
            for (class_3222 sp : context.player().method_5682().method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)sp, (class_8710)payload);
            }
        }));
    }

    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(StartSitPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1687 == null) {
                return;
            }
            for (class_1657 p : context.client().field_1687.method_18456()) {
                if (!p.method_5667().equals(payload.playerUuid()) || !(p instanceof class_742)) continue;
                class_742 ace = (class_742)p;
                AnimationStack stack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)ace);
                IPlayable playable = PlayerAnimationRegistry.getAnimation((class_2960)payload.animId());
                if (stack == null || !(playable instanceof KeyframeAnimation)) continue;
                KeyframeAnimation anim = (KeyframeAnimation)playable;
                stack.addAnimLayer(0, (IAnimation)new KeyframeAnimationPlayer(anim));
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(StopSitPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1687 == null) {
                return;
            }
            for (class_1657 p : context.client().field_1687.method_18456()) {
                class_742 ace;
                AnimationStack stack;
                if (!p.method_5667().equals(payload.playerUuid()) || !(p instanceof class_742) || (stack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)(ace = (class_742)p))) == null) continue;
                stack.removeLayer(0);
            }
        }));
    }

    public static void sendStartSit(UUID uuid, class_2960 anim) {
        ClientPlayNetworking.send((class_8710)new StartSitPayload(uuid, anim));
    }

    public static void sendStopSit(UUID uuid) {
        ClientPlayNetworking.send((class_8710)new StopSitPayload(uuid));
    }

    public record StartSitPayload(UUID playerUuid, class_2960 animId) implements class_8710
    {
        public static final class_8710.class_9154<StartSitPayload> ID = new class_8710.class_9154(START_SIT_ID);
        public static final class_9139<class_2540, StartSitPayload> CODEC = class_9139.method_56438((payload, buf) -> {
            buf.method_10797(payload.playerUuid());
            buf.method_10812(payload.animId());
        }, buf -> new StartSitPayload(buf.method_10790(), buf.method_10810()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        static {
            PayloadTypeRegistry.playC2S().register(ID, CODEC);
            PayloadTypeRegistry.playS2C().register(ID, CODEC);
        }
    }

    public record StopSitPayload(UUID playerUuid) implements class_8710
    {
        public static final class_8710.class_9154<StopSitPayload> ID = new class_8710.class_9154(STOP_SIT_ID);
        public static final class_9139<class_2540, StopSitPayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_10797(payload.playerUuid()), buf -> new StopSitPayload(buf.method_10790()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        static {
            PayloadTypeRegistry.playC2S().register(ID, CODEC);
            PayloadTypeRegistry.playS2C().register(ID, CODEC);
        }
    }
}

