/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.component.IExtendedText;
import com.anthonyhilyard.iceberg.component.TitleBreakComponent;
import com.anthonyhilyard.iceberg.events.client.RegisterTooltipComponentFactoryEvent;
import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.mixin.GuiGraphicsInvoker;
import com.anthonyhilyard.iceberg.util.ITooltipAccess;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_768;
import net.minecraft.class_8000;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Tooltips {
    public static final TooltipColors DEFAULT_COLORS = new TooltipColors(-267386864, -267386864, 0x505000FF, 1344798847);
    private static final class_5481 SPACE = class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360);
    private static boolean tooltipWidthWarningShown = false;
    public static TooltipColors currentColors = DEFAULT_COLORS;
    public static final TooltipRenderContext EMPTY_CONTEXT = new TooltipRenderContext(0, 0, false, 0);
    public static final TooltipRenderContext CALCULATE_RECT_CONTEXT = new TooltipRenderContext(0, 0, false, 0);
    private static TooltipRenderContext currentRenderContext = EMPTY_CONTEXT;
    private static class_768 currentRect = new class_768(0, 0, 0, 0);
    private static boolean tooltipsOnscreen = false;
    private static final class_768 emptyRect = new class_768(0, 0, 0, 0);

    public static TooltipRenderContext getCurrentRenderContext() {
        return currentRenderContext;
    }

    public static void setCurrentRect(int x, int y, int width, int height) {
        currentRect.method_35778(x);
        currentRect.method_35781(y);
        currentRect.method_35782(width);
        currentRect.method_35783(height);
    }

    public static class_768 getCurrentRect() {
        return currentRect;
    }

    public static boolean anyTooltipsVisible() {
        return tooltipsOnscreen;
    }

    public static void setAnyTooltipsVisible(boolean visible) {
        tooltipsOnscreen = visible;
    }

    public static int calculateTitleLines(List<class_5684> components) {
        if (components == null || components.isEmpty()) {
            return 0;
        }
        int titleLines = 0;
        boolean foundTitleBreak = false;
        for (class_5684 component : components) {
            if (component instanceof class_5683) {
                ++titleLines;
                continue;
            }
            if (component instanceof TitleBreakComponent) {
                foundTitleBreak = true;
                break;
            }
            titleLines = 0;
        }
        if (!foundTitleBreak) {
            titleLines = 1;
        }
        return titleLines;
    }

    public static int calculateTitleStart(List<class_5684> components) {
        if (components == null || components.isEmpty()) {
            return 0;
        }
        int firstTextIndex = -1;
        int currentTextRunStart = -1;
        for (int i = 0; i < components.size(); ++i) {
            class_5684 component = components.get(i);
            if (component instanceof TitleBreakComponent) {
                return currentTextRunStart == -1 ? 0 : currentTextRunStart;
            }
            if (component instanceof class_5683) {
                if (currentTextRunStart == -1) {
                    currentTextRunStart = i;
                }
                if (firstTextIndex != -1) continue;
                firstTextIndex = i;
                continue;
            }
            currentTextRunStart = -1;
        }
        return firstTextIndex == -1 ? 0 : firstTextIndex;
    }

    public static int getTitleOffset(int tooltipWidth, int textWidth, int leftPadding, int rightPadding, IExtendedText.TextAlignment textAlignment) {
        int offset = leftPadding;
        switch (textAlignment) {
            case CENTER: {
                offset += (tooltipWidth - textWidth - leftPadding - rightPadding) / 2;
                break;
            }
            case RIGHT: {
                offset += tooltipWidth - textWidth - rightPadding;
                break;
            }
        }
        return Math.max(leftPadding, offset);
    }

    public static int getTitleWidth(class_5683 title, class_327 font) {
        int textWidth = font.method_30880(title.field_27997);
        if (title instanceof IExtendedText) {
            IExtendedText extendedTitle = (IExtendedText)title;
            int leftPadding = extendedTitle.getLeftPadding();
            int rightPadding = extendedTitle.getRightPadding();
            int tooltipWidth = Tooltips.getCurrentRect().method_3319();
            textWidth = tooltipWidth == 0 ? (textWidth += leftPadding + rightPadding) : (textWidth += Tooltips.getTitleOffset(tooltipWidth, textWidth, leftPadding, rightPadding, extendedTitle.getAlignment()) + rightPadding);
        }
        return textWidth;
    }

    @Deprecated(forRemoval=true, since="1.3.0")
    public static void renderItemTooltip(@NotNull class_1799 stack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, class_332 graphics, class_8000 positioner, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        Tooltips.renderItemTooltip(stack, info.getFont(), info.getComponents(), rect, graphics, positioner, comparison, index);
    }

    @Deprecated(forRemoval=true, since="1.3.0")
    public static void renderItemTooltip(@NotNull class_1799 stack, TooltipInfo info, class_768 rect, class_332 graphics, class_8000 positioner, boolean comparison, boolean constrain, int index) {
        Tooltips.renderItemTooltip(stack, info.getFont(), info.getComponents(), rect, graphics, positioner, comparison, index);
    }

    public static void renderItemTooltip(@NotNull class_1799 stack, class_327 font, List<class_5684> components, class_768 rect, class_332 graphics, class_8000 positioner, boolean comparison, int index) {
        currentRenderContext = new TooltipRenderContext(rect.method_3319(), rect.method_3320(), comparison, index);
        if (graphics instanceof GuiGraphicsInvoker) {
            GuiGraphicsInvoker graphicsInvoker = (GuiGraphicsInvoker)graphics;
            if (graphics instanceof ITooltipAccess) {
                ITooltipAccess tooltipAccess = (ITooltipAccess)graphics;
                tooltipAccess.setIcebergTooltipStack(stack);
                graphicsInvoker.invokeRenderTooltipInternal(font, components, rect.method_3321() + 2, rect.method_3322(), new TooltipRectPositioner(rect));
                tooltipAccess.setIcebergTooltipStack(class_1799.field_8037);
            }
        }
        currentRenderContext = EMPTY_CONTEXT;
    }

    private static class_5684 getClientComponent(class_5632 componentData) {
        class_5684 result = null;
        result = ((RegisterTooltipComponentFactoryEvent)RegisterTooltipComponentFactoryEvent.EVENT.invoker()).getComponent(componentData);
        if (result == null) {
            try {
                result = class_5684.method_32663((class_5632)componentData);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = (class_5684)componentData;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown TooltipComponent");
        }
        return result;
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 forcedFont, class_327 fallbackFont, int maxWidth) {
        return Tooltips.gatherTooltipComponents(stack, textElements, itemComponent, mouseX, screenWidth, screenHeight, forcedFont, fallbackFont, maxWidth, 0);
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 forcedFont, class_327 fallbackFont, int maxWidth, int index) {
        class_5684 clientComponent;
        Object var17_16;
        class_327 font = forcedFont == null ? fallbackFont : forcedFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        RenderTooltipEvents.GatherResult eventResult = RenderTooltipEvents.GATHER.invoker().onGather(stack, screenWidth, screenHeight, elements, maxWidth, index);
        if (eventResult.result() != class_1269.field_5811) {
            return List.of();
        }
        int tooltipTextWidth = eventResult.tooltipElements().stream().mapToInt(either -> (Integer)either.map(component -> {
            try {
                return font.method_27525(component);
            }
            catch (Exception e) {
                if (!tooltipWidthWarningShown) {
                    Iceberg.LOGGER.error("Error rendering tooltip component: \n" + ExceptionUtils.getStackTrace((Throwable)e));
                    tooltipWidthWarningShown = true;
                }
                return 0;
            }
        }, component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (eventResult.maxWidth() > 0 && tooltipTextWidth > eventResult.maxWidth()) {
            tooltipTextWidth = eventResult.maxWidth();
            needsWrap = true;
        }
        if (eventResult.tooltipElements().size() > 0 && (var17_16 = eventResult.tooltipElements().get(0).right().orElse(null)) instanceof class_5684 && (clientComponent = (class_5684)var17_16).method_32664(font) < 0) {
            tooltipTextWidth += clientComponent.method_32664(font);
        }
        int tooltipTextWidthFinal = tooltipTextWidth;
        if (needsWrap) {
            return eventResult.tooltipElements().stream().flatMap(either -> (Stream)either.map(text -> Tooltips.splitLine(text, font, tooltipTextWidthFinal), component -> Stream.of(Tooltips.getClientComponent(component)))).toList();
        }
        return eventResult.tooltipElements().stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), component -> Tooltips.getClientComponent(component))).toList();
    }

    private static Stream<class_5684> splitLine(class_5348 text, class_327 font, int maxWidth) {
        class_2561 component;
        if (text instanceof class_2561 && (component = (class_2561)text).getString().isEmpty()) {
            return Stream.of(component.method_30937()).map(class_5684::method_32662);
        }
        return font.method_1728(text, maxWidth).stream().map(class_5684::method_32662);
    }

    @Deprecated(forRemoval=true, since="1.3.0")
    public static class_768 calculateRect(class_1799 stack, class_332 graphics, class_8000 positioner, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font, int minWidth, boolean centeredTitle) {
        return Tooltips.calculateRect(stack, graphics, positioner, components, mouseX, mouseY, font);
    }

    public static class_768 calculateRect(class_1799 stack, class_332 graphics, class_8000 positioner, List<class_5684> components, int mouseX, int mouseY, class_327 font) {
        if (components == null || components.isEmpty() || stack == null) {
            return emptyRect;
        }
        TooltipRenderContext prevContext = currentRenderContext;
        currentRenderContext = CALCULATE_RECT_CONTEXT;
        if (graphics instanceof GuiGraphicsInvoker) {
            GuiGraphicsInvoker graphicsInvoker = (GuiGraphicsInvoker)graphics;
            if (graphics instanceof ITooltipAccess) {
                ITooltipAccess tooltipAccess = (ITooltipAccess)graphics;
                class_1799 prevStack = tooltipAccess.getIcebergTooltipStack();
                tooltipAccess.setIcebergTooltipStack(stack);
                graphicsInvoker.invokeRenderTooltipInternal(font, components, mouseX, mouseY, positioner);
                tooltipAccess.setIcebergTooltipStack(prevStack);
            }
        }
        currentRenderContext = prevContext;
        return currentRect;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public static List<class_5684> centerTitle(List<class_5684> components, class_327 font, int width) {
        return Tooltips.centerTitle(components, font, width, Tooltips.calculateTitleLines(components));
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public static List<class_5684> centerTitle(List<class_5684> components, class_327 font, int width, int titleLines) {
        ArrayList<class_5684> result = new ArrayList<class_5684>(components);
        if (components.isEmpty() || titleLines <= 0 || titleLines >= components.size()) {
            return result;
        }
        int titleStart = Tooltips.calculateTitleStart(components);
        if (titleStart >= components.size()) {
            return result;
        }
        for (int i = 0; i < titleLines; ++i) {
            List<class_5348> recomposedLines;
            class_5684 titleComponent = components.get(titleStart + i);
            if (titleComponent == null || (recomposedLines = StringRecomposer.recompose(List.of(titleComponent))).isEmpty()) continue;
            class_5481 title = class_2477.method_10517().method_30934(recomposedLines.get(0));
            while (class_5684.method_32662((class_5481)title).method_32664(font) < width && (title = class_5481.method_30755(List.of(SPACE, title, SPACE))) != null) {
            }
            result.set(titleStart + i, class_5684.method_32662((class_5481)title));
        }
        return result;
    }

    public record TooltipRenderContext(int maxWidth, int maxHeight, boolean comparison, int index) {
    }

    @Deprecated(forRemoval=true, since="1.3.0")
    public static class TooltipInfo {
        private int tooltipWidth;
        private int titleLines;
        private int titleStart;
        private class_327 font;
        private List<class_5684> components;

        public TooltipInfo(List<class_5684> components, class_327 font) {
            this(components, font, Tooltips.calculateTitleLines(components));
        }

        public TooltipInfo(List<class_5684> components, class_327 font, int titleLines) {
            this(components, font, titleLines, Tooltips.calculateTitleStart(components));
        }

        public TooltipInfo(List<class_5684> components, class_327 font, int titleLines, int titleStart) {
            this.components = components;
            this.font = font;
            this.titleLines = titleLines;
            this.titleStart = titleStart;
            this.tooltipWidth = this.getMaxLineWidth();
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTooltipHeight() {
            return this.components.size() > this.titleLines ? this.components.size() * 10 + 2 : 8;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public int getTitleStart() {
            return this.titleStart;
        }

        public class_327 getFont() {
            return this.font;
        }

        public List<class_5684> getComponents() {
            return this.components;
        }

        public void setFont(class_327 font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            return this.getMaxLineWidth(0);
        }

        public int getMaxLineWidth(int minWidth) {
            int textWidth = minWidth;
            for (class_5684 component : this.components) {
                int componentWidth = component.method_32664(this.font);
                if (componentWidth <= textWidth) continue;
                textWidth = componentWidth;
            }
            return textWidth;
        }
    }

    private static class TooltipRectPositioner
    implements class_8000 {
        private final class_768 tooltipRect;

        public TooltipRectPositioner(class_768 tooltipRect) {
            this.tooltipRect = tooltipRect;
        }

        public Vector2ic method_47944(int screenWidth, int screenHeight, int mouseX, int mouseY, int tooltipWidth, int tooltipHeight) {
            return new Vector2i(this.tooltipRect.method_3321() + 2, this.tooltipRect.method_3322());
        }
    }

    public record TooltipColors(int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd) {
    }
}

