/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.ITooltipAccess;
import com.anthonyhilyard.iceberg.util.Tooltips;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_332.class}, priority=1001)
public class GuiGraphicsMixin
implements ITooltipAccess {
    @Unique
    private static Field tooltipStackField = null;
    @Unique
    private int storedTooltipWidth;
    @Unique
    private int storedTooltipHeight;
    @Unique
    private Vector2ic storedPostPos;

    @Override
    public void setIcebergTooltipStack(class_1799 stack) {
        if (tooltipStackField == null) {
            try {
                switch (Services.getPlatformHelper().getPlatformName()) {
                    case "Fabric": {
                        tooltipStackField = class_332.class.getDeclaredField("icebergTooltipStack");
                    }
                }
                tooltipStackField = class_332.class.getDeclaredField("tooltipStack");
                tooltipStackField.setAccessible(true);
            }
            catch (Exception e) {
                Iceberg.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        try {
            tooltipStackField.set(this, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public class_1799 getIcebergTooltipStack() {
        if (tooltipStackField == null) {
            try {
                switch (Services.getPlatformHelper().getPlatformName()) {
                    case "Fabric": {
                        tooltipStackField = class_332.class.getDeclaredField("icebergTooltipStack");
                    }
                }
                tooltipStackField = class_332.class.getDeclaredField("tooltipStack");
                tooltipStackField.setAccessible(true);
            }
            catch (Exception e) {
                Iceberg.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        try {
            return (class_1799)tooltipStackField.get(this);
        }
        catch (Exception exception) {
            return class_1799.field_8037;
        }
    }

    @ModifyArg(method={"renderTooltipInternal"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;positionTooltip(IIIIII)Lorg/joml/Vector2ic;"), index=4)
    private int storeTooltipWidth(int width) {
        Tooltips.TooltipRenderContext context = Tooltips.getCurrentRenderContext();
        if (context.maxWidth() < width && context.maxWidth() > 0) {
            width = context.maxWidth();
        }
        this.storedTooltipWidth = width;
        return width;
    }

    @ModifyArg(method={"renderTooltipInternal"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;positionTooltip(IIIIII)Lorg/joml/Vector2ic;"), index=5)
    private int storeTooltipHeight(int height) {
        Tooltips.TooltipRenderContext context = Tooltips.getCurrentRenderContext();
        if (context.maxHeight() < height && context.maxHeight() > 0) {
            height = context.maxHeight();
        }
        this.storedTooltipHeight = height;
        return height;
    }

    @ModifyVariable(method={"renderTooltipInternal"}, at=@At(value="STORE", ordinal=0))
    private Vector2ic storeTooltipPosition(Vector2ic pos) {
        this.storedPostPos = pos;
        return pos;
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;positionTooltip(IIIIII)Lorg/joml/Vector2ic;")}, cancellable=true)
    private void storeCalculatedRect(class_327 font, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo info) {
        Tooltips.setCurrentRect(this.storedPostPos.x(), this.storedPostPos.y(), this.storedTooltipWidth, this.storedTooltipHeight);
        if (Tooltips.getCurrentRenderContext() == Tooltips.CALCULATE_RECT_CONTEXT) {
            info.cancel();
        }
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")})
    private void preRenderTooltipInternal(class_327 font, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo info) {
        if (Tooltips.getCurrentRenderContext() != Tooltips.CALCULATE_RECT_CONTEXT) {
            Tooltips.setAnyTooltipsVisible(true);
        }
        if (Services.getPlatformHelper().isModLoaded("emi") && Tooltips.getCurrentRenderContext() == Tooltips.EMPTY_CONTEXT) {
            try {
                class_1799 tooltipStack = (class_1799)Class.forName("com.anthonyhilyard.iceberg.compat.EMIHandler").getMethod("getTooltipStack", List.class).invoke(null, components);
                if (!tooltipStack.method_7960()) {
                    this.setIcebergTooltipStack(tooltipStack);
                }
            }
            catch (Exception e) {
                Iceberg.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="TAIL")})
    private void renderTooltipInternalTail(class_327 font, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo info) {
        class_332 self = (class_332)this;
        class_1799 tooltipStack = this.getIcebergTooltipStack();
        if (!components.isEmpty()) {
            Tooltips.TooltipRenderContext context = Tooltips.getCurrentRenderContext();
            RenderTooltipEvents.POSTEXT.invoker().onPost(tooltipStack, self, this.storedPostPos.x(), this.storedPostPos.y(), font, this.storedTooltipWidth, this.storedTooltipHeight, components, context.comparison(), context.index());
        }
        this.setIcebergTooltipStack(class_1799.field_8037);
        Tooltips.setCurrentRect(0, 0, 0, 0);
    }
}

