/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.dimension;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_3300;
import team.creative.ambientsounds.condition.AmbientCondition;
import team.creative.ambientsounds.condition.AmbientSelection;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.ambientsounds.engine.AmbientStackType;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.region.AmbientRegion;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientDimension {
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public transient HashMap<String, AmbientRegion> loadedRegions;
    public transient HashMap<String, AmbientCondition> biomeTypeSelectors = new HashMap();
    public transient String name;
    public boolean mute = false;
    @SerializedName(value="biome-selector")
    public AmbientCondition biomeSelector;
    public Boolean night;
    public Boolean rain;
    public Boolean storm;
    @SerializedName(value="dimension-names")
    public String[] dimensionNames;
    @SerializedName(value="bad-dimension-names")
    public String[] badDimensionNames;
    @SerializedName(value="average-height")
    public Integer averageHeight;
    public AmbientRegion[] regions;
    public AmbientStackType stack = AmbientStackType.overwrite;

    public void load(AmbientEngine engine, Gson gson, class_3300 manager, JsonElement element) throws AmbientEngineLoadException {
        if (this.regions != null) {
            this.loadedRegions = new LinkedHashMap<String, AmbientRegion>();
            for (int i = 0; i < this.regions.length; ++i) {
                AmbientRegion region = this.regions[i];
                region.dimension = this;
                this.loadedRegions.put(region.name, region);
                region.load(engine, gson, manager);
            }
        }
        if (element.isJsonObject()) {
            for (String type : engine.biomeTypes) {
                JsonElement selector = element.getAsJsonObject().get(type + "-selector");
                if (selector == null) continue;
                this.biomeTypeSelectors.put(type, (AmbientCondition)gson.fromJson(selector, AmbientCondition.class));
            }
        }
    }

    public void init(AmbientEngine engine) throws AmbientEngineLoadException {
        if (this.biomeSelector != null) {
            this.biomeSelector.init(engine);
        }
        for (AmbientCondition condition : this.biomeTypeSelectors.values()) {
            condition.init(engine);
        }
        if (this.badDimensionNames != null) {
            for (int i = 0; i < this.badDimensionNames.length; ++i) {
                this.badDimensionNames[i] = ".*" + this.badDimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
        if (this.dimensionNames != null) {
            for (int i = 0; i < this.dimensionNames.length; ++i) {
                this.dimensionNames[i] = ".*" + this.dimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
    }

    public boolean is(class_1937 level) {
        int j;
        String dimensionTypeName = level.method_27983().method_29177().toString();
        if (this.badDimensionNames != null) {
            for (j = 0; j < this.badDimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.badDimensionNames[j])) continue;
                return false;
            }
        }
        if (this.dimensionNames != null) {
            for (j = 0; j < this.dimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.dimensionNames[j])) continue;
                return true;
            }
        }
        return this.dimensionNames == null;
    }

    public void manipulateEnviroment(AmbientEnvironment env) {
        env.muted = this.mute;
        if (this.night != null) {
            env.night = this.night;
        }
        if (this.rain != null) {
            env.raining = this.rain;
        }
        if (this.storm != null) {
            env.thundering = this.storm;
        }
        if (this.biomeSelector != null) {
            AmbientSelection selection = this.biomeSelector.value(env);
            env.biomeVolume = selection != null ? selection : AmbientVolume.SILENT;
        }
        env.biomeTypeVolumes.clear();
        for (Map.Entry<String, AmbientCondition> entry : this.biomeTypeSelectors.entrySet()) {
            AmbientSelection selection = entry.getValue().value(env);
            if (selection != null) {
                env.biomeTypeVolumes.put(entry.getKey(), selection);
                continue;
            }
            env.biomeTypeVolumes.put(entry.getKey(), AmbientVolume.SILENT);
        }
    }

    public String toString() {
        return this.name;
    }
}

