/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.event;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import org.jetbrains.annotations.Nullable;

public class FabricBalmEvents
implements BalmEvents {
    private final Map<Class<?>, Runnable> eventInitializers = new ConcurrentHashMap();
    private final Map<Class<?>, Consumer<?>> eventDispatchers = new ConcurrentHashMap();
    private final ListMultimap<Class<?>, Consumer<?>> eventHandlers = Multimaps.newListMultimap(new ConcurrentHashMap(), CopyOnWriteArrayList::new);
    private final Table<TickType<?>, TickPhase, Consumer<?>> tickEventInitializers = Tables.synchronizedTable((Table)HashBasedTable.create());

    public void registerEvent(Class<?> eventClass, Runnable initializer) {
        this.registerEvent(eventClass, initializer, null);
    }

    public void registerEvent(Class<?> eventClass, Runnable initializer, @Nullable Consumer<?> dispatcher) {
        this.eventInitializers.put(eventClass, initializer);
        if (dispatcher != null) {
            this.eventDispatchers.put(eventClass, dispatcher);
        }
    }

    public <T> void fireEventHandlers(T event) {
        this.eventHandlers.get(event.getClass()).forEach(handler -> this.fireEventHandler((Consumer)handler, event));
    }

    private <T> void fireEventHandler(Consumer<T> handler, Object event) {
        handler.accept(event);
    }

    @Override
    public <T> void onEvent(Class<T> eventClass, Consumer<T> handler, EventPriority priority) {
        Runnable initializer = this.eventInitializers.remove(eventClass);
        if (initializer != null) {
            initializer.run();
        }
        this.eventHandlers.put(eventClass, handler);
    }

    @Override
    public <T> void fireEvent(T event) {
        Consumer<?> handler = this.eventDispatchers.get(event.getClass());
        if (handler != null) {
            handler.accept(event);
        } else {
            this.fireEventHandlers(event);
        }
    }

    @Override
    public <T> void onTickEvent(TickType<T> type, TickPhase phase, T handler) {
        Consumer initializer = (Consumer)this.tickEventInitializers.get(type, (Object)phase);
        if (initializer != null) {
            initializer.accept(handler);
        }
    }

    public <T> void registerTickEvent(TickType<?> type, TickPhase phase, Consumer<T> initializer) {
        this.tickEventInitializers.put(type, (Object)phase, initializer);
    }
}

