/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import com.mojang.datafixers.util.Either;
import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.StepSoundSource;
import eu.ha3.presencefootsteps.sound.player.ImmediateSoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.PFSolver;
import eu.ha3.presencefootsteps.world.Solver;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1480;
import net.minecraft.class_1531;
import net.minecraft.class_1588;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_2338;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3695;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class SoundEngine
implements IdentifiableResourceReloadListener {
    private static final class_2960 ID = PresenceFootsteps.id("sounds");
    private static final Set<class_2960> BLOCKED_PLAYER_SOUNDS = Set.of(class_3417.field_14998.method_14833(), class_3417.field_14810.method_14833(), class_3417.field_14794.method_14833(), class_3417.field_14778.method_14833());
    private Isolator isolator = new Isolator(this);
    private final Solver solver = new PFSolver(this);
    final ImmediateSoundPlayer soundPlayer = new ImmediateSoundPlayer(this);
    private final PFConfig config;
    private boolean hasConfigurations;

    public SoundEngine(PFConfig config) {
        this.config = config;
    }

    public float getVolumeForSource(class_1309 source) {
        float volume = (float)this.config.getGlobalVolume() / 100.0f;
        volume = source instanceof class_1657 ? (PlayerUtil.isClientPlayer((class_1297)source) ? (volume *= this.config.clientPlayerVolume.getPercentage()) : (volume *= this.config.otherPlayerVolume.getPercentage())) : (source instanceof class_1588 ? (volume *= this.config.hostileEntitiesVolume.getPercentage()) : (volume *= this.config.passiveEntitiesVolume.getPercentage()));
        float runningProgress = ((StepSoundSource)source).getStepGenerator(this).map(generator -> Float.valueOf(generator.getMotionTracker().getSpeedScalingRatio(source))).orElse(Float.valueOf(0.0f)).floatValue();
        return volume * (1.0f + (float)this.config.getRunningVolumeIncrease() / 100.0f * runningProgress);
    }

    public Isolator getIsolator() {
        return this.isolator;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public PFConfig getConfig() {
        return this.config;
    }

    public void reload() {
        if (this.config.getEnabled()) {
            this.reloadEverything(class_310.method_1551().method_1478());
        } else {
            this.shutdown();
        }
    }

    public boolean isEnabledFor(class_1297 entity) {
        return this.hasData() && this.isRunning(class_310.method_1551()) && this.config.getEntitySelector().test(entity);
    }

    public boolean hasData() {
        return this.hasConfigurations;
    }

    public boolean isRunning(class_310 client) {
        return !client.method_1493() && this.isActive(client);
    }

    public boolean isActive(class_310 client) {
        return this.hasData() && this.config.getEnabled() && (client.method_1542() || this.config.getEnabledMP());
    }

    private Stream<? extends class_1297> getTargets(class_1297 cameraEntity) {
        List entities = cameraEntity.method_37908().method_8333(null, cameraEntity.method_5829().method_1014(16.0), e -> e instanceof class_1309 && !(e instanceof class_1480) && !(e instanceof class_1307) && !(e instanceof class_1606) && !(e instanceof class_1531) && !(e instanceof class_1690) && !(e instanceof class_1688) && !this.isolator.golems().contains(e.method_5864()) && !e.method_5765() && !((class_1309)e).method_6113() && (!(e instanceof class_1657) || !e.method_7325()) && e.method_5858(cameraEntity) <= 256.0 && this.config.getEntitySelector().test(e));
        Comparator<class_1297> nearest = Comparator.comparingDouble(e -> e.method_5858(cameraEntity));
        if (entities.size() < this.config.getMaxSteppingEntities()) {
            return entities.stream();
        }
        HashSet alreadyVisited = new HashSet();
        return entities.stream().sorted(nearest).filter(e -> e == cameraEntity || e instanceof class_1657 || alreadyVisited.size() < this.config.getMaxSteppingEntities() && alreadyVisited.add(Objects.hash(e.method_5864(), e.method_24515())));
    }

    public void onFrame(class_310 client, class_1297 cameraEntity) {
        if (this.isRunning(client)) {
            this.getTargets(cameraEntity).forEach(e -> {
                try {
                    ((StepSoundSource)e).getStepGenerator(this).ifPresent(generator -> generator.generateFootsteps());
                }
                catch (Throwable t) {
                    class_128 report = class_128.method_560((Throwable)t, (String)"Generating PF sounds for entity");
                    class_129 section = report.method_562("Entity being ticked");
                    if (e == null) {
                        section.method_578("Entity Type", (Object)"null");
                    } else {
                        e.method_5819(section);
                        section.method_578("Entity's Locomotion Type", (Object)this.isolator.locomotions().lookup((class_1297)e));
                        section.method_578("Entity is Golem", (Object)this.isolator.golems().contains(e.method_5864()));
                    }
                    this.config.populateCrashReport(report.method_562("PF Configuration"));
                    throw new class_148(report);
                }
            });
            this.isolator.acoustics().think();
        }
    }

    public boolean onSoundRecieved(class_2767 packet) {
        @Nullable class_6880 event = packet.method_11894();
        @Nullable class_638 world = class_310.method_1551().field_1687;
        if (world == null || event == null || !this.isActive(class_310.method_1551())) {
            return false;
        }
        class_3414 stepAtPos = world.method_8320(class_2338.method_49637((double)packet.method_11890(), (double)(packet.method_11889() - 1.0), (double)packet.method_11893())).method_26231().method_10594();
        class_2960 sound = (class_2960)Either.unwrap((Either)event.method_40229().mapBoth(i -> i.method_29177(), i -> i.method_14833()));
        return BLOCKED_PLAYER_SOUNDS.contains(sound) || packet.method_11888() == class_3419.field_15248 && sound.equals((Object)stepAtPos.method_14833());
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 sync, class_3300 sender, class_3695 serverProfiler, class_3695 clientProfiler, Executor serverExecutor, Executor clientExecutor) {
        return sync.method_18352(null).thenRunAsync(() -> {
            clientProfiler.method_16065();
            clientProfiler.method_15396("Reloading PF Sounds");
            this.reloadEverything(sender);
            clientProfiler.method_15407();
            clientProfiler.method_16066();
        }, clientExecutor);
    }

    public void reloadEverything(class_3300 manager) {
        this.shutdown();
        this.hasConfigurations = this.isolator.load(manager);
    }

    public void shutdown() {
        this.isolator = new Isolator(this);
        this.hasConfigurations = false;
    }
}

