/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.utils.TrinketSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;

public class TrinketSaveUtils {
    private static final String path = String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/InventoryHUD/trinkets.json";

    private static void saveFile(File file, String input) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            InventoryHUD.log("SOMETHING WENT WRONG, CONFIG DIRECTORY CAN NOT BE CREATED");
            return;
        }
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(input);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void save() {
        File file = new File(path);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            InventoryHUD.log("SOMETHING WENT WRONG, CONFIG DIRECTORY CAN NOT BE CREATED");
            return;
        }
        TrinketSaveUtils.rebuildFile(file);
    }

    public static void sync() {
        File file = new File(path);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            InventoryHUD.log("SOMETHING WENT WRONG, CONFIG DIRECTORY CAN NOT BE CREATED");
            return;
        }
        if (file.exists()) {
            TrinketSaveUtils.syncWithFile(file);
        }
        TrinketSaveUtils.rebuildFile(file);
    }

    private static void syncWithFile(File file) {
        try (FileReader reader = new FileReader(file);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            HashMap<String, TrinketSlot> slots = InventoryHUD.getInstance().getInvhudGUI().getTrinkets();
            int[] index = new int[]{0};
            if (json.isJsonObject()) {
                json.getAsJsonObject().asMap().forEach((key, value) -> {
                    if (value.isJsonObject() && slots.containsKey(key)) {
                        JsonObject jsonSlot = value.getAsJsonObject();
                        JsonElement jEnabled = jsonSlot.get("enabled");
                        boolean enabled = jEnabled != null && jEnabled.isJsonPrimitive() && jEnabled.getAsBoolean();
                        JsonElement jX = jsonSlot.get("x");
                        int x = jX == null || !jX.isJsonPrimitive() ? 0 : jX.getAsInt();
                        JsonElement jY = jsonSlot.get("y");
                        int y = jY == null || !jY.isJsonPrimitive() ? index[0] + 20 : jY.getAsInt();
                        JsonElement jHalign = jsonSlot.get("halign");
                        WidgetAligns.HAlign halign = jHalign == null || !jHalign.isJsonPrimitive() ? WidgetAligns.HAlign.LEFT : WidgetAligns.HAlign.valueOf(jHalign.getAsString());
                        JsonElement jValign = jsonSlot.get("valign");
                        WidgetAligns.VAlign valign = jValign == null || !jValign.isJsonPrimitive() ? WidgetAligns.VAlign.TOP : WidgetAligns.VAlign.valueOf(jValign.getAsString());
                        ((TrinketSlot)slots.get((Object)key)).enabled = enabled;
                        ((TrinketSlot)slots.get((Object)key)).x = x;
                        ((TrinketSlot)slots.get((Object)key)).y = y;
                        ((TrinketSlot)slots.get((Object)key)).aligns = new WidgetAligns(halign, valign);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void rebuildFile(File file) {
        JsonObject jSlots = TrinketSaveUtils.getJsonFromSlots();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                if (json.isJsonObject()) {
                    json.getAsJsonObject().asMap().forEach((key, value) -> {
                        if (!jSlots.has(key)) {
                            jSlots.add(key, value);
                        }
                    });
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        TrinketSaveUtils.saveFile(file, jSlots.toString());
    }

    private static JsonObject getJsonFromSlots() {
        JsonObject result = new JsonObject();
        HashMap<String, TrinketSlot> slots = InventoryHUD.getInstance().getInvhudGUI().getTrinkets();
        slots.forEach((key, value) -> {
            JsonObject slot = new JsonObject();
            slot.addProperty("x", (Number)value.x);
            slot.addProperty("y", (Number)value.y);
            slot.addProperty("enabled", Boolean.valueOf(value.enabled));
            slot.addProperty("halign", value.aligns.HorAlign.name());
            slot.addProperty("valign", value.aligns.VertAlign.name());
            result.add(key, (JsonElement)slot);
        });
        return result;
    }
}

