/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.widgets.ButtonWidget;
import dlovin.inventoryhud.config.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.class_124;
import net.minecraft.class_437;

public class InventoryConfigScreen
extends ConfigScreen {
    public InventoryConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 0, inGame);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        String toggle = InventoryHUD.getConfig().getInv() ? String.valueOf(class_124.field_1077) + "ON" : String.valueOf(class_124.field_1079) + "OFF";
        this.addButton(0, toggle, this::ToggleSwitch);
        this.addButton(1, Boolean.toString(InventoryHUD.getConfig().getInvVert()), this::VerticalModeSwitch);
        this.addButton(2, Boolean.toString(InventoryHUD.getConfig().getInvMini()), this::MiniModeSwitch);
        this.addNumericField(3, 0, 100, InventoryHUD.getConfig().getInvAlpha(), this::AlphaChanged, 5);
        this.addButton(4, Boolean.toString(InventoryHUD.getConfig().isInvAnimated()), this::AnimatedSwitch);
        this.addButton(5, Boolean.toString(InventoryHUD.getConfig().isInvHideBG()), this::HideBGSwitch);
        this.addButton(6, Boolean.toString(InventoryHUD.getConfig().isInvWithDebug()), this::WithDebug);
        this.addButton(8, Boolean.toString(InventoryHUD.getConfig().isKeepNotifying()), this::NotifyChanged);
        this.addText(8, Translation.KEEP_NOTIFY.getString(), Translation.KEEP_NOTIFY_TT);
        this.addText(6, Translation.WITH_DEBUG.getString(), Translation.INV_DEBUG_TT);
        this.addText(5, Translation.INV_HIDEBG.getString(), Translation.INV_HIDEBG_TT);
        this.addText(4, Translation.INV_ANIMATED.getString(), Translation.INV_ANIMATED_TT);
        this.addText(3, Translation.INV_ALPHA.getString(), Translation.INV_ALPHA_TT);
        this.addText(2, Translation.INV_MINI.getString(), Translation.INV_MINI_TT);
        this.addText(1, Translation.INV_VERT.getString(), Translation.INV_VERT_TT);
        this.addText(0, Translation.INV_TOGGLE.getString(), Translation.INV_TOGGLE_TT);
    }

    private void WithDebug(ButtonWidget btn) {
        boolean nt = !InventoryHUD.getConfig().isInvWithDebug();
        InventoryHUD.getConfig().setInvWithDebug(nt);
        InventoryHUD.getInstance().getInvhudGUI().withDebug = nt;
        btn.setMessage(Boolean.toString(nt));
    }

    private void NotifyChanged(ButtonWidget btn) {
        boolean nt = !InventoryHUD.getConfig().isKeepNotifying();
        InventoryHUD.getConfig().setKeepNotifying(nt);
        btn.setMessage(Boolean.toString(nt));
    }

    private void AnimatedSwitch(ButtonWidget btn) {
        boolean mm;
        InventoryHUD.getInstance().getInvhudGUI().invAnimated = mm = !InventoryHUD.getConfig().isInvAnimated();
        InventoryHUD.getConfig().setInvAnimated(mm);
        btn.setMessage(Boolean.toString(mm));
    }

    private void HideBGSwitch(ButtonWidget btn) {
        boolean mm;
        InventoryHUD.getInstance().getInvhudGUI().invHideBG = mm = !InventoryHUD.getConfig().isInvHideBG();
        InventoryHUD.getConfig().setInvHideBG(mm);
        btn.setMessage(Boolean.toString(mm));
    }

    private void AlphaChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().invAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig().setInvAlpha(a);
    }

    private void MiniModeSwitch(ButtonWidget btn) {
        boolean mm;
        InventoryHUD.getInstance().getInvhudGUI().invMini = mm = !InventoryHUD.getConfig().getInvMini();
        InventoryHUD.getConfig().setInvMini(mm);
        btn.setMessage(Boolean.toString(mm));
    }

    private void VerticalModeSwitch(ButtonWidget btn) {
        boolean vm;
        InventoryHUD.getInstance().getInvhudGUI().invVert = vm = !InventoryHUD.getConfig().getInvVert();
        InventoryHUD.getConfig().setInvVert(vm);
        btn.setMessage(Boolean.toString(vm));
    }

    private void ToggleSwitch(ButtonWidget btn) {
        boolean bd;
        InventoryHUD.InvHUD = bd = !InventoryHUD.getConfig().getInv();
        InventoryHUD.getConfig().setInv(bd);
        String toggle = bd ? String.valueOf(class_124.field_1077) + "ON" : String.valueOf(class_124.field_1079) + "OFF";
        btn.setMessage(toggle);
    }
}

