/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import dev.architectury.platform.Platform;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1531;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.compat.opac.OpacCompat;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.registry.ParticlesRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class HelperMethods {
    private static final Random random = new Random();

    public static Random random() {
        return random;
    }

    public static class_1297 getTargetedEntity(class_1297 user, double range) {
        class_238 searchBox;
        class_243 userView;
        class_243 rayCastEnd;
        class_243 rayCastOrigin = user.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)user, (class_243)rayCastOrigin, (class_243)(rayCastEnd = rayCastOrigin.method_1019(userView = user.method_5828(1.0f).method_1029().method_1021(range))), (class_238)(searchBox = user.method_5829().method_1009(range, range, range)), target -> !target.method_7325() && target.method_5863() && target instanceof class_1309, (double)(range * range));
        if (hitResult != null) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static boolean isWalking(class_1297 entity) {
        class_1657 player;
        return entity instanceof class_1657 && !(player = (class_1657)entity).method_29504() && (player.method_5681() || player.method_18798().method_37267() > 0.1);
    }

    public static boolean checkFriendlyFire(class_1309 livingEntity, class_1309 attackingEntity) {
        if (livingEntity == null || attackingEntity == null) {
            return false;
        }
        if (!HelperMethods.checkEntityBlacklist(livingEntity, attackingEntity)) {
            return false;
        }
        if (livingEntity == attackingEntity) {
            return false;
        }
        class_268 playerTeam = attackingEntity.method_5781();
        class_268 entityTeam = livingEntity.method_5781();
        if (HelperMethods.isOpacLoaded() && livingEntity instanceof class_1657 && attackingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)attackingEntity;
            return OpacCompat.checkOpacFriendlyFire(livingEntity, playerEntity);
        }
        if (playerTeam != null && entityTeam != null && livingEntity.method_5722((class_1297)attackingEntity)) {
            return false;
        }
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntity;
            if (attackingEntity instanceof class_1657) {
                class_1657 player = (class_1657)attackingEntity;
                if (playerEntity == attackingEntity) {
                    return false;
                }
                return playerEntity.method_7256(player);
            }
        }
        if (livingEntity instanceof class_6025) {
            class_6025 tameable = (class_6025)livingEntity;
            if (tameable.method_35057() != null) {
                class_1309 class_13092;
                if (tameable.method_35057() != attackingEntity && (class_13092 = tameable.method_35057()) instanceof class_1657) {
                    class_1657 ownerPlayer = (class_1657)class_13092;
                    if (attackingEntity instanceof class_1657) {
                        class_1657 playerEntity = (class_1657)attackingEntity;
                        if (HelperMethods.isOpacLoaded()) {
                            return OpacCompat.checkOpacFriendlyFire((class_1309)ownerPlayer, playerEntity);
                        }
                        return playerEntity.method_7256(ownerPlayer);
                    }
                }
                return tameable.method_35057() != attackingEntity;
            }
            return true;
        }
        return true;
    }

    public static boolean isOpacLoaded() {
        return Platform.isModLoaded((String)"openpartiesandclaims");
    }

    public static boolean checkEntityBlacklist(class_1309 target, class_1309 player) {
        if (target == null || player == null) {
            return false;
        }
        return !(target instanceof class_1531) && !(target instanceof class_1646) && !(target instanceof BattleStandardEntity) && !(target instanceof BattleStandardDarkEntity);
    }

    public static void spawnParticle(class_1937 world, class_2394 particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.field_9236) {
            world.method_8406(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.1);
        }
    }

    public static void createServerBubbleTrail(class_3218 serverWorld, class_3222 player) {
        if (player.field_6012 % 10 == 0) {
            double x = player.method_23317() + (serverWorld.field_9229.method_43058() - 0.5) * 0.3;
            double y = player.method_23318() + 0.1;
            double z = player.method_23321() + (serverWorld.field_9229.method_43058() - 0.5) * 0.3;
            serverWorld.method_14199((class_2394)((class_2400)ParticlesRegistry.CUSTOM_BUBBLE.get()), x, y, z, 2, 0.1, 0.05, 0.1, 0.02);
        }
    }

    public static void playHitSounds(class_1309 attacker, class_1309 target) {
        if (!attacker.method_37908().method_8608()) {
            class_3218 world = (class_3218)attacker.method_37908();
            boolean impactsounds_enabled = Config.general.enableWeaponImpactSounds;
            float impactsounds_volume = Config.general.weaponImpactSoundsVolume;
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 20) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 30) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 40) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                }
            }
        }
    }

    public static boolean isUniqueTwohanded(class_1799 stack) {
        return stack.method_7909() instanceof TwoHandedWeapon;
    }

    public static class_238 createBox(class_1297 entity, double radius) {
        return new class_238(entity.method_23317() + radius, entity.method_23318() + (double)((float)radius / 3.0f), entity.method_23321() + radius, entity.method_23317() - radius, entity.method_23318() - (double)((float)radius / 3.0f), entity.method_23321() - radius);
    }

    public static class_243 getPositionLookingAt(class_1657 player, int range) {
        class_239 result = player.method_5745((double)range, 0.0f, false);
        if (result.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_3965 blockResult = (class_3965)result;
        return blockResult.method_17784();
    }

    public static void incrementStatusEffect(class_1309 livingEntity, class_6880<class_1291> statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.method_6092(new class_1293(statusEffect, Math.max(currentDuration, duration), currentAmplifier, false, false, true));
                return;
            }
            livingEntity.method_6092(new class_1293(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier), false, false, true));
        }
        livingEntity.method_6092(new class_1293(statusEffect, duration, amplifier, false, false, true));
    }

    public static SimplySwordsStatusEffectInstance incrementSimplySwordsStatusEffect(class_1309 livingEntity, class_6880<class_1291> statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            if (currentAmplifier >= amplifierMax) {
                SimplySwordsStatusEffectInstance statusReturn = new SimplySwordsStatusEffectInstance(statusEffect, Math.max(currentDuration, duration), currentAmplifier, false, false, true);
                livingEntity.method_6092((class_1293)statusReturn);
                return statusReturn;
            }
            livingEntity.method_6092(new class_1293(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier), false, false, true));
        }
        SimplySwordsStatusEffectInstance statusReturn = new SimplySwordsStatusEffectInstance(statusEffect, duration, 0, false, false, true);
        livingEntity.method_6092((class_1293)statusReturn);
        return statusReturn;
    }

    public static void decrementStatusEffect(class_1309 livingEntity, class_6880<class_1291> statusEffect) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            if (currentAmplifier < 1) {
                livingEntity.method_6016(statusEffect);
                return;
            }
            livingEntity.method_6016(statusEffect);
            livingEntity.method_6092(new class_1293(statusEffect, currentDuration, currentAmplifier - 1, false, false, true));
        }
    }

    public static void createFootfalls(class_1297 entity, class_1799 stack, class_1937 world, class_2394 particle, class_2394 sprintParticle, class_2394 passiveParticle, boolean passiveParticles) {
        int stepMod = 7 - (int)(world.method_8510() % 7L);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (Config.general.enableWeaponFootfalls && player.method_6118(class_1304.field_6173) == stack) {
                if (HelperMethods.isWalking((class_1297)player) && !player.method_5681() && player.method_24828()) {
                    if (stepMod == 6) {
                        if (player.method_5624()) {
                            world.method_8406(sprintParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        } else {
                            world.method_8406(particle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        }
                    } else if (stepMod == 3) {
                        if (player.method_5624()) {
                            world.method_8406(sprintParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        } else {
                            world.method_8406(particle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (passiveParticles && Config.general.enablePassiveParticles) {
                    float randomy = (float)Math.random();
                    if (stepMod == 1) {
                        world.method_8406(passiveParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.4 + (double)randomy, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        world.method_8406(passiveParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216() + 0.1, player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + (double)randomy, player.method_23321() - player.method_40123(stack.method_7909()).method_10215() - 0.1, 0.0, 0.0, 0.0);
                    } else if (stepMod == 4) {
                        world.method_8406(passiveParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.4 + (double)randomy, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        world.method_8406(passiveParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216() - 0.1, player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + (double)randomy, player.method_23321() + player.method_40123(stack.method_7909()).method_10215() + 0.1, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void spawnOrbitParticles(class_3218 world, class_243 center, class_2394 particleType, double radius, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = center.field_1352 + radius * Math.cos(angle);
            double z = center.field_1350 + radius * Math.sin(angle);
            double y = center.field_1351;
            world.method_14199(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnWaistHeightParticles(class_3218 world, class_2394 particle, class_1297 entity1, class_1297 entity2, int count) {
        class_243 startPos = entity1.method_19538().method_1031(0.0, (double)entity1.method_17682() / 2.0, 0.0);
        class_243 endPos = entity2.method_19538().method_1031(0.0, (double)entity2.method_17682() / 2.0, 0.0);
        class_243 direction = endPos.method_1020(startPos);
        double distance = direction.method_1033();
        class_243 normalizedDirection = direction.method_1029();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            class_243 currentPos = startPos.method_1019(normalizedDirection.method_1021(distance * lerpFactor));
            world.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnRainingParticles(class_3218 world, class_2394 particle, class_1297 entity2, int count, double blocksAbove) {
        class_243 endPos = entity2.method_19538().method_1031(0.0, (double)entity2.method_17682() / 2.0, 0.0);
        class_243 startPos = endPos.method_1031(0.0, blocksAbove, 0.0);
        class_243 direction = endPos.method_1020(startPos);
        double distance = direction.method_1033();
        class_243 normalizedDirection = direction.method_1029();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            class_243 currentPos = startPos.method_1019(normalizedDirection.method_1021(distance * lerpFactor));
            world.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesBetween(class_3222 player, class_2338 blockPos, class_3218 world, class_2394 particleType, int particleCount) {
        class_243 start = player.method_19538().method_1031(0.0, (double)player.method_17682() / 2.0, 0.0);
        class_243 end = class_243.method_24953((class_2382)blockPos);
        double stepSize = 1.0 / (double)particleCount;
        for (int i = 0; i <= particleCount; ++i) {
            double t = (double)i * stepSize;
            double x = start.field_1352 + (end.field_1352 - start.field_1352) * t;
            double y = start.field_1351 + (end.field_1351 - start.field_1351) * t;
            double z = start.field_1350 + (end.field_1350 - start.field_1350) * t;
            world.method_14199(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static float spellScaledDamage(String spellSchool, class_1297 entity, float damageModifier, float damageFallback) {
        float scaling = HelperMethods.commonSpellAttributeScaling(damageModifier, entity, spellSchool);
        return scaling > 0.0f ? scaling : damageFallback;
    }

    public static float commonSpellAttributeScaling(float damageModifier, class_1297 entity, String magicSchool) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (((Boolean)Config.general.compatEnableSpellPowerScaling.get()).booleanValue()) {
                return SimplySwordsExpectPlatform.getSpellPowerDamage(damageModifier, player, magicSchool);
            }
        }
        return 0.0f;
    }

    public static Optional<class_1309> findClosestTarget(class_1309 livingEntity, double maxDistance, double width) {
        class_1937 world = livingEntity.method_5770();
        class_243 eyePosition = livingEntity.method_33571();
        class_243 lookVec = livingEntity.method_5828(1.0f);
        class_243 targetVec = eyePosition.method_1031(lookVec.field_1352 * maxDistance, lookVec.field_1351 * maxDistance, lookVec.field_1350 * maxDistance);
        class_243 perpVec = new class_243(-lookVec.field_1350, 0.0, lookVec.field_1352).method_1029().method_1021(width / 2.0);
        class_238 searchBox = new class_238(eyePosition.method_1023(perpVec.field_1352, 1.0, perpVec.field_1350), targetVec.method_1031(perpVec.field_1352, 1.0, perpVec.field_1350));
        List entities = world.method_8390(class_1309.class, searchBox, e -> e != livingEntity);
        return entities.stream().min(Comparator.comparingDouble(e -> e.method_5858((class_1297)livingEntity)));
    }

    public static List<class_1309> getNearbyLivingEntities(class_1937 world, class_243 position, double radius) {
        class_238 searchBox = new class_238(position.field_1352 - radius, position.field_1351 - radius, position.field_1350 - radius, position.field_1352 + radius, position.field_1351 + radius, position.field_1350 + radius);
        return world.method_8390(class_1309.class, searchBox, entity -> true);
    }

    public static double getEntityAttackDamage(class_1309 livingEntity) {
        class_1324 attackDamageAttribute = livingEntity.method_5996(class_5134.field_23721);
        if (attackDamageAttribute != null) {
            return attackDamageAttribute.method_6194();
        }
        return 0.0;
    }

    public static double[] getAttackFromSlot(class_1657 player, class_1799 stack, class_1268 hand) {
        class_9274 attributeModifierSlot;
        double attackValue = 0.0;
        double attackSpeedValue = 0.0;
        class_9274 class_92742 = attributeModifierSlot = hand == class_1268.field_5808 ? class_9274.field_49217 : class_9274.field_49218;
        if (!stack.method_7960()) {
            class_9285 attributeModifiersComponent = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
            for (class_9285.class_9287 entry : attributeModifiersComponent.comp_2393()) {
                if (entry.comp_2395() != class_5134.field_23721 || entry.comp_2397() != attributeModifierSlot) continue;
                attackValue += entry.comp_2396().comp_2449();
            }
        }
        return new double[]{attackValue, attackSpeedValue};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyDamageWithoutKnockback(class_1309 target, class_1282 source, float amount) {
        class_1324 knockbackResistance = target.method_5996(class_5134.field_23718);
        double originalKnockbackResistance = 0.0;
        if (knockbackResistance != null) {
            originalKnockbackResistance = knockbackResistance.method_6194();
            knockbackResistance.method_6192(1.0);
        }
        try {
            target.method_5643(source, amount);
        }
        finally {
            if (knockbackResistance != null) {
                knockbackResistance.method_6192(originalKnockbackResistance);
            }
        }
    }

    public static void spawnDirectionalParticles(class_3218 world, class_2394 particle, class_1297 entity, int count, double distance) {
        class_243 startPos = entity.method_19538().method_1031(0.0, (double)entity.method_17682() / 2.0, 0.0);
        float pitch = entity.method_5695(1.0f);
        float yaw = entity.method_5705(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        class_243 direction = new class_243(xDirection, yDirection, zDirection).method_1029();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            class_243 currentPos = startPos.method_1019(direction.method_1021(distance * lerpFactor));
            world.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void damageEntitiesInTrajectory(class_3218 world, class_1297 sourceEntity, double distance, float damage, class_1282 damageSource) {
        class_243 startPos = sourceEntity.method_19538().method_1031(0.0, (double)sourceEntity.method_17682() / 2.0, 0.0);
        float pitch = sourceEntity.method_5695(1.0f);
        float yaw = sourceEntity.method_5705(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        class_243 direction = new class_243(xDirection, yDirection, zDirection).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(distance));
        double boxSize = 0.5;
        class_238 searchBox = new class_238(startPos, endPos).method_1014(boxSize);
        for (class_1297 entity : world.method_8335(sourceEntity, searchBox)) {
            class_1309 livingTarget;
            class_238 entityBox = entity.method_5829().method_1014((double)entity.method_5871());
            if (!entityBox.method_994(searchBox) || !(sourceEntity instanceof class_1657)) continue;
            class_1657 livingEntity = (class_1657)sourceEntity;
            if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(livingTarget = (class_1309)entity, (class_1309)livingEntity)) continue;
            livingTarget.method_5643(damageSource, damage);
        }
    }

    public static boolean damageThroughIframes(class_1297 targetEntity, class_1282 damageSource, float damage) {
        int iframes = targetEntity.field_6008;
        boolean result = targetEntity.method_5643(damageSource, damage);
        targetEntity.field_6008 = iframes;
        return result;
    }

    public static boolean isInTag(class_1799 stack, class_2960 tagId) {
        if (stack != null && !stack.method_7960()) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)tagId);
            return stack.method_7909().method_40131().method_40220(tag);
        }
        return false;
    }

    public static boolean isHolding(class_1799 stack, class_1309 entity) {
        return entity.method_6118(class_1304.field_6173).equals(stack) || entity.method_6118(class_1304.field_6171).equals(stack);
    }

    public static boolean isHoldingItem(class_1792 item, class_1309 entity) {
        return entity.method_6118(class_1304.field_6173).method_7909().equals(item) || entity.method_6118(class_1304.field_6171).method_7909().equals(item);
    }

    public static boolean hasItemInInventory(class_1657 player, class_1792 item) {
        if (player == null || item == null) {
            return false;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != item) continue;
            return true;
        }
        return false;
    }
}

