/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class RawUpgradableRecipe {
    public static final MapCodec<RawUpgradableRecipe> CODEC = Data.CODEC.flatXmap(RawUpgradableRecipe::fromData, recipe -> recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final class_9139<class_9129, RawUpgradableRecipe> PACKET_CODEC = class_9139.method_56438(RawUpgradableRecipe::writeToBuf, RawUpgradableRecipe::readFromBuf);
    private final int width;
    private final int height;
    private boolean mirrored;
    private final int upgradableItemSlot;
    private final class_2371<class_1856> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public int getUpgradableItemSlot() {
        return this.upgradableItemSlot;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_2371<class_1856> getIngredients() {
        return this.ingredients;
    }

    public RawUpgradableRecipe(int width, int height, int upgradableItemSlot, class_2371<class_1856> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.upgradableItemSlot = upgradableItemSlot;
        this.ingredients = ingredients;
        this.data = data;
        int i = 0;
        for (class_1856 ingredient : ingredients) {
            if (ingredient.method_8103()) continue;
            ++i;
        }
        this.ingredientCount = i;
        this.symmetrical = class_156.method_59901((int)width, (int)height, ingredients);
    }

    private void writeToBuf(class_9129 buf) {
        buf.method_10804(this.width);
        buf.method_10804(this.height);
        for (class_1856 ingredient : this.ingredients) {
            class_1856.field_48355.encode((Object)buf, (Object)ingredient);
        }
        buf.method_10804(this.upgradableItemSlot);
    }

    public boolean matches(class_9694 input) {
        if (input.method_59990() == this.ingredientCount && input.method_59991() == this.width && input.method_59992() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            return this.matches(input, false);
        }
        return false;
    }

    private boolean matches(class_9694 input, boolean mirrored) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                class_1799 itemStack;
                class_1856 ingredient = mirrored ? (class_1856)this.ingredients.get(this.width - j - 1 + i * this.width) : (class_1856)this.ingredients.get(j + i * this.width);
                if (ingredient.method_8093(itemStack = input.method_59985(j, i))) continue;
                return false;
            }
        }
        this.mirrored = mirrored;
        return true;
    }

    private static DataResult<? extends RawUpgradableRecipe> fromData(Data data) {
        String[] pattern = RawUpgradableRecipe.stripWhitespace(data.pattern);
        int height = pattern.length;
        int width = pattern[0].length();
        class_2371 defaultedList = class_2371.method_10213((int)(height * width), (Object)class_1856.field_9017);
        CharArraySet charSet = new CharArraySet(data.key.keySet());
        int upgradableSlot = -1;
        for (int k = 0; k < pattern.length; ++k) {
            String string = pattern[k];
            for (int l = 0; l < string.length(); ++l) {
                boolean upgradable;
                int slot = l + k * width;
                char c = string.charAt(l);
                class_1856 ingredient = c == ' ' ? class_1856.field_9017 : (class_1856)data.key.get(Character.valueOf(c)).getFirst();
                boolean bl = upgradable = c != ' ' && (Boolean)data.key.get(Character.valueOf(c)).getSecond() != false;
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                }
                if (upgradable) {
                    if (upgradableSlot < 0) {
                        upgradableSlot = slot;
                    } else {
                        int finalSlot = upgradableSlot;
                        return DataResult.error(() -> "Pattern attempted to define slot #" + slot + " as upgradable, but slot #" + finalSlot + " is already upgradable");
                    }
                }
                charSet.remove(c);
                defaultedList.set(slot, (Object)ingredient);
            }
        }
        if (upgradableSlot < 0) {
            return DataResult.error(() -> "Pattern does not define a slot as upgradable");
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> RawUpgradableRecipe.lambda$fromData$6((CharSet)charSet));
        }
        return DataResult.success((Object)new RawUpgradableRecipe(width, height, upgradableSlot, (class_2371<class_1856>)defaultedList, Optional.of(data)));
    }

    private static String[] stripWhitespace(List<String> strings) {
        int a = strings.getFirst().length();
        int b = strings.size();
        int c = 0;
        int d = 0;
        for (int y = 0; y < strings.size(); ++y) {
            for (int x = 0; x < strings.getFirst().length(); ++x) {
                if (strings.get(y).charAt(x) == ' ') continue;
                if (x < a) {
                    a = x;
                }
                if (x > c) {
                    c = x;
                }
                if (y < b) {
                    b = y;
                }
                if (y <= d) continue;
                d = y;
            }
        }
        ArrayList<String> strippedStrings = new ArrayList<String>();
        for (int y = 0; y < strings.size(); ++y) {
            if (y < b || y > d) continue;
            strippedStrings.add(strings.get(y).substring(a, c + 1));
        }
        return strippedStrings.toArray(new String[0]);
    }

    private static RawUpgradableRecipe readFromBuf(class_9129 buf) {
        int i = buf.method_10816();
        int j = buf.method_10816();
        class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
        defaultedList.replaceAll(ingredient -> (class_1856)class_1856.field_48355.decode((Object)buf));
        int slot = buf.method_10816();
        return new RawUpgradableRecipe(i, j, slot, (class_2371<class_1856>)defaultedList, Optional.empty());
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    private static /* synthetic */ String lambda$fromData$6(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public record Data(Map<Character, Pair<class_1856, Boolean>> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC;
        private static final Codec<Pair<class_1856, Boolean>> INGREDIENT_CODEC;
        private static final Codec<Character> KEY_ENTRY_CODEC;
        public static final MapCodec<Data> CODEC;

        static {
            INGREDIENT_CODEC = Codec.pair((Codec)class_1856.field_46096, (Codec)Codec.BOOL.optionalFieldOf("upgradable", (Object)false).codec());
            PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
                if (pattern.size() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
                }
                if (pattern.isEmpty()) {
                    return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
                }
                int i = ((String)pattern.getFirst()).length();
                for (String string : pattern) {
                    if (string.length() > 3) {
                        return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                    }
                    if (i == string.length()) continue;
                    return DataResult.error(() -> "Invalid pattern: each row must be the same width");
                }
                return DataResult.success((Object)pattern);
            }, Function.identity());
            KEY_ENTRY_CODEC = Codec.STRING.comapFlatMap(keyEntry -> {
                if (keyEntry.length() != 1) {
                    return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
                }
                return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
            }, String::valueOf);
            CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_53703(KEY_ENTRY_CODEC, INGREDIENT_CODEC).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)instance, Data::new));
        }
    }
}

