/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.sweenus.simplyswords.entity.ThrownSwordEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FrostfallEntity
extends ThrownSwordEntity {
    private int remainingDetonations = 5;
    public double detonateRadius = 8.0;
    public float detonateDamage = 11.0f;
    public int duration = 40;
    public int addedChance = 0;

    public FrostfallEntity(class_1299<? extends FrostfallEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FrostfallEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(world, owner, stack);
        this.stack = stack;
    }

    @Override
    protected void doEffects(class_3218 serverWorld, float baseDamage, class_1297 entity) {
        int bonusParticles = (int)baseDamage / 2;
        HelperMethods.spawnOrbitParticles(serverWorld, this.method_19538(), (class_2394)class_2398.field_11203, 0.5, 3 + bonusParticles);
        HelperMethods.spawnOrbitParticles(serverWorld, this.method_19538(), (class_2394)class_2398.field_11205, 0.5, 5 + bonusParticles);
        HelperMethods.spawnOrbitParticles(serverWorld, this.method_19538(), (class_2394)class_2398.field_11230, 0.5, 2 + bonusParticles);
        if (baseDamage > this.primaryBaseDamage) {
            serverWorld.method_43129(null, entity, (class_3414)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_02.get(), this.method_5634(), 0.3f, 1.2f);
        }
    }

    @Override
    protected class_1799 method_57314() {
        return new class_1799((class_1935)ItemsRegistry.FROSTFALL.get());
    }

    @Override
    protected void doOnTick(class_1297 entity) {
        super.doOnTick(entity);
        if (entity != null && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (this.field_7588) {
                int detonateDelay = 20;
                int chance = 1;
                class_3218 world = (class_3218)this.method_37908();
                class_1282 damageSource = this.method_48923().method_48799((class_1297)this, entity);
                if (this.remainingDetonations <= 0) {
                    this.returnToPlayer = true;
                }
                if (this.field_6012 % detonateDelay == 0 && this.remainingDetonations > 0) {
                    int detonateCount = this.remainingDetonations;
                    class_238 box = HelperMethods.createBox((class_1297)this, this.detonateRadius - (double)detonateCount);
                    for (class_1297 otherEntity : world.method_8333((class_1297)this, box, class_1301.field_6157)) {
                        class_1309 le;
                        if (!(otherEntity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)otherEntity, livingEntity)) continue;
                        HelperMethods.damageThroughIframes((class_1297)le, damageSource, this.detonateDamage - (float)detonateCount);
                        le.method_37222(new class_1293(class_1294.field_5909, this.duration, Math.min(3, 6 - detonateCount)), (class_1297)livingEntity);
                        if (!(le.method_5739((class_1297)this) > 1.0f)) continue;
                        le.method_18800((this.method_23317() - le.method_23317()) / 8.0, (this.method_23318() - le.method_23318()) / 8.0, (this.method_23321() - le.method_23321()) / 8.0);
                    }
                    for (class_1297 otherEntity2 : world.method_8333((class_1297)this, box, class_1301.field_6154)) {
                        if (!(otherEntity2 instanceof FrostfallEntity)) continue;
                        chance = Math.min(50, chance + this.addedChance);
                    }
                    world.method_43129(null, (class_1297)this, (class_3414)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_02.get(), this.method_5634(), 0.6f - (float)detonateCount / 10.0f, 0.8f + (float)detonateCount / 10.0f);
                    HelperMethods.spawnOrbitParticles(world, this.method_19538(), (class_2394)class_2398.field_11203, 6.0f - (float)detonateCount, 9 - detonateCount);
                    HelperMethods.spawnOrbitParticles(world, this.method_19538(), (class_2394)class_2398.field_11205, 6.0f - (float)detonateCount, 15 - detonateCount);
                    HelperMethods.spawnOrbitParticles(world, this.method_19538(), (class_2394)class_2398.field_11230, 6.0f - (float)detonateCount, 10 - detonateCount);
                    HelperMethods.spawnOrbitParticles(world, this.method_19538().method_1031(0.0, 1.0, 0.0), (class_2394)class_2398.field_23956, 6.0f - (float)detonateCount, 40 - detonateCount);
                    if (this.field_5974.method_43048(100) > chance) {
                        --this.remainingDetonations;
                    }
                }
            }
        }
    }

    @Override
    protected byte getLoyalty() {
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return 3;
        }
        return 0;
    }
}

