/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.client.renderer.feature;

import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;

public class ShoulderAxolotlFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private static final class_2960 WILD_AXOLOTL_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/axolotl/axolotl_wild.png");
    private static final class_2960 LUCY_AXOLOTL_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/axolotl/axolotl_lucy.png");
    private static final class_2960 GOLD_AXOLOTL_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/axolotl/axolotl_gold.png");
    private static final class_2960 CYAN_AXOLOTL_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/axolotl/axolotl_cyan.png");
    private static final class_2960 BLUE_AXOLOTL_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/axolotl/axolotl_blue.png");
    private final class_630 axolotlModel;

    public ShoulderAxolotlFeatureRenderer(class_3883<class_742, class_591<class_742>> context, class_630 axolotlModel) {
        super(context);
        this.axolotlModel = axolotlModel;
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float ageInTicks, float netHeadYaw, float headPitch) {
        class_2960 texture;
        if (!player.method_7356().method_33133() && "simplyswords:simplyaxolotlentity".equals(player.method_7356().method_10558("id"))) {
            matrixStack.method_22903();
            this.attachToShoulder(matrixStack, true, player, tickDelta);
            texture = this.getAxolotlTexture(player.method_7356());
            this.renderAxolotl(matrixStack, vertexConsumerProvider, light, texture);
            matrixStack.method_22909();
        }
        if (!player.method_7308().method_33133() && "simplyswords:simplyaxolotlentity".equals(player.method_7308().method_10558("id"))) {
            matrixStack.method_22903();
            this.attachToShoulder(matrixStack, false, player, tickDelta);
            texture = this.getAxolotlTexture(player.method_7308());
            this.renderAxolotl(matrixStack, vertexConsumerProvider, light, texture);
            matrixStack.method_22909();
        }
    }

    private void renderAxolotl(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_2960 texture) {
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23576((class_2960)texture));
        this.axolotlModel.method_22698(matrixStack, vertexConsumer, light, class_4608.field_21444);
    }

    private void attachToShoulder(class_4587 matrixStack, boolean leftShoulder, class_742 player, float tickDelta) {
        int direction = leftShoulder ? -1 : 1;
        float interpolatedBodyYaw = player.field_6220 + (player.field_6283 - player.field_6220) * tickDelta;
        float bodyYawRadians = interpolatedBodyYaw % 360.0f * ((float)Math.PI / 180);
        matrixStack.method_46416((float)direction * 0.4f, player.method_18276() ? -0.1f : -0.4f, 0.15f);
        matrixStack.method_46416(0.0f, -1.0f, -0.2f);
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotation(bodyYawRadians));
        matrixStack.method_46416((float)direction * 0.4f, player.method_18276() ? -0.1f : 0.0f, 0.15f);
        matrixStack.method_46416(0.0f, -1.0f, -0.2f);
        matrixStack.method_22909();
    }

    private class_2960 getAxolotlTexture(class_2487 nbt) {
        int variant = nbt.method_10545("Variant") ? nbt.method_10550("Variant") : 0;
        return switch (variant) {
            case 0 -> LUCY_AXOLOTL_TEXTURE;
            case 1 -> WILD_AXOLOTL_TEXTURE;
            case 2 -> GOLD_AXOLOTL_TEXTURE;
            case 3 -> CYAN_AXOLOTL_TEXTURE;
            case 4 -> BLUE_AXOLOTL_TEXTURE;
            default -> WILD_AXOLOTL_TEXTURE;
        };
    }
}

