/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import java.util.Objects;
import java.util.UUID;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_7413;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class PictureFrameEntityRenderer
extends class_897<PictureFrameEntity> {
    public static final double DISTANCE_FROM_WALL = 0.01;

    public PictureFrameEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(PictureFrameEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        PictureItem.PictureData pictureData;
        class_3966 hitResult;
        class_239 class_2392;
        boolean shouldRenderOutline;
        matrices.method_22903();
        class_243 offset = this.getPositionOffset(entity, tickDelta).method_22882();
        matrices.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        matrices.method_22904(0.5 - (double)entity.getFrameWidth() / 2.0, -0.5 + (double)entity.getFrameHeight() / 2.0, 0.0);
        class_310 client = class_310.method_1551();
        boolean bl = shouldRenderOutline = !this.field_4676.field_4692.field_1842 && CameraItem.find((class_1657)client.field_1724, true) == null && (class_2392 = client.field_1765) instanceof class_3966 && (hitResult = (class_3966)class_2392).method_17782() == entity;
        if (shouldRenderOutline) {
            this.renderOutline(matrices, vertexConsumers, entity.getFrameWidth(), entity.getFrameHeight());
        }
        matrices.method_22904(0.0, 0.0, 0.02625);
        UUID pictureId = null;
        class_1799 stack = entity.getItemStack();
        if (stack != null && (pictureData = PictureItem.getPictureData(stack)) != null) {
            pictureId = pictureData.id();
        }
        if (pictureId == null) {
            this.renderErrorText(matrices, vertexConsumers, light);
        } else {
            RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureId);
            if (picture == null || picture.getStatus() == RemotePicture.Status.ERROR) {
                this.renderErrorText(matrices, vertexConsumers, light);
            } else if (picture.getStatus() == RemotePicture.Status.FETCHING) {
                this.renderFetching(matrices, vertexConsumers, light);
            } else {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f * (float)entity.getRotation()));
                this.renderPicture(matrices, vertexConsumers, picture, entity, light);
            }
        }
        matrices.method_22909();
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public void renderPicture(class_4587 matrices, class_4597 vertexConsumers, RemotePicture picture, PictureFrameEntity entity, int light) {
        float scale = PictureFrameEntityRenderer.getPictureScale(picture, entity);
        float width = (float)picture.getWidth() * scale;
        float height = (float)picture.getHeight() * scale;
        float x1 = -width / 2.0f;
        float x2 = width / 2.0f;
        float y1 = -height / 2.0f;
        float y2 = height / 2.0f;
        class_1921 renderLayer = entity.isPictureGlowing() ? class_1921.method_23028((class_2960)picture.getTextureIdentifier()) : class_1921.method_23576((class_2960)picture.getTextureIdentifier());
        class_4588 buffer = vertexConsumers.getBuffer(renderLayer);
        class_4587.class_4665 matrix = matrices.method_23760();
        Matrix4f matrix4f = matrix.method_23761();
        int effectiveLight = entity.isPictureGlowing() ? 255 : light;
        buffer.method_22918(matrix4f, x1, y1, 0.0f).method_39415(-1).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(effectiveLight).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        buffer.method_22918(matrix4f, x1, y2, 0.0f).method_39415(-1).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(effectiveLight).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        buffer.method_22918(matrix4f, x2, y2, 0.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(effectiveLight).method_60831(matrix, 0.0f, 0.0f, 1.0f);
        buffer.method_22918(matrix4f, x2, y1, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(effectiveLight).method_60831(matrix, 0.0f, 0.0f, 1.0f);
    }

    private static float getPictureScale(RemotePicture picture, PictureFrameEntity entity) {
        float pictureWidth = picture.getWidth();
        float pictureHeight = picture.getHeight();
        if (entity.getRotation() % 2 == 1) {
            pictureWidth = picture.getHeight();
            pictureHeight = picture.getWidth();
        }
        float scaledWidth = (float)entity.getFrameWidth() / pictureWidth;
        float scaleHeight = (float)entity.getFrameHeight() / pictureHeight;
        return Math.min(scaledWidth, scaleHeight);
    }

    public void renderOutline(class_4587 matrices, class_4597 vertexConsumers, float frameWidth, float frameHeight) {
        class_265 shape = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)frameWidth, (double)frameHeight, (double)0.0625);
        class_761.method_22983((class_4587)matrices, (class_4588)vertexConsumers.getBuffer(class_1921.method_23594()), (class_265)shape, (double)(-frameWidth / 2.0f), (double)(-frameHeight / 2.0f), (double)-0.03125, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)true);
    }

    public void renderFetching(class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22905(-0.015625f, -0.015625f, 0.015625f);
        String loading = class_7413.method_43449((long)System.currentTimeMillis());
        class_5250 fetching = class_2561.method_43471((String)"text.camerapture.fetching_picture");
        class_327 class_3272 = this.method_3932();
        Objects.requireNonNull(this.method_3932());
        this.drawCenteredText(class_3272, (class_2561)fetching, 0.0f, (float)(-9) - 0.5f, -1, matrices, vertexConsumers, light);
        this.drawCenteredText(this.method_3932(), (class_2561)class_2561.method_43470((String)loading), 0.0f, 0.5f, -8355712, matrices, vertexConsumers, light);
    }

    public void renderErrorText(class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22905(-0.015625f, -0.015625f, 0.015625f);
        class_5250 text = class_2561.method_43471((String)"text.camerapture.fetching_failed").method_27692(class_124.field_1061);
        class_327 class_3272 = this.method_3932();
        Objects.requireNonNull(this.method_3932());
        this.drawCenteredText(class_3272, (class_2561)text, 0.0f, (float)(-9) / 2.0f, -1, matrices, vertexConsumers, light);
    }

    private void drawCenteredText(class_327 textRenderer, class_2561 text, float x, float y, int color, class_4587 matrices, class_4597 vertexConsumers, int light) {
        float width = textRenderer.method_27525((class_5348)text);
        textRenderer.method_30882(text, x - width / 2.0f, y, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0x7F000000, light);
    }

    public class_2960 getTexture(PictureFrameEntity entity) {
        return null;
    }

    public class_243 getPositionOffset(PictureFrameEntity entity, float tickDelta) {
        Vector3d extra = entity.method_58149().method_23224().transform(new Vector3d((double)(((float)entity.getFrameWidth() - 1.0f) / 2.0f), 0.0, (double)(-entity.getFrameHeight() + 2)));
        return new class_243((double)((float)entity.method_58149().method_10148() * 0.3f) + extra.x, 0.75 + extra.y, (double)((float)entity.method_58149().method_10165() * 0.3f) + extra.z);
    }

    protected boolean hasLabel(PictureFrameEntity entity) {
        return class_310.method_1498() && super.method_3921((class_1297)entity);
    }
}

